/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.client.render.alchemyarray;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;
import wayoftime.bloodmagic.client.render.BloodMagicRenderer;
import wayoftime.bloodmagic.client.render.RenderResizableQuadrilateral;
import wayoftime.bloodmagic.tile.TileAlchemyArray;

public class AlchemyArrayRenderer {
    public final ResourceLocation arrayResource;

    public AlchemyArrayRenderer() {
        this(new ResourceLocation("bloodmagic", "textures/models/alchemyarrays/sightsigil.png"));
    }

    public AlchemyArrayRenderer(ResourceLocation arrayResource) {
        this.arrayResource = arrayResource;
    }

    public float getRotation(float craftTime) {
        float offset = 2.0f;
        if (craftTime >= offset) {
            float modifier = (float)Math.pow(craftTime - offset, 1.5);
            return modifier * 1.0f;
        }
        return 0.0f;
    }

    public float getSecondaryRotation(float craftTime) {
        float offset = 50.0f;
        if (craftTime >= offset) {
            float modifier = (float)Math.pow(craftTime - offset, 1.7);
            return modifier * 0.5f;
        }
        return 0.0f;
    }

    public float getSizeModifier(float craftTime) {
        if (craftTime >= 150.0f && craftTime <= 250.0f) {
            return (200.0f - craftTime) / 50.0f;
        }
        return 1.0f;
    }

    public float getVerticalOffset(float craftTime) {
        if (craftTime >= 5.0f) {
            if (craftTime <= 40.0f) {
                return (float)(-0.4 + 0.4 * Math.pow((craftTime - 5.0f) / 35.0f, 3.0));
            }
            return 0.0f;
        }
        return -0.4f;
    }

    public void renderAt(TileAlchemyArray tileArray, double x, double y, double z, float craftTime, MatrixStack matrixStack, IRenderTypeBuffer renderer, int combinedLightIn, int combinedOverlayIn) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        float rot = this.getRotation(craftTime);
        float secondaryRot = this.getSecondaryRotation(craftTime);
        float size = 1.0f * this.getSizeModifier(craftTime);
        Direction rotation = tileArray.getRotation();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, (double)this.getVerticalOffset(craftTime), 0.0);
        matrixStack.func_227863_a_(new Quaternion(Direction.UP.func_229386_k_(), -rotation.func_185119_l(), true));
        matrixStack.func_227860_a_();
        matrixStack.func_227863_a_(new Quaternion(Direction.UP.func_229386_k_(), rot, true));
        matrixStack.func_227863_a_(new Quaternion(Direction.NORTH.func_229386_k_(), secondaryRot, true));
        matrixStack.func_227863_a_(new Quaternion(Direction.EAST.func_229386_k_(), secondaryRot * 0.45812f, true));
        IVertexBuilder twoDBuffer = renderer.getBuffer(RenderType.func_228644_e_((ResourceLocation)this.arrayResource));
        BloodMagicRenderer.Model2D arrayModel = new BloodMagicRenderer.Model2D();
        arrayModel.minX = -0.5;
        arrayModel.maxX = 0.5;
        arrayModel.minY = -0.5;
        arrayModel.maxY = 0.5;
        arrayModel.resource = this.arrayResource;
        matrixStack.func_227862_a_(size, size, size);
        RenderResizableQuadrilateral.INSTANCE.renderSquare(arrayModel, matrixStack, twoDBuffer, -1, 0xF000F0, OverlayTexture.field_229196_a_);
        matrixStack.func_227865_b_();
        matrixStack.func_227865_b_();
        matrixStack.func_227865_b_();
    }
}

