/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.will;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;

public class DemonWillHolder {
    public HashMap<EnumDemonWillType, Double> willMap = new HashMap();

    public double addWill(EnumDemonWillType type, double amount, double max) {
        double current = 0.0;
        if (this.willMap.containsKey((Object)type)) {
            current = this.willMap.get((Object)type);
        }
        double added = Math.min(max - current, amount);
        this.addWill(type, amount);
        return added;
    }

    public void addWill(EnumDemonWillType type, double amount) {
        if (this.willMap.containsKey((Object)type)) {
            this.willMap.put(type, amount + this.willMap.get((Object)type));
        } else {
            this.willMap.put(type, amount);
        }
    }

    public double drainWill(EnumDemonWillType type, double amount) {
        if (this.willMap.containsKey((Object)type)) {
            double current = this.willMap.get((Object)type);
            double reduced = Math.min(current, amount);
            if (reduced >= current) {
                this.willMap.remove((Object)type);
            } else {
                this.willMap.put(type, current - reduced);
            }
            return reduced;
        }
        return 0.0;
    }

    public double getWill(EnumDemonWillType type) {
        if (this.willMap.containsKey((Object)type)) {
            return this.willMap.get((Object)type);
        }
        return 0.0;
    }

    public void readFromNBT(CompoundNBT tag, String key) {
        CompoundNBT willTag = tag.func_74775_l(key);
        this.willMap.clear();
        for (EnumDemonWillType type : EnumDemonWillType.values()) {
            double amount = willTag.func_74769_h("EnumWill" + type.name());
            if (!(amount > 0.0)) continue;
            this.willMap.put(type, amount);
        }
    }

    public void writeToNBT(CompoundNBT tag, String key) {
        CompoundNBT willTag = new CompoundNBT();
        for (Map.Entry<EnumDemonWillType, Double> entry : this.willMap.entrySet()) {
            willTag.func_74780_a("EnumWill" + entry.getKey().name(), entry.getValue().doubleValue());
        }
        tag.func_218657_a(key, (INBT)willTag);
    }

    public void clearWill() {
        this.willMap.clear();
    }
}

