/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.util.helper;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import wayoftime.bloodmagic.ConfigHandler;
import wayoftime.bloodmagic.altar.IBloodAltar;
import wayoftime.bloodmagic.event.SacrificeKnifeUsedEvent;
import wayoftime.bloodmagic.util.helper.IncenseHelper;

public class PlayerSacrificeHelper {
    public static float scalingOfSacrifice = 1.0f;
    public static int soulFrayDuration = 400;
    public static Potion soulFrayId;

    public static double getPlayerIncense(PlayerEntity player) {
        return IncenseHelper.getCurrentIncense(player);
    }

    public static void setPlayerIncense(PlayerEntity player, double amount) {
        IncenseHelper.setCurrentIncense(player, amount);
    }

    public static boolean incrementIncense(PlayerEntity player, double min, double incenseAddition, double increment) {
        double amount = PlayerSacrificeHelper.getPlayerIncense(player);
        if (amount < min || amount >= incenseAddition) {
            return false;
        }
        amount += Math.min(increment, incenseAddition - amount);
        PlayerSacrificeHelper.setPlayerIncense(player, amount);
        if (amount == incenseAddition) {
            IncenseHelper.setMaxIncense(player, incenseAddition);
        }
        return true;
    }

    public static boolean sacrificePlayerHealth(PlayerEntity player) {
        float maxHealth;
        float health;
        double amount = PlayerSacrificeHelper.getPlayerIncense(player);
        if (amount >= 0.0 && (double)(health = player.func_110143_aJ()) > (double)(maxHealth = player.func_110138_aP()) / 10.0) {
            float sacrificedHealth = health - maxHealth / 10.0f;
            int lpAdded = (int)((double)(sacrificedHealth * (float)ConfigHandler.values.sacrificialDaggerConversion) * PlayerSacrificeHelper.getModifier(amount));
            IBloodAltar altar = PlayerSacrificeHelper.getAltar(player.func_130014_f_(), player.func_233580_cy_());
            if (altar != null) {
                SacrificeKnifeUsedEvent evt = new SacrificeKnifeUsedEvent(player, true, true, (int)sacrificedHealth, lpAdded);
                if (MinecraftForge.EVENT_BUS.post((Event)evt)) {
                    return false;
                }
                altar.sacrificialDaggerCall(evt.lpAdded, false);
                altar.startCycle();
                player.func_70606_j(maxHealth / 10.0f);
                PlayerSacrificeHelper.setPlayerIncense(player, 0.0);
                return true;
            }
        }
        return false;
    }

    public static double getModifier(double amount) {
        return 1.0 + amount * (double)scalingOfSacrifice;
    }

    public static boolean findAndFillAltar(World world, LivingEntity sacrificingEntity, int amount, boolean isSacrifice) {
        IBloodAltar altarEntity = PlayerSacrificeHelper.getAltar(world, sacrificingEntity.func_233580_cy_());
        if (altarEntity == null) {
            return false;
        }
        altarEntity.sacrificialDaggerCall(amount, isSacrifice);
        altarEntity.startCycle();
        return true;
    }

    public static IBloodAltar getAltar(World world, BlockPos blockPos) {
        for (int x = -2; x <= 2; ++x) {
            for (int y = -2; y <= 1; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    TileEntity tileEntity = world.func_175625_s(blockPos.func_177982_a(x, y, z));
                    if (!(tileEntity instanceof IBloodAltar)) continue;
                    return (IBloodAltar)tileEntity;
                }
            }
        }
        return null;
    }
}

