/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.util.handler.event;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.common.Mod;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.client.render.BloodMagicRenderer;
import wayoftime.bloodmagic.client.render.RenderResizableCuboid;
import wayoftime.bloodmagic.client.utils.BMRenderTypes;
import wayoftime.bloodmagic.common.item.ItemRitualDiviner;
import wayoftime.bloodmagic.common.item.ItemRitualReader;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumRitualReaderState;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.tile.TileMasterRitualStone;
import wayoftime.bloodmagic.will.DemonWillHolder;

@Mod.EventBusSubscriber(modid="bloodmagic", value={Dist.CLIENT})
public class ClientHandler {
    public static final boolean SUPPRESS_ASSET_ERRORS = true;
    public static ResourceLocation ritualStoneBlank = BloodMagic.rl("block/ritualstone");
    public static ResourceLocation ritualStoneWater = BloodMagic.rl("block/waterritualstone");
    public static ResourceLocation ritualStoneFire = BloodMagic.rl("block/fireritualstone");
    public static ResourceLocation ritualStoneEarth = BloodMagic.rl("block/earthritualstone");
    public static ResourceLocation ritualStoneAir = BloodMagic.rl("block/airritualstone");
    public static ResourceLocation ritualStoneDawn = BloodMagic.rl("block/dawnritualstone");
    public static ResourceLocation ritualStoneDusk = BloodMagic.rl("block/duskritualstone");
    public static ResourceLocation boarder = new ResourceLocation("block/chiseled_sandstone");
    public static TextureAtlasSprite blankBloodRune;
    public static TextureAtlasSprite stoneBrick;
    public static TextureAtlasSprite glowstone;
    public static TextureAtlasSprite beacon;
    public static Minecraft minecraft;
    private static TileMasterRitualStone mrsHoloTile;
    private static TileMasterRitualStone mrsRangeTile;
    private static Ritual mrsHoloRitual;
    private static Direction mrsHoloDirection;
    private static boolean mrsHoloDisplay;
    private static boolean mrsRangeDisplay;
    public static DemonWillHolder currentAura;
    static HashMap<String, ResourceLocation> resourceMap;

    public static Minecraft mc() {
        return Minecraft.func_71410_x();
    }

    public static void bindTexture(String path) {
        ClientHandler.mc().func_110434_K().func_110577_a(ClientHandler.getResource(path));
    }

    public static void bindAtlas() {
        ClientHandler.mc().func_110434_K().func_110577_a(PlayerContainer.field_226615_c_);
    }

    public static ResourceLocation getResource(String path) {
        ResourceLocation rl;
        ResourceLocation resourceLocation = rl = resourceMap.containsKey(path) ? resourceMap.get(path) : new ResourceLocation(path);
        if (!resourceMap.containsKey(path)) {
            resourceMap.put(path, rl);
        }
        return rl;
    }

    public static TextureAtlasSprite getSprite(ResourceLocation rl) {
        return ClientHandler.mc().func_209506_al().func_229356_a_(PlayerContainer.field_226615_c_).func_195424_a(rl);
    }

    @SubscribeEvent
    public static void onTextureStitch(TextureStitchEvent.Pre event) {
        String BLOCKS = "block/";
        blankBloodRune = ClientHandler.forName(event.getMap(), "blankrune", "block/");
        stoneBrick = event.getMap().func_195424_a(new ResourceLocation("minecraft:block/stonebrick"));
        glowstone = event.getMap().func_195424_a(new ResourceLocation("minecraft:block/glowstone"));
        beacon = event.getMap().func_195424_a(new ResourceLocation("minecraft:block/beacon"));
    }

    @SubscribeEvent
    public static void render(RenderWorldLastEvent event) {
        MatrixStack stack;
        IRenderTypeBuffer.Impl buffers;
        ClientPlayerEntity player = ClientHandler.minecraft.field_71439_g;
        World world = player.func_130014_f_();
        if (mrsHoloTile != null) {
            if (world.func_175625_s(mrsHoloTile.func_174877_v()) instanceof TileMasterRitualStone) {
                if (mrsHoloDisplay) {
                    buffers = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
                    stack = event.getMatrixStack();
                    ClientHandler.renderRitualStones(stack, (IRenderTypeBuffer)buffers, mrsHoloTile, event.getPartialTicks());
                    RenderSystem.disableDepthTest();
                    buffers.func_228461_a_();
                } else {
                    ClientHandler.setRitualHoloToNull();
                }
            } else {
                ClientHandler.setRitualHoloToNull();
            }
        }
        if (mrsRangeTile != null) {
            if (world.func_175625_s(mrsRangeTile.func_174877_v()) instanceof TileMasterRitualStone) {
                if (mrsRangeDisplay) {
                    buffers = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
                    stack = event.getMatrixStack();
                    ClientHandler.renderRangeHologram(stack, (IRenderTypeBuffer)buffers, mrsRangeTile, event.getPartialTicks());
                    RenderSystem.disableDepthTest();
                    buffers.func_228461_a_();
                } else {
                    ClientHandler.setRitualRangeHoloToNull();
                }
            } else {
                ClientHandler.setRitualRangeHoloToNull();
            }
        }
        if (ClientHandler.minecraft.field_71476_x == null || ClientHandler.minecraft.field_71476_x.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return;
        }
        TileEntity tileEntity = world.func_175625_s(((BlockRayTraceResult)ClientHandler.minecraft.field_71476_x).func_216350_a());
        if (tileEntity instanceof TileMasterRitualStone && !player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() instanceof ItemRitualDiviner) {
            IRenderTypeBuffer.Impl buffers2 = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
            MatrixStack stack2 = event.getMatrixStack();
            ClientHandler.renderRitualStones(stack2, (IRenderTypeBuffer)buffers2, player, event.getPartialTicks());
            RenderSystem.disableDepthTest();
            buffers2.func_228461_a_();
        }
    }

    private static TextureAtlasSprite forName(AtlasTexture textureMap, String name, String dir) {
        return textureMap.func_195424_a(new ResourceLocation("bloodmagic" + dir + "/" + name));
    }

    private static void renderRitualStones(MatrixStack stack, IRenderTypeBuffer renderer, ClientPlayerEntity player, float partialTicks) {
        ActiveRenderInfo activerenderinfo = Minecraft.func_71410_x().field_71460_t.func_215316_n();
        Vector3d eyePos = activerenderinfo.func_216785_c();
        IVertexBuilder buffer = renderer.getBuffer(Atlases.func_228785_j_());
        World world = player.func_130014_f_();
        ItemRitualDiviner ritualDiviner = (ItemRitualDiviner)player.field_71071_by.func_70448_g().func_77973_b();
        Direction direction = ritualDiviner.getDirection(player.field_71071_by.func_70448_g());
        Ritual ritual = BloodMagic.RITUAL_MANAGER.getRitual(ritualDiviner.getCurrentRitual(player.field_71071_by.func_70448_g()));
        if (ritual == null) {
            return;
        }
        BlockPos vec3 = ((BlockRayTraceResult)ClientHandler.minecraft.field_71476_x).func_216350_a();
        ArrayList components = Lists.newArrayList();
        ritual.gatherComponents(components::add);
        for (RitualComponent ritualComponent : components) {
            stack.func_227860_a_();
            BlockPos vX = vec3.func_177971_a((Vector3i)ritualComponent.getOffset(direction));
            double minX = (double)vX.func_177958_n() - eyePos.field_72450_a;
            double minY = (double)vX.func_177956_o() - eyePos.field_72448_b;
            double minZ = (double)vX.func_177952_p() - eyePos.field_72449_c;
            stack.func_227861_a_(minX, minY, minZ);
            if (!world.func_180495_p(vX).func_200015_d((IBlockReader)world, vX)) {
                ResourceLocation rl = null;
                switch (ritualComponent.getRuneType()) {
                    case BLANK: {
                        rl = ritualStoneBlank;
                        break;
                    }
                    case WATER: {
                        rl = ritualStoneWater;
                        break;
                    }
                    case FIRE: {
                        rl = ritualStoneFire;
                        break;
                    }
                    case EARTH: {
                        rl = ritualStoneEarth;
                        break;
                    }
                    case AIR: {
                        rl = ritualStoneAir;
                        break;
                    }
                    case DAWN: {
                        rl = ritualStoneDawn;
                        break;
                    }
                    case DUSK: {
                        rl = ritualStoneDusk;
                    }
                }
                BloodMagicRenderer.Model3D model = ClientHandler.getBlockModel(rl);
                RenderResizableCuboid.INSTANCE.renderCube(model, stack, buffer, -570425345, 0xF000F0, OverlayTexture.field_229196_a_);
            }
            stack.func_227865_b_();
        }
    }

    public static void renderRitualStones(MatrixStack stack, IRenderTypeBuffer renderer, TileMasterRitualStone masterRitualStone, float partialTicks) {
        ActiveRenderInfo activerenderinfo = Minecraft.func_71410_x().field_71460_t.func_215316_n();
        Vector3d eyePos = activerenderinfo.func_216785_c();
        IVertexBuilder buffer = renderer.getBuffer(Atlases.func_228785_j_());
        ClientPlayerEntity player = ClientHandler.minecraft.field_71439_g;
        World world = player.func_130014_f_();
        Direction direction = mrsHoloDirection;
        Ritual ritual = mrsHoloRitual;
        if (ritual == null) {
            return;
        }
        BlockPos vec3 = masterRitualStone.func_174877_v();
        ArrayList components = Lists.newArrayList();
        ritual.gatherComponents(components::add);
        for (RitualComponent ritualComponent : components) {
            stack.func_227860_a_();
            BlockPos vX = vec3.func_177971_a((Vector3i)ritualComponent.getOffset(direction));
            double minX = (double)vX.func_177958_n() - eyePos.field_72450_a;
            double minY = (double)vX.func_177956_o() - eyePos.field_72448_b;
            double minZ = (double)vX.func_177952_p() - eyePos.field_72449_c;
            stack.func_227861_a_(minX, minY, minZ);
            if (!world.func_180495_p(vX).func_200015_d((IBlockReader)world, vX)) {
                ResourceLocation rl = null;
                switch (ritualComponent.getRuneType()) {
                    case BLANK: {
                        rl = ritualStoneBlank;
                        break;
                    }
                    case WATER: {
                        rl = ritualStoneWater;
                        break;
                    }
                    case FIRE: {
                        rl = ritualStoneFire;
                        break;
                    }
                    case EARTH: {
                        rl = ritualStoneEarth;
                        break;
                    }
                    case AIR: {
                        rl = ritualStoneAir;
                        break;
                    }
                    case DAWN: {
                        rl = ritualStoneDawn;
                        break;
                    }
                    case DUSK: {
                        rl = ritualStoneDusk;
                    }
                }
                BloodMagicRenderer.Model3D model = ClientHandler.getBlockModel(rl);
                RenderResizableCuboid.INSTANCE.renderCube(model, stack, buffer, -570425345, 0xF000F0, OverlayTexture.field_229196_a_);
            }
            stack.func_227865_b_();
        }
    }

    public static void renderRangeHologram(MatrixStack stack, IRenderTypeBuffer renderer, TileMasterRitualStone masterRitualStone, float partialTicks) {
        ItemStack itemStack;
        EnumRitualReaderState state;
        ActiveRenderInfo activerenderinfo = Minecraft.func_71410_x().field_71460_t.func_215316_n();
        Vector3d eyePos = activerenderinfo.func_216785_c();
        IVertexBuilder buffer = renderer.getBuffer(Atlases.func_228785_j_());
        ClientPlayerEntity player = ClientHandler.minecraft.field_71439_g;
        World world = player.func_130014_f_();
        if (!player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() instanceof ItemRitualReader && (state = ((ItemRitualReader)(itemStack = player.func_184614_ca()).func_77973_b()).getState(itemStack)) == EnumRitualReaderState.SET_AREA) {
            String range = ((ItemRitualReader)itemStack.func_77973_b()).getCurrentBlockRange(itemStack);
            AreaDescriptor descriptor = masterRitualStone.getBlockRange(range);
            if (descriptor == null) {
                return;
            }
            stack.func_227860_a_();
            BlockPos vec3 = masterRitualStone.func_174877_v();
            AxisAlignedBB aabb = descriptor.getAABB(vec3);
            double sizeOffset = -0.0625;
            if (aabb.func_72318_a(eyePos)) {
                sizeOffset *= -1.0;
            }
            double minX = aabb.field_72340_a - eyePos.field_72450_a + sizeOffset;
            double minY = aabb.field_72338_b - eyePos.field_72448_b + sizeOffset;
            double minZ = aabb.field_72339_c - eyePos.field_72449_c + sizeOffset;
            stack.func_227861_a_(minX, minY, minZ);
            ResourceLocation rl = boarder;
            BloodMagicRenderer.Model3D model = ClientHandler.getBlockModelWithSize(rl, aabb.func_216364_b() - 2.0 * sizeOffset, aabb.func_216360_c() - 2.0 * sizeOffset, aabb.func_216362_d() - 2.0 * sizeOffset);
            RenderResizableCuboid.INSTANCE.renderCube(model, stack, buffer, -1711324092, 0xF000F0, OverlayTexture.field_229196_a_);
            stack.func_227865_b_();
        }
    }

    private static BloodMagicRenderer.Model3D getBlockModel(ResourceLocation rl) {
        BloodMagicRenderer.Model3D model = new BloodMagicRenderer.Model3D();
        model.setTexture((TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(rl));
        model.minX = 0.0;
        model.minY = 0.0;
        model.minZ = 0.0;
        model.maxX = 1.0;
        model.maxY = 1.0;
        model.maxZ = 1.0;
        return model;
    }

    private static BloodMagicRenderer.Model3D getBlockModelWithSize(ResourceLocation rl, double maxX, double maxY, double maxZ) {
        BloodMagicRenderer.Model3D model = new BloodMagicRenderer.Model3D();
        model.setTexture((TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(rl));
        model.minX = 0.0;
        model.minY = 0.0;
        model.minZ = 0.0;
        model.maxX = maxX;
        model.maxY = maxY;
        model.maxZ = maxZ;
        return model;
    }

    public static void setRitualHolo(TileMasterRitualStone masterRitualStone, Ritual ritual, Direction direction, boolean displayed) {
        mrsHoloDisplay = displayed;
        mrsHoloTile = masterRitualStone;
        mrsHoloRitual = ritual;
        mrsHoloDirection = direction;
    }

    public static void setRitualHoloToNull() {
        mrsHoloDisplay = false;
        mrsHoloTile = null;
        mrsHoloRitual = null;
        mrsHoloDirection = Direction.NORTH;
    }

    public static void setRitualRangeHolo(TileMasterRitualStone masterRitualStone, boolean displayed) {
        mrsRangeDisplay = displayed;
        mrsRangeTile = masterRitualStone;
    }

    public static void setRitualRangeHoloToNull() {
        mrsRangeDisplay = false;
        mrsRangeTile = null;
    }

    public static void handleGuiTank(MatrixStack transform, IFluidTank tank, int x, int y, int w, int h, int oX, int oY, int oW, int oH, int mX, int mY, String originalTexture, List<ITextComponent> tooltip) {
        ClientHandler.handleGuiTank(transform, tank.getFluid(), tank.getCapacity(), x, y, w, h, oX, oY, oW, oH, mX, mY, originalTexture, tooltip);
    }

    public static void handleGuiTank(MatrixStack transform, FluidStack fluid, int capacity, int x, int y, int w, int h, int oX, int oY, int oW, int oH, int mX, int mY, String originalTexture, List<ITextComponent> tooltip) {
        if (tooltip == null) {
            transform.func_227860_a_();
            IRenderTypeBuffer.Impl buffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
            if (fluid != null && fluid.getFluid() != null) {
                int fluidHeight = (int)((float)h * ((float)fluid.getAmount() / (float)capacity));
                ClientHandler.drawRepeatedFluidSpriteGui((IRenderTypeBuffer)buffer, transform, fluid, x, y + h - fluidHeight, w, fluidHeight);
                RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            }
            int xOff = (w - oW) / 2;
            int yOff = (h - oH) / 2;
            RenderType renderType = BMRenderTypes.getGui(new ResourceLocation(originalTexture));
            ClientHandler.drawTexturedRect(buffer.getBuffer(renderType), transform, x + xOff, y + yOff, oW, oH, 256.0f, oX, oX + oW, oY, oY + oH);
            buffer.func_228462_a_(renderType);
            transform.func_227865_b_();
        } else if (mX >= x && mX < x + w && mY >= y && mY < y + h) {
            ClientHandler.addFluidTooltip(fluid, tooltip, capacity);
        }
    }

    public static void drawRepeatedFluidSpriteGui(IRenderTypeBuffer buffer, MatrixStack transform, FluidStack fluid, float x, float y, float w, float h) {
        RenderType renderType = BMRenderTypes.getGui(PlayerContainer.field_226615_c_);
        IVertexBuilder builder = buffer.getBuffer(renderType);
        ClientHandler.drawRepeatedFluidSprite(builder, transform, fluid, x, y, w, h);
    }

    public static void drawRepeatedFluidSprite(IVertexBuilder builder, MatrixStack transform, FluidStack fluid, float x, float y, float w, float h) {
        TextureAtlasSprite sprite = ClientHandler.getSprite(fluid.getFluid().getAttributes().getStillTexture(fluid));
        int col = fluid.getFluid().getAttributes().getColor(fluid);
        int iW = sprite.func_94211_a();
        int iH = sprite.func_94216_b();
        if (iW > 0 && iH > 0) {
            ClientHandler.drawRepeatedSprite(builder, transform, x, y, w, h, iW, iH, sprite.func_94209_e(), sprite.func_94212_f(), sprite.func_94206_g(), sprite.func_94210_h(), (float)(col >> 16 & 0xFF) / 255.0f, (float)(col >> 8 & 0xFF) / 255.0f, (float)(col & 0xFF) / 255.0f, 1.0f);
        }
    }

    public static void drawRepeatedSprite(IVertexBuilder builder, MatrixStack transform, float x, float y, float w, float h, int iconWidth, int iconHeight, float uMin, float uMax, float vMin, float vMax, float r, float g, float b, float alpha) {
        int iterMaxW = (int)(w / (float)iconWidth);
        int iterMaxH = (int)(h / (float)iconHeight);
        float leftoverW = w % (float)iconWidth;
        float leftoverH = h % (float)iconHeight;
        float leftoverWf = leftoverW / (float)iconWidth;
        float leftoverHf = leftoverH / (float)iconHeight;
        float iconUDif = uMax - uMin;
        float iconVDif = vMax - vMin;
        for (int ww = 0; ww < iterMaxW; ++ww) {
            for (int hh = 0; hh < iterMaxH; ++hh) {
                ClientHandler.drawTexturedRect(builder, transform, x + (float)(ww * iconWidth), y + (float)(hh * iconHeight), iconWidth, iconHeight, r, g, b, alpha, uMin, uMax, vMin, vMax);
            }
            ClientHandler.drawTexturedRect(builder, transform, x + (float)(ww * iconWidth), y + (float)(iterMaxH * iconHeight), iconWidth, leftoverH, r, g, b, alpha, uMin, uMax, vMin, vMin + iconVDif * leftoverHf);
        }
        if (leftoverW > 0.0f) {
            for (int hh = 0; hh < iterMaxH; ++hh) {
                ClientHandler.drawTexturedRect(builder, transform, x + (float)(iterMaxW * iconWidth), y + (float)(hh * iconHeight), leftoverW, iconHeight, r, g, b, alpha, uMin, uMin + iconUDif * leftoverWf, vMin, vMax);
            }
            ClientHandler.drawTexturedRect(builder, transform, x + (float)(iterMaxW * iconWidth), y + (float)(iterMaxH * iconHeight), leftoverW, leftoverH, r, g, b, alpha, uMin, uMin + iconUDif * leftoverWf, vMin, vMin + iconVDif * leftoverHf);
        }
    }

    public static void drawTexturedRect(IVertexBuilder builder, MatrixStack transform, float x, float y, float w, float h, float r, float g, float b, float alpha, float u0, float u1, float v0, float v1) {
        Matrix4f mat = transform.func_227866_c_().func_227870_a_();
        builder.func_227888_a_(mat, x, y + h, 0.0f).func_227885_a_(r, g, b, alpha).func_225583_a_(u0, v1).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_225584_a_(1.0f, 1.0f, 1.0f).func_181675_d();
        builder.func_227888_a_(mat, x + w, y + h, 0.0f).func_227885_a_(r, g, b, alpha).func_225583_a_(u1, v1).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_225584_a_(1.0f, 1.0f, 1.0f).func_181675_d();
        builder.func_227888_a_(mat, x + w, y, 0.0f).func_227885_a_(r, g, b, alpha).func_225583_a_(u1, v0).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_225584_a_(1.0f, 1.0f, 1.0f).func_181675_d();
        builder.func_227888_a_(mat, x, y, 0.0f).func_227885_a_(r, g, b, alpha).func_225583_a_(u0, v0).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_225584_a_(1.0f, 1.0f, 1.0f).func_181675_d();
    }

    public static void drawTexturedRect(IVertexBuilder builder, MatrixStack transform, int x, int y, int w, int h, float picSize, int u0, int u1, int v0, int v1) {
        ClientHandler.drawTexturedRect(builder, transform, x, y, w, h, 1.0f, 1.0f, 1.0f, 1.0f, (float)u0 / picSize, (float)u1 / picSize, (float)v0 / picSize, (float)v1 / picSize);
    }

    public static void addFluidTooltip(FluidStack fluid, List<ITextComponent> tooltip, int tankCapacity) {
        if (!fluid.isEmpty()) {
            tooltip.add((ITextComponent)ClientHandler.applyFormat(fluid.getDisplayName(), fluid.getFluid().getAttributes().getRarity((FluidStack)fluid).field_77937_e));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("gui.bloodmagic.empty"));
        }
        if (ClientHandler.mc().field_71474_y.field_82882_x && !fluid.isEmpty()) {
            if (!Screen.func_231173_s_()) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.holdShiftForInfo"));
            } else {
                tooltip.add((ITextComponent)ClientHandler.applyFormat((ITextComponent)new StringTextComponent("Fluid Registry: " + fluid.getFluid().getRegistryName()), TextFormatting.DARK_GRAY));
                tooltip.add((ITextComponent)ClientHandler.applyFormat((ITextComponent)new StringTextComponent("Density: " + fluid.getFluid().getAttributes().getDensity(fluid)), TextFormatting.DARK_GRAY));
                tooltip.add((ITextComponent)ClientHandler.applyFormat((ITextComponent)new StringTextComponent("Temperature: " + fluid.getFluid().getAttributes().getTemperature(fluid)), TextFormatting.DARK_GRAY));
                tooltip.add((ITextComponent)ClientHandler.applyFormat((ITextComponent)new StringTextComponent("Viscosity: " + fluid.getFluid().getAttributes().getViscosity(fluid)), TextFormatting.DARK_GRAY));
                tooltip.add((ITextComponent)ClientHandler.applyFormat((ITextComponent)new StringTextComponent("NBT Data: " + fluid.getTag()), TextFormatting.DARK_GRAY));
            }
        }
        if (tankCapacity > 0) {
            tooltip.add((ITextComponent)ClientHandler.applyFormat((ITextComponent)new StringTextComponent(fluid.getAmount() + "/" + tankCapacity + "mB"), TextFormatting.GRAY));
        } else {
            tooltip.add((ITextComponent)ClientHandler.applyFormat((ITextComponent)new StringTextComponent(fluid.getAmount() + "mB"), TextFormatting.GRAY));
        }
    }

    public static IFormattableTextComponent applyFormat(ITextComponent component, TextFormatting ... color) {
        Style style = component.func_150256_b();
        for (TextFormatting format : color) {
            style = style.func_240721_b_(format);
        }
        return component.func_230532_e_().func_230530_a_(style);
    }

    static {
        minecraft = Minecraft.func_71410_x();
        resourceMap = new HashMap();
    }
}

