/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.util;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class MultiSlotItemHandler
implements IItemHandler {
    private ItemStack[] items;
    private final int invLimit;

    public MultiSlotItemHandler(int size, int invLimit) {
        this.items = new ItemStack[size];
        for (int i = 0; i < size; ++i) {
            this.items[i] = ItemStack.field_190927_a;
        }
        this.invLimit = invLimit;
    }

    public MultiSlotItemHandler(ItemStack[] items, int invLimit) {
        this.items = items;
        this.invLimit = invLimit;
    }

    public int getSlots() {
        return this.items.length;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.items[slot];
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return true;
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
        this.items[slot] = stack;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stackInSlot = this.getStackInSlot(slot);
        if (!stackInSlot.func_190926_b()) {
            if (stackInSlot.func_190916_E() >= Math.min(stackInSlot.func_77976_d(), this.getSlotLimit(slot))) {
                return stack;
            }
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)stackInSlot)) {
                return stack;
            }
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            int m = Math.min(stack.func_77976_d(), this.getSlotLimit(slot)) - stackInSlot.func_190916_E();
            if (stack.func_190916_E() <= m) {
                if (!simulate) {
                    ItemStack copy = stack.func_77946_l();
                    copy.func_190917_f(stackInSlot.func_190916_E());
                    this.setInventorySlotContents(slot, copy);
                }
                return ItemStack.field_190927_a;
            }
            stack = stack.func_77946_l();
            if (!simulate) {
                ItemStack copy = stack.func_77979_a(m);
                copy.func_190917_f(stackInSlot.func_190916_E());
                this.setInventorySlotContents(slot, copy);
                return stack;
            }
            stack.func_190918_g(m);
            return stack;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        int m = Math.min(stack.func_77976_d(), this.getSlotLimit(slot));
        if (m < stack.func_190916_E()) {
            stack = stack.func_77946_l();
            if (!simulate) {
                this.setInventorySlotContents(slot, stack.func_77979_a(m));
                return stack;
            }
            stack.func_190918_g(m);
            return stack;
        }
        if (!simulate) {
            this.setInventorySlotContents(slot, stack);
        }
        return ItemStack.field_190927_a;
    }

    public boolean canTransferAllItemsToSlots(List<ItemStack> stackList, boolean simulate) {
        ItemStack[] copyList = new ItemStack[this.items.length];
        for (int i = 0; i < copyList.length; ++i) {
            copyList[i] = this.items[i].func_77946_l();
        }
        boolean hasStashedAll = true;
        for (ItemStack stack : stackList) {
            if (stack.func_190926_b()) continue;
            for (int slot = 0; slot < copyList.length; ++slot) {
                int m;
                ItemStack stackInSlot = copyList[slot];
                if (!stackInSlot.func_190926_b()) {
                    ItemStack copy;
                    if (stackInSlot.func_190916_E() >= Math.min(stackInSlot.func_77976_d(), this.getSlotLimit(slot)) || !ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)stackInSlot) || !this.isItemValid(slot, stack)) continue;
                    m = Math.min(stack.func_77976_d(), this.getSlotLimit(slot)) - stackInSlot.func_190916_E();
                    if (stack.func_190916_E() <= m) {
                        copy = stack.func_77946_l();
                        if (!simulate) {
                            copy.func_190917_f(stackInSlot.func_190916_E());
                            copyList[slot] = copy;
                        }
                        stack = ItemStack.field_190927_a;
                        break;
                    }
                    stack = stack.func_77946_l();
                    if (!simulate) {
                        copy = stack.func_77979_a(m);
                        copy.func_190917_f(stackInSlot.func_190916_E());
                        copyList[slot] = copy;
                        continue;
                    }
                    stack.func_190918_g(m);
                    continue;
                }
                if (!this.isItemValid(slot, stack)) continue;
                m = Math.min(stack.func_77976_d(), this.getSlotLimit(slot));
                if (m < stack.func_190916_E()) {
                    stack = stack.func_77946_l();
                    if (!simulate) {
                        copyList[slot] = stack.func_77979_a(m);
                        continue;
                    }
                    stack.func_190918_g(m);
                    continue;
                }
                if (!simulate) {
                    copyList[slot] = stack;
                }
                stack = ItemStack.field_190927_a;
            }
            if (stack.func_190926_b()) continue;
            hasStashedAll = false;
            break;
        }
        if (!simulate) {
            this.items = copyList;
        }
        return hasStashedAll;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack stackInSlot = this.getStackInSlot(slot);
        if (stackInSlot.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (simulate) {
            if (stackInSlot.func_190916_E() < amount) {
                return stackInSlot.func_77946_l();
            }
            ItemStack copy = stackInSlot.func_77946_l();
            copy.func_190920_e(amount);
            return copy;
        }
        int m = Math.min(stackInSlot.func_190916_E(), amount);
        ItemStack decrStackSize = this.decrStackSize(slot, m);
        return decrStackSize;
    }

    public ItemStack decrStackSize(int slot, int amount) {
        if (!this.getStackInSlot(slot).func_190926_b()) {
            if (this.getStackInSlot(slot).func_190916_E() <= amount) {
                ItemStack itemStack = this.getStackInSlot(slot);
                this.setInventorySlotContents(slot, ItemStack.field_190927_a);
                return itemStack;
            }
            ItemStack itemStack = this.getStackInSlot(slot).func_77979_a(amount);
            return itemStack;
        }
        return ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        return this.invLimit;
    }
}

