/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.tile.routing;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.commons.lang3.tuple.Triple;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.common.item.routing.IRouterUpgrade;
import wayoftime.bloodmagic.common.routing.IInputItemRoutingNode;
import wayoftime.bloodmagic.common.routing.IItemFilter;
import wayoftime.bloodmagic.common.routing.IMasterRoutingNode;
import wayoftime.bloodmagic.common.routing.IOutputItemRoutingNode;
import wayoftime.bloodmagic.common.routing.IRoutingNode;
import wayoftime.bloodmagic.common.routing.NodeHelper;
import wayoftime.bloodmagic.demonaura.WorldDemonWillHandler;
import wayoftime.bloodmagic.tile.TileInventory;
import wayoftime.bloodmagic.tile.container.ContainerMasterRoutingNode;

public class TileMasterRoutingNode
extends TileInventory
implements IMasterRoutingNode,
ITickableTileEntity,
INamedContainerProvider {
    @ObjectHolder(value="bloodmagic:masterroutingnode")
    public static TileEntityType<TileMasterRoutingNode> TYPE;
    public static final int tickRate = 20;
    private int currentInput;
    private TreeMap<BlockPos, List<BlockPos>> connectionMap = new TreeMap();
    private List<BlockPos> generalNodeList = new LinkedList<BlockPos>();
    private List<BlockPos> outputNodeList = new LinkedList<BlockPos>();
    private List<BlockPos> inputNodeList = new LinkedList<BlockPos>();
    private static final int TREE_OFFSET = 10;
    public static final int SLOT = 0;

    public TileMasterRoutingNode(TileEntityType<?> type) {
        super(type, 1, "masterroutingnode");
    }

    public TileMasterRoutingNode() {
        this(TYPE);
    }

    /*
     * WARNING - void declaration
     */
    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            this.currentInput = this.func_145831_w().func_175676_y(this.field_174879_c);
        }
        if (this.func_145831_w().field_72995_K || this.func_145831_w().func_82737_E() % 20L != 0L) {
            return;
        }
        TreeMap outputMap = new TreeMap();
        for (BlockPos blockPos : this.outputNodeList) {
            TileEntity outputTile = this.func_145831_w().func_175625_s(blockPos);
            if (!this.isConnected(new LinkedList<BlockPos>(), blockPos) || !(outputTile instanceof IOutputItemRoutingNode)) continue;
            IOutputItemRoutingNode outputNode = (IOutputItemRoutingNode)outputTile;
            for (Direction facing : Direction.values()) {
                IItemFilter filter;
                if (!outputNode.isInventoryConnectedToSide(facing) || !outputNode.isOutput(facing) || (filter = outputNode.getOutputFilterForSide(facing)) == null) continue;
                int priority = outputNode.getPriority(facing);
                if (outputMap.containsKey(10 - priority)) {
                    ((List)outputMap.get(10 - priority)).add(filter);
                    continue;
                }
                LinkedList<IItemFilter> filterList = new LinkedList<IItemFilter>();
                filterList.add(filter);
                outputMap.put(10 - priority, filterList);
            }
        }
        TreeMap inputMap = new TreeMap();
        for (BlockPos inputPos : this.inputNodeList) {
            TileEntity inputTile = this.func_145831_w().func_175625_s(inputPos);
            if (!this.isConnected(new LinkedList<BlockPos>(), inputPos) || !(inputTile instanceof IInputItemRoutingNode)) continue;
            IInputItemRoutingNode inputNode = (IInputItemRoutingNode)inputTile;
            for (Direction facing : Direction.values()) {
                IItemFilter filter;
                if (!inputNode.isInventoryConnectedToSide(facing) || !inputNode.isInput(facing) || (filter = inputNode.getInputFilterForSide(facing)) == null) continue;
                int priority = inputNode.getPriority(facing);
                if (inputMap.containsKey(10 - priority)) {
                    ((List)inputMap.get(10 - priority)).add(filter);
                    continue;
                }
                LinkedList<IItemFilter> filterList = new LinkedList<IItemFilter>();
                filterList.add(filter);
                inputMap.put(10 - priority, filterList);
            }
        }
        int n = this.getMaxTransferForDemonWill(WorldDemonWillHandler.getCurrentWill(this.func_145831_w(), this.field_174879_c, EnumDemonWillType.DEFAULT));
        int maxFluidTransfer = 1000;
        for (Map.Entry outputEntry : outputMap.entrySet()) {
            List outputList = (List)outputEntry.getValue();
            for (IItemFilter outputFilter : outputList) {
                for (Map.Entry inputEntry : inputMap.entrySet()) {
                    List inputList = (List)inputEntry.getValue();
                    for (IItemFilter inputFilter : inputList) {
                        void var3_6;
                        int amountTransfered;
                        if ((var3_6 -= (amountTransfered = inputFilter.transferThroughInputFilter(outputFilter, (int)var3_6))) > 0) continue;
                        return;
                    }
                }
            }
        }
    }

    public int getMaxTransferForDemonWill(double will) {
        int rate = 16;
        ItemStack upgradeStack = this.func_70301_a(0);
        if (!upgradeStack.func_190926_b() && upgradeStack.func_77973_b() instanceof IRouterUpgrade) {
            rate += ((IRouterUpgrade)upgradeStack.func_77973_b()).getMaxTransferIncrease(upgradeStack);
        }
        return rate;
    }

    @Override
    public CompoundNBT serialize(CompoundNBT tag) {
        CompoundNBT posTag;
        super.serialize(tag);
        ListNBT tags = new ListNBT();
        for (BlockPos pos : this.generalNodeList) {
            posTag = new CompoundNBT();
            posTag.func_74768_a("xCoord", pos.func_177958_n());
            posTag.func_74768_a("yCoord", pos.func_177956_o());
            posTag.func_74768_a("zCoord", pos.func_177952_p());
            tags.add((Object)posTag);
        }
        tag.func_218657_a("generalList", (INBT)tags);
        tags = new ListNBT();
        for (BlockPos pos : this.inputNodeList) {
            posTag = new CompoundNBT();
            posTag.func_74768_a("xCoord", pos.func_177958_n());
            posTag.func_74768_a("yCoord", pos.func_177956_o());
            posTag.func_74768_a("zCoord", pos.func_177952_p());
            tags.add((Object)posTag);
        }
        tag.func_218657_a("inputList", (INBT)tags);
        tags = new ListNBT();
        for (BlockPos pos : this.outputNodeList) {
            posTag = new CompoundNBT();
            posTag.func_74768_a("xCoord", pos.func_177958_n());
            posTag.func_74768_a("yCoord", pos.func_177956_o());
            posTag.func_74768_a("zCoord", pos.func_177952_p());
            tags.add((Object)posTag);
        }
        tag.func_218657_a("outputList", (INBT)tags);
        return tag;
    }

    @Override
    public void deserialize(CompoundNBT tag) {
        BlockPos newPos;
        CompoundNBT blockTag;
        int i;
        super.deserialize(tag);
        ListNBT tags = tag.func_150295_c("generalList", 10);
        for (i = 0; i < tags.size(); ++i) {
            blockTag = tags.func_150305_b(i);
            newPos = new BlockPos(blockTag.func_74762_e("xCoord"), blockTag.func_74762_e("yCoord"), blockTag.func_74762_e("zCoord"));
            this.generalNodeList.add(newPos);
        }
        tags = tag.func_150295_c("inputList", 10);
        for (i = 0; i < tags.size(); ++i) {
            blockTag = tags.func_150305_b(i);
            newPos = new BlockPos(blockTag.func_74762_e("xCoord"), blockTag.func_74762_e("yCoord"), blockTag.func_74762_e("zCoord"));
            this.inputNodeList.add(newPos);
        }
        tags = tag.func_150295_c("outputList", 10);
        for (i = 0; i < tags.size(); ++i) {
            blockTag = tags.func_150305_b(i);
            newPos = new BlockPos(blockTag.func_74762_e("xCoord"), blockTag.func_74762_e("yCoord"), blockTag.func_74762_e("zCoord"));
            this.outputNodeList.add(newPos);
        }
    }

    @Override
    public boolean isConnected(List<BlockPos> path, BlockPos nodePos) {
        TileEntity tile = this.func_145831_w().func_175625_s(nodePos);
        if (!(tile instanceof IRoutingNode)) {
            return false;
        }
        IRoutingNode node = (IRoutingNode)tile;
        List<BlockPos> connectionList = node.getConnected();
        path.add(nodePos);
        for (BlockPos testPos : connectionList) {
            if (path.contains(testPos)) continue;
            if (testPos.equals((Object)this.func_174877_v()) && node.isConnectionEnabled(testPos)) {
                return true;
            }
            if (!NodeHelper.isNodeConnectionEnabled(this.func_145831_w(), node, testPos) || !this.isConnected(path, testPos)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isConnectionEnabled(BlockPos testPos) {
        return this.currentInput <= 0;
    }

    @Override
    public void addNodeToList(IRoutingNode node) {
        BlockPos newPos = node.getCurrentBlockPos();
        if (!this.generalNodeList.contains(newPos)) {
            this.generalNodeList.add(newPos);
        }
        if (node instanceof IInputItemRoutingNode && !this.inputNodeList.contains(newPos)) {
            this.inputNodeList.add(newPos);
        }
        if (node instanceof IOutputItemRoutingNode && !this.outputNodeList.contains(newPos)) {
            this.outputNodeList.add(newPos);
        }
    }

    @Override
    public void addConnections(BlockPos pos, List<BlockPos> connectionList) {
        for (BlockPos testPos : connectionList) {
            this.addConnection(pos, testPos);
        }
    }

    @Override
    public void addConnection(BlockPos pos1, BlockPos pos2) {
        LinkedList<BlockPos> list;
        if (this.connectionMap.containsKey(pos1) && !this.connectionMap.get(pos1).contains(pos2)) {
            this.connectionMap.get(pos1).add(pos2);
        } else {
            list = new LinkedList<BlockPos>();
            list.add(pos2);
            this.connectionMap.put(pos1, list);
        }
        if (this.connectionMap.containsKey(pos2) && !this.connectionMap.get(pos2).contains(pos1)) {
            this.connectionMap.get(pos2).add(pos1);
        } else {
            list = new LinkedList();
            list.add(pos1);
            this.connectionMap.put(pos2, list);
        }
    }

    @Override
    public void removeConnection(BlockPos pos1, BlockPos pos2) {
        List<BlockPos> posList;
        if (this.connectionMap.containsKey(pos1)) {
            posList = this.connectionMap.get(pos1);
            posList.remove(pos2);
            if (posList.isEmpty()) {
                this.connectionMap.remove(pos1);
            }
        }
        if (this.connectionMap.containsKey(pos2)) {
            posList = this.connectionMap.get(pos2);
            posList.remove(pos1);
            if (posList.isEmpty()) {
                this.connectionMap.remove(pos2);
            }
        }
    }

    @Override
    public void connectMasterToRemainingNode(World world, List<BlockPos> alreadyChecked, IMasterRoutingNode master) {
    }

    @Override
    public BlockPos getCurrentBlockPos() {
        return this.func_174877_v();
    }

    @Override
    public List<BlockPos> getConnected() {
        return new LinkedList<BlockPos>();
    }

    @Override
    public BlockPos getMasterPos() {
        return this.func_174877_v();
    }

    @Override
    public boolean isMaster(IMasterRoutingNode master) {
        return false;
    }

    @Override
    public void addConnection(BlockPos pos1) {
    }

    @Override
    public void removeConnection(BlockPos pos1) {
        this.generalNodeList.remove(pos1);
        this.inputNodeList.remove(pos1);
        this.outputNodeList.remove(pos1);
    }

    @Override
    public void removeAllConnections() {
        List<BlockPos> list = this.generalNodeList.subList(0, this.generalNodeList.size());
        Iterator<BlockPos> itr = list.iterator();
        while (itr.hasNext()) {
            BlockPos testPos = itr.next();
            TileEntity tile = this.func_145831_w().func_175625_s(testPos);
            if (tile instanceof IRoutingNode) {
                ((IRoutingNode)tile).removeConnection(this.field_174879_c);
                this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(testPos), this.func_145831_w().func_180495_p(testPos), 3);
            }
            itr.remove();
            this.inputNodeList.remove(testPos);
            this.outputNodeList.remove(testPos);
        }
    }

    @Override
    public Triple<Boolean, List<BlockPos>, List<IRoutingNode>> recheckConnectionToMaster(List<BlockPos> alreadyChecked, List<IRoutingNode> nodeList) {
        return Triple.of((Object)true, alreadyChecked, nodeList);
    }

    @Override
    public List<BlockPos> checkAndPurgeConnectionToMaster(BlockPos ignorePos) {
        return new LinkedList<BlockPos>();
    }

    @Override
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.empty();
        }
        return super.getCapability(capability, facing);
    }

    public Container createMenu(int p_createMenu_1_, PlayerInventory p_createMenu_2_, PlayerEntity p_createMenu_3_) {
        assert (this.field_145850_b != null);
        return new ContainerMasterRoutingNode(this, p_createMenu_1_, p_createMenu_2_);
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent("Master Routing Node");
    }
}

