/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.tile.routing;

import net.minecraft.block.BlockState;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import wayoftime.bloodmagic.tile.routing.TileRoutingNode;

public class TileFilteredRoutingNode
extends TileRoutingNode
implements ISidedInventory {
    private int currentActiveSlot = -1;
    public int[] priorities = new int[6];

    public TileFilteredRoutingNode(TileEntityType<?> type, int size, String name) {
        super(type, size, name);
    }

    public ItemStack getFilterStack(Direction side) {
        int index = side.func_176745_a();
        return this.func_70301_a(index);
    }

    public int getCurrentActiveSlot() {
        if (this.currentActiveSlot == -1) {
            this.currentActiveSlot = 0;
            for (Direction dir : Direction.values()) {
                LazyOptional opt;
                BlockPos offsetPos = this.getCurrentBlockPos().func_177972_a(dir);
                TileEntity tile = this.field_145850_b.func_175625_s(offsetPos);
                if (tile == null || (opt = tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.func_176734_d())) == null || !opt.isPresent()) continue;
                this.currentActiveSlot = dir.ordinal();
                break;
            }
        }
        return this.currentActiveSlot;
    }

    public void setCurrentActiveSlot(int slot) {
        this.currentActiveSlot = slot;
    }

    @Override
    public boolean isInventoryConnectedToSide(Direction side) {
        return true;
    }

    @Override
    public void deserialize(CompoundNBT tag) {
        super.deserialize(tag);
        this.currentActiveSlot = tag.func_74762_e("currentSlot");
        this.priorities = tag.func_74759_k("prioritiesPeople");
        if (this.priorities.length != 6) {
            this.priorities = new int[6];
        }
    }

    @Override
    public CompoundNBT serialize(CompoundNBT tag) {
        super.serialize(tag);
        tag.func_74768_a("currentSlot", this.currentActiveSlot);
        tag.func_74783_a("prioritiesPeople", this.priorities);
        tag.func_74757_a("updated", true);
        return tag;
    }

    public void swapFilters(int requestedSlot) {
        this.currentActiveSlot = requestedSlot;
        this.func_70296_d();
    }

    public int[] func_180463_a(Direction side) {
        return new int[0];
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, Direction direction) {
        return false;
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return false;
    }

    @Override
    public int getPriority(Direction side) {
        return this.priorities[side.func_176745_a()];
    }

    public void incrementCurrentPriotiryToMaximum(int max) {
        this.priorities[this.currentActiveSlot] = Math.min(this.priorities[this.currentActiveSlot] + 1, max);
        BlockState state = this.func_145831_w().func_180495_p(this.field_174879_c);
        this.func_145831_w().func_184138_a(this.field_174879_c, state, state, 3);
    }

    public void decrementCurrentPriority() {
        this.priorities[this.currentActiveSlot] = Math.max(this.priorities[this.currentActiveSlot] - 1, 0);
        BlockState state = this.func_145831_w().func_180495_p(this.field_174879_c);
        this.func_145831_w().func_184138_a(this.field_174879_c, state, state, 3);
    }
}

