/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.structures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.server.ServerWorld;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.structures.DungeonDoor;
import wayoftime.bloodmagic.structures.DungeonStructure;
import wayoftime.bloodmagic.structures.DungeonUtil;

public class DungeonRoom {
    public ResourceLocation key;
    public int dungeonWeight = 1;
    public Map<String, BlockPos> structureMap = new HashMap<String, BlockPos>();
    public Map<String, Map<Direction, List<BlockPos>>> doorMap = new HashMap<String, Map<Direction, List<BlockPos>>>();
    public List<AreaDescriptor.Rectangle> descriptorList = new ArrayList<AreaDescriptor.Rectangle>();
    public float oreDensity = 0.0f;
    public BlockPos spawnLocation = BlockPos.field_177992_a;
    public BlockPos controllerOffset = BlockPos.field_177992_a;
    public BlockPos portalOffset = BlockPos.field_177992_a;
    public Map<Integer, List<BlockPos>> indexToDoorMap = new HashMap<Integer, List<BlockPos>>();
    public Map<Integer, List<String>> indexToRoomTypeMap = new HashMap<Integer, List<String>>();

    public DungeonRoom(Map<String, BlockPos> structureMap, Map<String, Map<Direction, List<BlockPos>>> doorMap, List<AreaDescriptor.Rectangle> descriptorList) {
        this.structureMap = structureMap;
        this.doorMap = doorMap;
        this.descriptorList = descriptorList;
    }

    public List<DungeonDoor> getPotentialConnectedRoomTypes(PlacementSettings settings, BlockPos offset) {
        ArrayList<DungeonDoor> dungeonDoorList = new ArrayList<DungeonDoor>();
        for (Map.Entry<String, Map<Direction, List<BlockPos>>> entry : this.doorMap.entrySet()) {
            Map<Direction, List<BlockPos>> doorDirMap = entry.getValue();
            String doorType = entry.getKey();
            for (int i = 0; i < 4; ++i) {
                Direction originalFacing = Direction.func_176731_b((int)i);
                if (!doorDirMap.containsKey(originalFacing)) continue;
                Direction rotatedFacing = DungeonUtil.getFacingForSettings(settings, originalFacing);
                List<BlockPos> doorList = doorDirMap.get(originalFacing);
                if (this.indexToDoorMap == null || this.indexToDoorMap.isEmpty()) {
                    ArrayList<String> roomTypeList = new ArrayList<String>();
                    for (BlockPos doorPos : doorList) {
                        dungeonDoorList.add(new DungeonDoor(Template.func_186266_a((PlacementSettings)settings, (BlockPos)doorPos).func_177971_a((Vector3i)offset), rotatedFacing, doorType, roomTypeList));
                    }
                    continue;
                }
                for (Map.Entry<Integer, List<BlockPos>> rotatedIndexEntry : this.indexToDoorMap.entrySet()) {
                    int index = rotatedIndexEntry.getKey();
                    List<String> roomTypeList = this.indexToRoomTypeMap.get(index);
                    List<BlockPos> indexedDoorList = rotatedIndexEntry.getValue();
                    for (BlockPos indexPos : indexedDoorList) {
                        if (!doorList.contains(indexPos)) continue;
                        dungeonDoorList.add(new DungeonDoor(Template.func_186266_a((PlacementSettings)settings, (BlockPos)indexPos).func_177971_a((Vector3i)offset), rotatedFacing, doorType, roomTypeList));
                    }
                }
            }
        }
        return dungeonDoorList;
    }

    public List<AreaDescriptor> getAreaDescriptors(PlacementSettings settings, BlockPos offset) {
        ArrayList<AreaDescriptor> newList = new ArrayList<AreaDescriptor>();
        for (AreaDescriptor areaDescriptor : this.descriptorList) {
            newList.add(areaDescriptor.rotateDescriptor(settings).offset(offset));
        }
        return newList;
    }

    public BlockPos getPlayerSpawnLocationForPlacement(PlacementSettings settings, BlockPos offset) {
        return Template.func_186266_a((PlacementSettings)settings, (BlockPos)this.spawnLocation).func_177971_a((Vector3i)offset);
    }

    public BlockPos getPortalOffsetLocationForPlacement(PlacementSettings settings, BlockPos offset) {
        return Template.func_186266_a((PlacementSettings)settings, (BlockPos)this.portalOffset).func_177971_a((Vector3i)offset);
    }

    public BlockPos getInitialSpawnOffsetForControllerPos(PlacementSettings settings, BlockPos controllerPos) {
        if (this.controllerOffset == null) {
            return controllerPos;
        }
        return controllerPos.func_177973_b((Vector3i)Template.func_186266_a((PlacementSettings)settings, (BlockPos)this.controllerOffset));
    }

    public List<BlockPos> getDoorOffsetsForFacing(PlacementSettings settings, String doorType, Direction facing, BlockPos offset) {
        Direction originalFacing;
        Map<Direction, List<BlockPos>> doorDirMap;
        ArrayList<BlockPos> offsetList = new ArrayList<BlockPos>();
        if (this.doorMap.containsKey(doorType) && (doorDirMap = this.doorMap.get(doorType)).containsKey(originalFacing = DungeonUtil.reverseRotate(settings.func_186212_b(), settings.func_186215_c(), facing))) {
            List<BlockPos> doorList = doorDirMap.get(originalFacing);
            for (BlockPos doorPos : doorList) {
                offsetList.add(Template.func_186266_a((PlacementSettings)settings, (BlockPos)doorPos).func_177971_a((Vector3i)offset));
            }
        }
        return offsetList;
    }

    public Map<String, List<BlockPos>> getAllDoorOffsetsForFacing(PlacementSettings settings, Direction facing, BlockPos offset) {
        HashMap<String, List<BlockPos>> offsetMap = new HashMap<String, List<BlockPos>>();
        for (String type : this.doorMap.keySet()) {
            offsetMap.put(type, this.getDoorOffsetsForFacing(settings, type, facing, offset));
        }
        return offsetMap;
    }

    public boolean placeStructureAtPosition(Random rand, PlacementSettings settings, ServerWorld world, BlockPos pos) {
        HashMap compositeMap = new HashMap();
        for (Map.Entry<String, BlockPos> entry : this.structureMap.entrySet()) {
            BlockPos key = entry.getValue();
            String structure = entry.getKey();
            if (compositeMap.containsKey(key)) {
                ((List)compositeMap.get(key)).add(structure);
                continue;
            }
            compositeMap.put(key, new ArrayList());
            ((List)compositeMap.get(key)).add(structure);
        }
        for (Map.Entry<String, Object> entry : compositeMap.entrySet()) {
            ResourceLocation location = new ResourceLocation((String)((List)entry.getValue()).get(rand.nextInt(((List)entry.getValue()).size())));
            BlockPos offsetPos = Template.func_186266_a((PlacementSettings)settings, (BlockPos)((BlockPos)entry.getKey()));
            DungeonStructure structure = new DungeonStructure(location);
            structure.placeStructureAtPosition(rand, settings, world, pos.func_177971_a((Vector3i)offsetPos));
        }
        return true;
    }
}

