/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.types;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.common.item.routing.IItemFilterProvider;
import wayoftime.bloodmagic.common.routing.IItemFilter;
import wayoftime.bloodmagic.demonaura.WorldDemonWillHandler;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.ritual.RitualRegister;
import wayoftime.bloodmagic.util.Utils;

@RitualRegister(value="yawning_void")
public class RitualYawningVoid
extends Ritual {
    public static final String PLACEMENT_RANGE = "placementRange";
    public static final String QUARRY_RANGE = "quarryRange";
    public static final String CHEST_RANGE = "chest";
    public static double rawWillDrain = 0.05;
    public static double steadfastWillDrain = 0.05;
    public static double corrosiveWillDrain = 0.05;
    public static int defaultRefreshTime = 10;
    public int refreshTime = 10;
    public BlockPos lastPos;

    public RitualYawningVoid() {
        super("ritualYawningVoid", 0, 5000, "ritual.bloodmagic.yawningVoidRitual");
        this.addBlockRange(PLACEMENT_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-1, 1, -1), 3));
        this.addBlockRange(QUARRY_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-1, -3, -1), 3));
        this.addBlockRange(CHEST_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 1, 0), 1));
        this.setMaximumVolumeAndDistanceOfRange(PLACEMENT_RANGE, 50, 4, 4);
        this.setMaximumVolumeAndDistanceOfRange(QUARRY_RANGE, 0, 64, 32);
        this.setMaximumVolumeAndDistanceOfRange(CHEST_RANGE, 1, 3, 3);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        AreaDescriptor chestRange;
        TileEntity tile;
        boolean consumeCorrosiveWill;
        World world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        BlockPos pos = masterRitualStone.getMasterBlockPos();
        List<EnumDemonWillType> willConfig = masterRitualStone.getActiveWillConfig();
        double rawWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.DEFAULT, willConfig);
        double steadfastWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.STEADFAST, willConfig);
        double corrosiveWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.CORROSIVE, willConfig);
        this.refreshTime = this.getRefreshTimeForRawWill(rawWill);
        boolean consumeRawWill = rawWill >= rawWillDrain && this.refreshTime != defaultRefreshTime;
        BlockPos replacement = pos;
        boolean replaceNonDestroyed = steadfastWill >= steadfastWillDrain;
        boolean destroy = !replaceNonDestroyed;
        boolean tryFilter = corrosiveWill >= corrosiveWillDrain;
        boolean consumeSteadfastWill = steadfastWill >= steadfastWillDrain;
        boolean bl = consumeCorrosiveWill = corrosiveWill >= corrosiveWillDrain;
        if (!consumeSteadfastWill && willConfig.contains((Object)EnumDemonWillType.STEADFAST) || !consumeCorrosiveWill && willConfig.contains((Object)EnumDemonWillType.CORROSIVE)) {
            return;
        }
        boolean replace = false;
        if (replaceNonDestroyed) {
            AreaDescriptor placementRange = masterRitualStone.getBlockRange(PLACEMENT_RANGE);
            for (BlockPos offset : placementRange.getContainedPositions(pos)) {
                if (!world.func_175623_d(offset)) continue;
                replacement = offset;
                replace = true;
                break;
            }
        }
        BlockState downState = world.func_180495_p(pos.func_177977_b());
        int maxBlockChecks = 100;
        int checks = 0;
        AreaDescriptor.Rectangle quarryRange = (AreaDescriptor.Rectangle)masterRitualStone.getBlockRange(QUARRY_RANGE);
        BlockPos minOffset = quarryRange.getMinimumOffset();
        BlockPos maxOffset = quarryRange.getMaximumOffset().func_177982_a(-1, -1, -1);
        boolean isDone = false;
        IItemHandler inventory = null;
        boolean doFilter = false;
        if (tryFilter && (tile = world.func_175625_s((chestRange = masterRitualStone.getBlockRange(CHEST_RANGE)).getContainedPositions(pos).get(0))) != null && (inventory = Utils.getInventory(tile, null)) != null) {
            doFilter = true;
        }
        if (replace || destroy) {
            if (doFilter) {
                destroy = false;
            }
            int j = maxOffset.func_177956_o();
            int i = minOffset.func_177958_n();
            int k = minOffset.func_177952_p();
            if (this.lastPos != null && !this.lastPos.equals((Object)BlockPos.field_177992_a)) {
                j = this.lastPos.func_177956_o();
                i = Math.min(maxOffset.func_177958_n(), Math.max(i, this.lastPos.func_177958_n()));
                k = Math.min(maxOffset.func_177952_p(), Math.max(k, this.lastPos.func_177952_p()));
            }
            while (j >= minOffset.func_177956_o()) {
                while (i <= maxOffset.func_177958_n()) {
                    while (k <= maxOffset.func_177952_p()) {
                        if (checks >= maxBlockChecks || isDone) {
                            this.lastPos = new BlockPos(i, j, k);
                            return;
                        }
                        ++checks;
                        BlockPos newPos = pos.func_177982_a(i, j, k);
                        BlockState state = world.func_180495_p(newPos);
                        if (!state.isAir((IBlockReader)world, newPos)) {
                            ItemStack checkStack = new ItemStack((IItemProvider)state.func_177230_c());
                            if (doFilter) {
                                for (int n = 0; n < inventory.getSlots(); ++n) {
                                    ItemStack filterStack = inventory.getStackInSlot(n);
                                    if (filterStack.func_190926_b() || !(filterStack.func_77973_b() instanceof IItemFilterProvider)) continue;
                                    IItemFilterProvider filterItem = (IItemFilterProvider)filterStack.func_77973_b();
                                    IItemFilter filter = filterItem.getUninitializedItemFilter(filterStack);
                                    if (!filter.doesStackPassFilter(checkStack)) break;
                                    destroy = true;
                                    break;
                                }
                            }
                            if (destroy) {
                                world.func_180501_a(newPos, Blocks.field_150350_a.func_176223_P(), 3);
                                masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(this.getRefreshCost()));
                                this.lastPos = new BlockPos(i, j, ++k);
                                isDone = true;
                                consumeSteadfastWill = false;
                                continue;
                            }
                            if (replace) {
                                Utils.swapLocations(world, newPos, world, replacement);
                                masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(this.getRefreshCost()));
                                this.lastPos = new BlockPos(i, j, ++k);
                                isDone = true;
                                continue;
                            }
                            ++k;
                            continue;
                        }
                        ++k;
                    }
                    ++i;
                    k = minOffset.func_177952_p();
                }
                --j;
                i = minOffset.func_177958_n();
            }
            j = maxOffset.func_177956_o();
            this.lastPos = new BlockPos(i, j, k);
        }
        if (isDone) {
            if (consumeRawWill) {
                WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.DEFAULT, rawWillDrain, true);
            }
            if (consumeCorrosiveWill) {
                WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.CORROSIVE, corrosiveWillDrain, true);
            }
            if (consumeSteadfastWill) {
                WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.STEADFAST, steadfastWillDrain, true);
            }
        }
    }

    @Override
    public void readFromNBT(CompoundNBT tag) {
        super.readFromNBT(tag);
        this.lastPos = new BlockPos(tag.func_74762_e("xCoord"), tag.func_74762_e("yCoord"), tag.func_74762_e("zCoord"));
    }

    @Override
    public void writeToNBT(CompoundNBT tag) {
        super.writeToNBT(tag);
        if (this.lastPos != null) {
            tag.func_74768_a("xCoord", this.lastPos.func_177958_n());
            tag.func_74768_a("yCoord", this.lastPos.func_177956_o());
            tag.func_74768_a("zCoord", this.lastPos.func_177952_p());
        }
    }

    @Override
    public ITextComponent[] provideInformationOfRitualToPlayer(PlayerEntity player) {
        return new ITextComponent[]{new TranslationTextComponent(this.getTranslationKey() + ".info"), new TranslationTextComponent(this.getTranslationKey() + ".default.info"), new TranslationTextComponent(this.getTranslationKey() + ".corrosive.info"), new TranslationTextComponent(this.getTranslationKey() + ".steadfast.info")};
    }

    public int getRefreshTimeForRawWill(double rawWill) {
        if (rawWill >= rawWillDrain) {
            return Math.max(1, (int)(10.0 - rawWill / 10.0));
        }
        return defaultRefreshTime;
    }

    @Override
    public int getRefreshTime() {
        return this.refreshTime;
    }

    @Override
    public int getRefreshCost() {
        return 10;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addParallelRunes(components, 1, 0, EnumRuneType.BLANK);
        this.addParallelRunes(components, 4, 0, EnumRuneType.EARTH);
        this.addOffsetRunes(components, 1, 3, 0, EnumRuneType.WATER);
        this.addOffsetRunes(components, 3, 1, 0, EnumRuneType.WATER);
        this.addCornerRunes(components, 2, 0, EnumRuneType.DUSK);
        this.addParallelRunes(components, 3, 1, EnumRuneType.AIR);
        this.addParallelRunes(components, 2, 1, EnumRuneType.EARTH);
        this.addParallelRunes(components, 2, 2, EnumRuneType.EARTH);
        this.addParallelRunes(components, 3, 3, EnumRuneType.AIR);
        this.addCornerRunes(components, 2, 3, EnumRuneType.FIRE);
        this.addOffsetRunes(components, 2, 1, 3, EnumRuneType.FIRE);
        this.addOffsetRunes(components, 1, 2, 3, EnumRuneType.FIRE);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualYawningVoid();
    }
}

