/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.types;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import wayoftime.bloodmagic.ConfigManager;
import wayoftime.bloodmagic.common.block.BlockInversionPillarEnd;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.common.block.type.PillarCapType;
import wayoftime.bloodmagic.common.dimension.DungeonDimensionHelper;
import wayoftime.bloodmagic.common.item.ItemActivationCrystal;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.ritual.RitualRegister;
import wayoftime.bloodmagic.structures.DungeonSynthesizer;
import wayoftime.bloodmagic.tile.TileInversionPillar;
import wayoftime.bloodmagic.util.helper.NetworkHelper;

@RitualRegister(value="simple_dungeon")
public class RitualSimpleDungeon
extends Ritual {
    public RitualSimpleDungeon() {
        super("ritualSimpleDungeon", 0, 80000, "ritual.bloodmagic.simpleDungeonRitual");
    }

    @Override
    public boolean activateRitual(IMasterRitualStone masterRitualStone, PlayerEntity player, UUID owner) {
        if (((Boolean)ConfigManager.COMMON.makeDungeonRitualCreativeOnly.get()).booleanValue()) {
            ItemStack heldStack = player.func_184607_cu();
            if (heldStack.func_77973_b() instanceof ItemActivationCrystal) {
                int crystalLevel = ((ItemActivationCrystal)heldStack.func_77973_b()).getCrystalLevel(heldStack);
                return crystalLevel == Integer.MAX_VALUE;
            }
            return false;
        }
        return true;
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        BlockPos masterPos = masterRitualStone.getMasterBlockPos();
        if (!world.field_72995_K && world instanceof ServerWorld) {
            ServerWorld dungeonWorld = DungeonDimensionHelper.getDungeonWorld(world);
            if (dungeonWorld != null) {
                ArrayList components = Lists.newArrayList();
                this.gatherComponents(components::add);
                for (RitualComponent component : components) {
                    BlockPos newPos = masterPos.func_177971_a((Vector3i)component.getOffset(masterRitualStone.getDirection()));
                    world.func_175656_a(newPos, Blocks.field_196579_bG.func_176223_P());
                }
                BlockPos dungeonSpawnLocation = NetworkHelper.getSpawnPositionOfDungeon();
                DungeonSynthesizer dungeon = new DungeonSynthesizer();
                ResourceLocation initialType = new ResourceLocation("bloodmagic:room_pools/entrances/mini_dungeon_entrances");
                BlockPos[] positions = dungeon.generateInitialRoom(initialType, world.field_73012_v, dungeonWorld, dungeonSpawnLocation);
                BlockPos pillarPos = masterPos.func_177967_a(Direction.UP, 2);
                BlockPos safePlayerPosition = positions[0];
                BlockPos dungeonPortalPos = positions[1];
                BlockPos overworldPlayerPos = masterPos.func_177972_a(Direction.UP).func_177967_a(masterRitualStone.getDirection(), 2);
                this.spawnPortalPillar(world, (World)dungeonWorld, pillarPos, safePlayerPosition);
                this.spawnPortalPillar((World)dungeonWorld, world, dungeonPortalPos, overworldPlayerPos);
                LightningBoltEntity lightningboltentity = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(world);
                lightningboltentity.func_70107_b((double)masterPos.func_177958_n(), (double)(masterPos.func_177956_o() + 1), (double)masterPos.func_177952_p());
                lightningboltentity.func_233623_a_(true);
                world.func_217376_c((Entity)lightningboltentity);
                NetworkHelper.incrementDungeonCounter();
            }
            world.func_175656_a(masterPos, Blocks.field_150350_a.func_176223_P());
        }
    }

    public void spawnPortalPillar(World spawnWorld, World destinationWorld, BlockPos pillarPos, BlockPos safePlayerPos) {
        spawnWorld.func_175656_a(pillarPos, ((Block)BloodMagicBlocks.INVERSION_PILLAR.get()).func_176223_P());
        TileEntity tile = spawnWorld.func_175625_s(pillarPos);
        if (tile instanceof TileInversionPillar) {
            TileInversionPillar tileInversion = (TileInversionPillar)tile;
            tileInversion.setDestination(destinationWorld, safePlayerPos);
            spawnWorld.func_175656_a(pillarPos.func_177972_a(Direction.DOWN), (BlockState)((Block)BloodMagicBlocks.INVERSION_PILLAR_CAP.get()).func_176223_P().func_206870_a(BlockInversionPillarEnd.TYPE, (Comparable)((Object)PillarCapType.BOTTOM)));
            spawnWorld.func_175656_a(pillarPos.func_177972_a(Direction.UP), (BlockState)((Block)BloodMagicBlocks.INVERSION_PILLAR_CAP.get()).func_176223_P().func_206870_a(BlockInversionPillarEnd.TYPE, (Comparable)((Object)PillarCapType.TOP)));
        }
    }

    @Override
    public int getRefreshTime() {
        return 1;
    }

    @Override
    public int getRefreshCost() {
        return 0;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addParallelRunes(components, 1, 4, EnumRuneType.AIR);
        this.addParallelRunes(components, 2, 4, EnumRuneType.EARTH);
        this.addCornerRunes(components, 1, 0, EnumRuneType.EARTH);
        this.addParallelRunes(components, 2, 0, EnumRuneType.EARTH);
        this.addCornerRunes(components, 2, 0, EnumRuneType.FIRE);
        for (int i = -1; i <= 1; ++i) {
            this.addRune(components, i, 0, 3, EnumRuneType.WATER);
            this.addRune(components, i, 0, -3, EnumRuneType.WATER);
            this.addRune(components, 3, 0, i, EnumRuneType.FIRE);
            this.addRune(components, -3, 0, i, EnumRuneType.FIRE);
        }
        for (int j = 1; j <= 4; ++j) {
            this.addRune(components, 0, j, 0, EnumRuneType.EARTH);
        }
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualSimpleDungeon();
    }
}

