/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.harvest;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CropsBlock;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.ritual.harvest.HarvestRegistry;
import wayoftime.bloodmagic.ritual.harvest.IHarvestHandler;
import wayoftime.bloodmagic.util.BMLog;

public class HarvestHandlerPlantable
implements IHarvestHandler {
    private static final ItemStack mockHoe = new ItemStack((IItemProvider)Items.field_151012_L, 1);

    public HarvestHandlerPlantable() {
        HarvestRegistry.registerStandardCrop(Blocks.field_150459_bM, 7);
        HarvestRegistry.registerStandardCrop(Blocks.field_150464_aj, 7);
        HarvestRegistry.registerStandardCrop(Blocks.field_150469_bN, 7);
        HarvestRegistry.registerStandardCrop(Blocks.field_185773_cZ, 3);
        HarvestRegistry.registerStandardCrop(Blocks.field_150388_bm, 3);
        HarvestRegistry.registerStandardCrop((Block)BloodMagicBlocks.GROWING_DOUBT.get(), 7);
        HarvestRegistry.registerStandardCrop((Block)BloodMagicBlocks.WEAK_TAU.get(), 7);
        HarvestRegistry.registerStandardCrop((Block)BloodMagicBlocks.STRONG_TAU.get(), 7);
        HarvestHandlerPlantable.addThirdPartyCrop("actuallyadditions", "flax_block", 7);
        HarvestHandlerPlantable.addThirdPartyCrop("actuallyadditions", "canola_block", 7);
        HarvestHandlerPlantable.addThirdPartyCrop("actuallyadditions", "rice_block", 7);
        HarvestHandlerPlantable.addThirdPartyCrop("extrautils2", "redorchid", 6);
        HarvestHandlerPlantable.addThirdPartyCrop("extrautils2", "enderlily", 7);
        HarvestHandlerPlantable.addThirdPartyCrop("roots", "moonglow", 7);
        HarvestHandlerPlantable.addThirdPartyCrop("roots", "terra_moss", 7);
        HarvestHandlerPlantable.addThirdPartyCrop("roots", "pereskia", 7);
        HarvestHandlerPlantable.addThirdPartyCrop("roots", "wildroot", 7);
        HarvestHandlerPlantable.addThirdPartyCrop("roots", "aubergine", 7);
        HarvestHandlerPlantable.addThirdPartyCrop("roots", "spirit_herb", 7);
        HarvestHandlerPlantable.addPamCrops();
        HarvestHandlerPlantable.addMysticalCrops();
    }

    @Override
    public boolean harvest(World world, BlockPos pos, BlockState state, List<ItemStack> drops) {
        boolean foundSeed = false;
        LootContext.Builder lootBuilder = new LootContext.Builder((ServerWorld)world);
        Vector3d blockCenter = new Vector3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        List blockDrops = state.func_215693_a(lootBuilder.func_216015_a(LootParameters.field_237457_g_, (Object)blockCenter).func_216015_a(LootParameters.field_216289_i, (Object)mockHoe));
        for (ItemStack stack : blockDrops) {
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof BlockItem) || ((BlockItem)stack.func_77973_b()).func_179223_d() != state.func_177230_c()) continue;
            stack.func_190918_g(1);
            foundSeed = true;
            break;
        }
        if (foundSeed) {
            world.func_175656_a(pos, state.func_177230_c().func_176223_P());
            world.func_217379_c(2001, pos, Block.func_196246_j((BlockState)state));
            for (ItemStack stack : blockDrops) {
                if (stack.func_190926_b()) continue;
                drops.add(stack);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean test(World world, BlockPos pos, BlockState state) {
        return HarvestRegistry.getStandardCrops().containsKey(state.func_177230_c()) && state.func_177230_c() instanceof CropsBlock && ((CropsBlock)state.func_177230_c()).func_185525_y(state);
    }

    private static void addThirdPartyCrop(String modid, String regName, int matureMeta) {
        if (!ModList.get().isLoaded(modid)) {
            return;
        }
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(modid, regName));
        if (block != null && block != Blocks.field_150350_a) {
            HarvestRegistry.registerStandardCrop(block, matureMeta);
        }
    }

    private static void addPamCrops() {
        if (!ModList.get().isLoaded("harvestcraft")) {
            return;
        }
        try {
            Class<?> pamRegistry = Class.forName("com.pam.harvestcraft.blocks.CropRegistry");
            Field names = pamRegistry.getDeclaredField("cropNames");
            Method getCrop = pamRegistry.getMethod("getCrop", String.class);
            for (String name : (String[])names.get(null)) {
                CropsBlock crop = (CropsBlock)getCrop.invoke(null, name);
                HarvestRegistry.registerStandardCrop((Block)crop, crop.func_185526_g());
            }
        }
        catch (ClassNotFoundException e) {
            BMLog.DEFAULT.error("HarvestCraft integration cancelled; unable to find registry class", new Object[0]);
        }
        catch (NoSuchFieldException | NoSuchMethodException e) {
            BMLog.DEFAULT.error("HarvestCraft integration cancelled; unable to find crop name mapper", new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            BMLog.DEFAULT.error("HarvestCraft integration cancelled; crop name lookup broke", new Object[0]);
        }
    }

    private static void addMysticalCrops() {
        if (!ModList.get().isLoaded("mysticalagriculture")) {
            return;
        }
        try {
            Class<?> mysticalAPI = Class.forName("com.blakebr0.mysticalagriculture.api.MysticalAgricultureAPI");
            Method getRegistry = mysticalAPI.getMethod("getCropRegistry", new Class[0]);
            Object registry = getRegistry.invoke(null, new Object[0]);
            Class<?> mysticalRegistry = Class.forName("com.blakebr0.mysticalagriculture.api.registry.ICropRegistry");
            Method getCrops = mysticalRegistry.getMethod("getCrops", new Class[0]);
            List crops = (List)getCrops.invoke(registry, new Object[0]);
            Class<?> mysticalCrop = Class.forName("com.blakebr0.mysticalagriculture.api.crop.ICrop");
            Method getCrop = mysticalCrop.getMethod("getCrop", new Class[0]);
            for (Object maCrop : crops) {
                CropsBlock crop = (CropsBlock)getCrop.invoke(maCrop, new Object[0]);
                HarvestRegistry.registerStandardCrop((Block)crop, crop.func_185526_g());
            }
        }
        catch (ClassNotFoundException e) {
            BMLog.DEFAULT.error("MysticalAgriculture integration cancelled: unable to find a class: " + e.getMessage(), new Object[0]);
        }
        catch (NoSuchMethodException e) {
            BMLog.DEFAULT.error("MysticalAgriculture integration cancelled: unable to find a method: " + e.getMessage(), new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            BMLog.DEFAULT.error("MysticalAgriculture integration cancelled: failed to invoke a method: " + e.getMessage(), new Object[0]);
        }
    }
}

