/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.recipe;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import wayoftime.bloodmagic.common.recipe.BloodMagicRecipeType;
import wayoftime.bloodmagic.common.registries.BloodMagicRecipeSerializers;
import wayoftime.bloodmagic.recipe.BloodMagicRecipe;

public class RecipeBloodAltar
extends BloodMagicRecipe {
    @Nonnull
    private final Ingredient input;
    @Nonnull
    private final ItemStack output;
    @Nonnull
    private final int minimumTier;
    @Nonnegative
    private final int syphon;
    @Nonnegative
    private final int consumeRate;
    @Nonnegative
    private final int drainRate;

    public RecipeBloodAltar(ResourceLocation id, @Nonnull Ingredient input, @Nonnull ItemStack output, @Nonnegative int minimumTier, @Nonnegative int syphon, @Nonnegative int consumeRate, @Nonnegative int drainRate) {
        super(id);
        Preconditions.checkNotNull((Object)input, (Object)"input cannot be null.");
        Preconditions.checkNotNull((Object)output, (Object)"output cannot be null.");
        Preconditions.checkArgument((minimumTier >= 0 ? 1 : 0) != 0, (Object)"minimumTier cannot be negative.");
        Preconditions.checkArgument((minimumTier <= 6 ? 1 : 0) != 0, (Object)"minimumTier cannot be higher than max tier");
        Preconditions.checkArgument((syphon >= 0 ? 1 : 0) != 0, (Object)"syphon cannot be negative.");
        Preconditions.checkArgument((consumeRate >= 0 ? 1 : 0) != 0, (Object)"consumeRate cannot be negative.");
        Preconditions.checkArgument((drainRate >= 0 ? 1 : 0) != 0, (Object)"drain cannot be negative.");
        this.input = input;
        this.output = output;
        this.minimumTier = minimumTier;
        this.syphon = syphon;
        this.consumeRate = consumeRate;
        this.drainRate = drainRate;
    }

    @Nonnull
    public final Ingredient getInput() {
        return this.input;
    }

    public final NonNullList<Ingredient> func_192400_c() {
        NonNullList list = NonNullList.func_191196_a();
        list.add((Object)this.getInput());
        return list;
    }

    @Nonnull
    public final ItemStack getOutput() {
        return this.output;
    }

    public int getMinimumTier() {
        return this.minimumTier;
    }

    @Nonnegative
    public final int getSyphon() {
        return this.syphon;
    }

    @Nonnegative
    public final int getConsumeRate() {
        return this.consumeRate;
    }

    @Nonnegative
    public final int getDrainRate() {
        return this.drainRate;
    }

    @Override
    public void write(PacketBuffer buffer) {
        this.input.func_199564_a(buffer);
        buffer.func_150788_a(this.output);
        buffer.writeInt(this.minimumTier);
        buffer.writeInt(this.syphon);
        buffer.writeInt(this.consumeRate);
        buffer.writeInt(this.drainRate);
    }

    public IRecipeSerializer<RecipeBloodAltar> func_199559_b() {
        return BloodMagicRecipeSerializers.ALTAR.getRecipeSerializer();
    }

    public IRecipeType<RecipeBloodAltar> func_222127_g() {
        return BloodMagicRecipeType.ALTAR;
    }
}

