/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.core.living;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import wayoftime.bloodmagic.core.LivingArmorRegistrar;
import wayoftime.bloodmagic.core.living.ILivingContainer;
import wayoftime.bloodmagic.core.living.LivingUpgrade;
import wayoftime.bloodmagic.core.living.LivingUtil;

public class LivingStats {
    public static final int DEFAULT_UPGRADE_POINTS = 100;
    protected final Map<LivingUpgrade, Double> upgrades;
    protected int maxPoints = 100;

    public LivingStats(Map<LivingUpgrade, Double> upgrades) {
        this.upgrades = upgrades;
    }

    public LivingStats() {
        this(Maps.newHashMap());
    }

    public Map<LivingUpgrade, Double> getUpgrades() {
        return ImmutableMap.copyOf(this.upgrades);
    }

    public LivingStats addExperience(ResourceLocation key, double experience) {
        LivingUpgrade upgrade = LivingArmorRegistrar.UPGRADE_MAP.getOrDefault(key, LivingUpgrade.DUMMY);
        double current = this.upgrades.getOrDefault((Object)upgrade, 0.0);
        if (experience > 0.0 && upgrade.getNextRequirement((int)current) == 0) {
            return this;
        }
        this.upgrades.put(upgrade, current + experience);
        return this;
    }

    public LivingStats resetExperience(ResourceLocation key) {
        LivingUpgrade upgrade = LivingArmorRegistrar.UPGRADE_MAP.getOrDefault(key, LivingUpgrade.DUMMY);
        if (!this.upgrades.containsKey((Object)upgrade)) {
            return this;
        }
        this.upgrades.put(upgrade, 0.0);
        return this;
    }

    public int getLevel(ResourceLocation key) {
        LivingUpgrade upgrade = LivingArmorRegistrar.UPGRADE_MAP.getOrDefault(key, LivingUpgrade.DUMMY);
        return upgrade.getLevel(this.upgrades.getOrDefault((Object)upgrade, 0.0).intValue());
    }

    public int getUsedPoints() {
        int total = 0;
        for (Map.Entry<LivingUpgrade, Double> applied : this.upgrades.entrySet()) {
            double experience = applied.getValue();
            int level = applied.getKey().getLevel((int)experience);
            int cost = applied.getKey().getLevelCost(level);
            total += cost;
        }
        return total;
    }

    public int getMaxPoints() {
        return this.maxPoints;
    }

    public LivingStats setMaxPoints(int maxPoints) {
        this.maxPoints = maxPoints;
        return this;
    }

    public CompoundNBT serialize() {
        CompoundNBT compound = new CompoundNBT();
        ListNBT statList = new ListNBT();
        this.upgrades.forEach((k, v) -> {
            CompoundNBT upgrade = new CompoundNBT();
            upgrade.func_74778_a("key", k.getKey().toString());
            upgrade.func_74780_a("exp", v.doubleValue());
            statList.add((Object)upgrade);
        });
        compound.func_218657_a("upgrades", (INBT)statList);
        compound.func_74768_a("maxPoints", this.maxPoints);
        return compound;
    }

    public void deserialize(CompoundNBT nbt) {
        ListNBT statList = nbt.func_150295_c("upgrades", 10);
        statList.forEach(tag -> {
            if (!(tag instanceof CompoundNBT)) {
                return;
            }
            LivingUpgrade upgrade = LivingArmorRegistrar.UPGRADE_MAP.getOrDefault(new ResourceLocation(((CompoundNBT)tag).func_74779_i("key")), LivingUpgrade.DUMMY);
            if (upgrade == LivingUpgrade.DUMMY) {
                return;
            }
            double experience = ((CompoundNBT)tag).func_74769_h("exp");
            this.upgrades.put(upgrade, experience);
        });
        this.maxPoints = nbt.func_74762_e("maxPoints");
    }

    public static LivingStats fromNBT(CompoundNBT statTag) {
        LivingStats stats = new LivingStats();
        stats.deserialize(statTag);
        return stats;
    }

    public static LivingStats fromPlayer(PlayerEntity player) {
        return LivingStats.fromPlayer(player, false);
    }

    public static LivingStats fromPlayer(PlayerEntity player, boolean createNew) {
        if (!LivingUtil.hasFullSet(player)) {
            return null;
        }
        ItemStack chest = player.func_184582_a(EquipmentSlotType.CHEST);
        LivingStats stats = ((ILivingContainer)chest.func_77973_b()).getLivingStats(chest);
        return stats == null && createNew ? new LivingStats() : stats;
    }

    public static void toPlayer(PlayerEntity player, LivingStats stats) {
        if (!LivingUtil.hasFullSet(player)) {
            return;
        }
        ItemStack chest = player.func_184582_a(EquipmentSlotType.CHEST);
        ((ILivingContainer)chest.func_77973_b()).updateLivingStats(chest, stats);
    }
}

