/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.compat.patchouli.processors;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.common.item.potion.ItemAlchemyFlask;
import wayoftime.bloodmagic.common.recipe.BloodMagicRecipeType;
import wayoftime.bloodmagic.recipe.flask.RecipePotionFlaskBase;

public class PotionFlaskProcessor
implements IComponentProcessor {
    private RecipePotionFlaskBase recipe;

    public void setup(IVariableProvider variables) {
        IRecipe recipe;
        ResourceLocation id = new ResourceLocation(variables.get("recipe").asString());
        Optional recipeHandler = Minecraft.func_71410_x().field_71441_e.func_199532_z().func_215367_a(id);
        if (recipeHandler.isPresent() && (recipe = (IRecipe)recipeHandler.get()).func_222127_g().equals(BloodMagicRecipeType.POTIONFLASK)) {
            this.recipe = (RecipePotionFlaskBase)recipe;
        }
        if (this.recipe == null) {
            LogManager.getLogger().warn("Guidebook missing Potion Flask recipe {}", (Object)id);
        }
    }

    public IVariable process(String key) {
        if (this.recipe == null) {
            return null;
        }
        if (key.startsWith("input")) {
            int index = Integer.parseInt(key.substring(5)) - 1;
            if (this.recipe.getInput().size() > index) {
                return IVariable.wrapList((Iterable)Arrays.stream(this.recipe.getInput().get(index).func_193365_a()).map(IVariable::from).collect(Collectors.toList()));
            }
            if (this.recipe.getInput().size() == index) {
                return IVariable.from((Object)this.recipe.getExamplePotionFlask());
            }
            return null;
        }
        switch (key) {
            case "output": {
                ItemStack flaskStack = this.recipe.getExamplePotionFlask();
                ItemStack outputStack = this.recipe.getOutput(flaskStack, ((ItemAlchemyFlask)flaskStack.func_77973_b()).getEffectHoldersOfFlask(flaskStack));
                ((ItemAlchemyFlask)flaskStack.func_77973_b()).resyncEffectInstances(outputStack);
                return IVariable.from((Object)outputStack);
            }
            case "syphon": {
                return IVariable.wrap((Number)this.recipe.getSyphon());
            }
            case "time": {
                return IVariable.wrap((Number)this.recipe.getTicks());
            }
            case "tier": {
                return IVariable.wrap((Number)this.recipe.getMinimumTier());
            }
            case "orb": {
                switch (this.recipe.getMinimumTier()) {
                    case 0: 
                    case 1: {
                        return IVariable.from((Object)new ItemStack((IItemProvider)BloodMagicItems.WEAK_BLOOD_ORB.get()));
                    }
                    case 2: {
                        return IVariable.from((Object)new ItemStack((IItemProvider)BloodMagicItems.APPRENTICE_BLOOD_ORB.get()));
                    }
                    case 3: {
                        return IVariable.from((Object)new ItemStack((IItemProvider)BloodMagicItems.MAGICIAN_BLOOD_ORB.get()));
                    }
                    case 4: {
                        return IVariable.from((Object)new ItemStack((IItemProvider)BloodMagicItems.MASTER_BLOOD_ORB.get()));
                    }
                }
                LogManager.getLogger().warn("Guidebook unable to find large enough Blood Orb for {}", (Object)this.recipe.func_199560_c());
                return IVariable.from((Object)new ItemStack((IItemProvider)Items.field_221803_eL));
            }
        }
        return null;
    }
}

