/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.compat.patchouli.processors;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;
import wayoftime.bloodmagic.common.recipe.BloodMagicRecipeType;
import wayoftime.bloodmagic.recipe.RecipeBloodAltar;

public class BloodAltarProcessor
implements IComponentProcessor {
    private RecipeBloodAltar recipe;

    public void setup(IVariableProvider variables) {
        IRecipe recipe;
        ResourceLocation id = new ResourceLocation(variables.get("recipe").asString());
        Optional recipeHandler = Minecraft.func_71410_x().field_71441_e.func_199532_z().func_215367_a(id);
        if (recipeHandler.isPresent() && (recipe = (IRecipe)recipeHandler.get()).func_222127_g().equals(BloodMagicRecipeType.ALTAR)) {
            this.recipe = (RecipeBloodAltar)recipe;
        }
        if (this.recipe == null) {
            LogManager.getLogger().warn("Guidebook missing Blood Altar recipe {}", (Object)id);
        }
    }

    public IVariable process(String key) {
        if (this.recipe == null) {
            return null;
        }
        switch (key) {
            case "input": {
                return IVariable.wrapList((Iterable)Arrays.stream(this.recipe.getInput().func_193365_a()).map(IVariable::from).collect(Collectors.toList()));
            }
            case "output": {
                return IVariable.from((Object)this.recipe.getOutput());
            }
            case "tier": {
                return IVariable.wrap((Number)(this.recipe.getMinimumTier() + 1));
            }
            case "lp": {
                return IVariable.wrap((Number)this.recipe.getSyphon());
            }
        }
        return null;
    }
}

