/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.compat.jei.forge;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.recipe.RecipeTartaricForge;
import wayoftime.bloodmagic.util.ChatUtil;
import wayoftime.bloodmagic.util.helper.TextHelper;

public class TartaricForgeRecipeCategory
implements IRecipeCategory<RecipeTartaricForge> {
    private static final int OUTPUT_SLOT = 0;
    private static final int GEM_SLOT = 1;
    private static final int INPUT_SLOT = 2;
    public static final ResourceLocation UID = BloodMagic.rl("soulforge");
    @Nonnull
    private final IDrawable background;
    private final IDrawable icon;

    public TartaricForgeRecipeCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)BloodMagicBlocks.SOUL_FORGE.get()));
        this.background = guiHelper.createDrawable(BloodMagic.rl("gui/jei/soulforge.png"), 0, 0, 100, 40);
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    public List<ITextComponent> getTooltipStrings(RecipeTartaricForge recipe, double mouseX, double mouseY) {
        ArrayList tooltip = Lists.newArrayList();
        if (mouseX >= 40.0 && mouseX <= 60.0 && mouseY >= 21.0 && mouseY <= 34.0) {
            tooltip.add(new TranslationTextComponent("jei.bloodmagic.recipe.minimumsouls", new Object[]{ChatUtil.DECIMAL_FORMAT.format(recipe.getMinimumSouls())}));
            tooltip.add(new TranslationTextComponent("jei.bloodmagic.recipe.soulsdrained", new Object[]{ChatUtil.DECIMAL_FORMAT.format(recipe.getSoulDrain())}));
        }
        return tooltip;
    }

    @Nonnull
    public String getTitle() {
        return TextHelper.localize("jei.bloodmagic.recipe.soulforge", new Object[0]);
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull RecipeTartaricForge recipe, @Nonnull IIngredients ingredients) {
        ArrayList validGems = Lists.newArrayList();
        for (DefaultWill will : DefaultWill.values()) {
            if (!(will.minSouls >= recipe.getMinimumSouls())) continue;
            validGems.add(will.willStack);
        }
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, false, 73, 13);
        guiItemStacks.init(1, true, 42, 0);
        for (int y = 0; y < 2; ++y) {
            for (int x = 0; x < 2; ++x) {
                int index = 2 + x + y * 2;
                guiItemStacks.init(index, true, x * 18, y * 18);
            }
        }
        guiItemStacks.set(1, (List)validGems);
        guiItemStacks.set(0, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
        guiItemStacks.set(ingredients);
    }

    public Class<? extends RecipeTartaricForge> getRecipeClass() {
        return RecipeTartaricForge.class;
    }

    public void setIngredients(RecipeTartaricForge recipe, IIngredients ingredients) {
        ArrayList validGems = Lists.newArrayList();
        for (DefaultWill will : DefaultWill.values()) {
            if (!(will.minSouls >= recipe.getMinimumSouls())) continue;
            validGems.add(will.willStack);
        }
        ItemStack[] validGemStacks = new ItemStack[validGems.size()];
        for (int i = 0; i < validGemStacks.length; ++i) {
            validGemStacks[i] = (ItemStack)validGems.get(i);
        }
        ArrayList ingList = Lists.newArrayList();
        ingList.add(Ingredient.func_193369_a((ItemStack[])validGemStacks));
        ingList.addAll(recipe.getInput());
        ingredients.setInputIngredients((List)ingList);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.getOutput());
    }

    public static enum DefaultWill {
        SOUL(new ItemStack((IItemProvider)BloodMagicItems.MONSTER_SOUL_RAW.get()), 16.0),
        PETTY(new ItemStack((IItemProvider)BloodMagicItems.PETTY_GEM.get()), 64.0),
        LESSER(new ItemStack((IItemProvider)BloodMagicItems.LESSER_GEM.get()), 256.0),
        COMMON(new ItemStack((IItemProvider)BloodMagicItems.COMMON_GEM.get()), 1024.0),
        GREATER(new ItemStack((IItemProvider)BloodMagicItems.GREATER_GEM.get()), 4096.0);

        public final ItemStack willStack;
        public final double minSouls;

        private DefaultWill(ItemStack willStack, double minSouls) {
            this.willStack = willStack;
            this.minSouls = minSouls;
        }
    }
}

