/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.compat.crt;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionAddRecipe;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionRemoveRecipeByOutput;
import com.blamejared.crafttweaker.impl.item.MCItemStackMutable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;
import wayoftime.bloodmagic.common.recipe.BloodMagicRecipeType;
import wayoftime.bloodmagic.recipe.RecipeTartaricForge;

@ZenRegister
@ZenCodeType.Name(value="mods.bloodmagic.TartaricForge")
public class TartaricForgeManager
implements IRecipeManager {
    @ZenCodeType.Method
    public void addRecipe(String name, IItemStack output, IIngredient[] input, double minimumSouls, double soulDrain) {
        name = this.fixRecipeName(name);
        ResourceLocation location = new ResourceLocation("crafttweaker", name);
        RecipeTartaricForge recipe = new RecipeTartaricForge(location, Arrays.stream(input).map(IIngredient::asVanillaIngredient).collect(Collectors.toList()), output.getInternal(), minimumSouls, soulDrain);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (IRecipe)recipe, ""));
    }

    public void removeRecipe(final IItemStack output) {
        CraftTweakerAPI.apply((IAction)new ActionRemoveRecipeByOutput(this, output){

            public void apply() {
                ArrayList<ResourceLocation> toRemove = new ArrayList<ResourceLocation>();
                for (ResourceLocation location : this.getManager().getRecipes().keySet()) {
                    RecipeTartaricForge recipeTF;
                    ItemStack recipeOutput;
                    IRecipe recipe = (IRecipe)this.getManager().getRecipes().get(location);
                    if (!(recipe instanceof RecipeTartaricForge) || !output.matches((IItemStack)new MCItemStackMutable(recipeOutput = (recipeTF = (RecipeTartaricForge)recipe).getOutput()))) continue;
                    toRemove.add(location);
                }
                toRemove.forEach(this.getManager().getRecipes()::remove);
            }
        });
    }

    public IRecipeType<RecipeTartaricForge> getRecipeType() {
        return BloodMagicRecipeType.TARTARICFORGE;
    }
}

