/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.meteor;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.common.meteor.RandomBlockContainer;
import wayoftime.bloodmagic.common.meteor.RandomBlockTagContainer;
import wayoftime.bloodmagic.common.meteor.StaticBlockContainer;

public class MeteorLayer {
    public int layerRadius;
    public int additionalTotalWeight;
    public int minWeight = 0;
    public int totalMaxWeight = 0;
    public List<Pair<RandomBlockContainer, Integer>> weightList;
    public RandomBlockContainer fillBlock;
    public RandomBlockContainer shellBlock;

    public MeteorLayer(int layerRadius, int additionalMaxWeight, List<Pair<RandomBlockContainer, Integer>> weightList, RandomBlockContainer fillBlock) {
        this.layerRadius = layerRadius;
        this.additionalTotalWeight = additionalMaxWeight;
        this.weightList = weightList;
        this.fillBlock = fillBlock;
    }

    public MeteorLayer(int layerRadius, int additionalMaxWeight, Block fillBlock) {
        this(layerRadius, additionalMaxWeight, new ArrayList<Pair<RandomBlockContainer, Integer>>(), new StaticBlockContainer(fillBlock));
    }

    public MeteorLayer(int layerRadius, int additionalMaxWeight, ITag<Block> fillTag) {
        this(layerRadius, additionalMaxWeight, fillTag, -1);
    }

    public MeteorLayer(int layerRadius, int additionalMaxWeight, ITag<Block> fillTag, int staticIndex) {
        this(layerRadius, additionalMaxWeight, new ArrayList<Pair<RandomBlockContainer, Integer>>(), new RandomBlockTagContainer(fillTag, staticIndex));
    }

    public MeteorLayer addShellBlock(RandomBlockContainer shellBlock) {
        this.shellBlock = shellBlock;
        return this;
    }

    public MeteorLayer addShellBlock(ITag<Block> tag) {
        return this.addShellBlock(tag, -1);
    }

    public MeteorLayer addShellBlock(ITag<Block> tag, int staticIndex) {
        return this.addShellBlock(new RandomBlockTagContainer(tag, staticIndex));
    }

    public MeteorLayer addShellBlock(Block block) {
        return this.addShellBlock(new StaticBlockContainer(block));
    }

    public MeteorLayer addWeightedTag(ITag<Block> tag, int weight) {
        return this.addWeightedTag(tag, weight, -1);
    }

    public MeteorLayer addWeightedTag(ITag<Block> tag, int weight, int staticIndex) {
        this.weightList.add((Pair<RandomBlockContainer, Integer>)Pair.of((Object)new RandomBlockTagContainer(tag, staticIndex), (Object)weight));
        return this;
    }

    public MeteorLayer addWeightedBlock(Block block, int weight) {
        this.weightList.add((Pair<RandomBlockContainer, Integer>)Pair.of((Object)new StaticBlockContainer(block), (Object)weight));
        return this;
    }

    public MeteorLayer setMinWeight(int weight) {
        this.minWeight = weight;
        return this;
    }

    public void buildLayer(World world, BlockPos centerPos, int emptyRadius) {
        this.recalculateMaxWeight(world.field_73012_v, world);
        int radius = this.layerRadius;
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                for (int k = -radius; k <= radius; ++k) {
                    BlockItemUseContext ctx;
                    BlockPos pos;
                    BlockState currentState;
                    if (emptyRadius >= 0 && this.checkIfSphere(emptyRadius, i, j, k) || !this.checkIfSphere(radius, i, j, k) || !(currentState = world.func_180495_p(pos = centerPos.func_177982_a(i, j, k))).func_196953_a(ctx = new BlockItemUseContext(world, null, Hand.MAIN_HAND, ItemStack.field_190927_a, BlockRayTraceResult.func_216352_a((Vector3d)new Vector3d(0.0, 0.0, 0.0), (Direction)Direction.UP, (BlockPos)pos)))) continue;
                    if (this.shellBlock != null && this.checkIfSphereShell(radius, i, j, k)) {
                        world.func_175656_a(pos, this.shellBlock.getRandomBlock(world.field_73012_v, world).func_176223_P());
                        continue;
                    }
                    world.func_175656_a(pos, this.getRandomState(world.field_73012_v, world));
                }
            }
        }
    }

    public void recalculateMaxWeight(Random rand, World world) {
        this.totalMaxWeight = this.additionalTotalWeight;
        Iterator<Pair<RandomBlockContainer, Integer>> itr = this.weightList.iterator();
        while (itr.hasNext()) {
            Pair<RandomBlockContainer, Integer> entry = itr.next();
            Block newBlock = ((RandomBlockContainer)entry.getKey()).getRandomBlock(rand, world);
            if (newBlock == null) {
                itr.remove();
                continue;
            }
            this.totalMaxWeight += ((Integer)entry.getRight()).intValue();
        }
        this.totalMaxWeight = Math.max(this.minWeight, this.totalMaxWeight);
    }

    public BlockState getRandomState(Random rand, World world) {
        Block block = this.fillBlock.getRandomBlock(rand, world);
        if (this.totalMaxWeight > 0) {
            int randNum = rand.nextInt(this.totalMaxWeight);
            for (Pair<RandomBlockContainer, Integer> entry : this.weightList) {
                if ((randNum -= ((Integer)entry.getValue()).intValue()) >= 0) continue;
                Block newBlock = ((RandomBlockContainer)entry.getKey()).getRandomBlock(rand, world);
                if (newBlock == null) break;
                block = newBlock;
                break;
            }
        }
        if (block != null) {
            return block.func_176223_P();
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public boolean checkIfSphereShell(int xR, int xOff, int yOff, int zOff) {
        if (!this.checkIfSphere(xR, xOff, yOff, zOff)) {
            return false;
        }
        return !this.checkIfSphere(xR, xOff + 1, yOff, zOff) || !this.checkIfSphere(xR, xOff - 1, yOff, zOff) || !this.checkIfSphere(xR, xOff, yOff + 1, zOff) || !this.checkIfSphere(xR, xOff, yOff - 1, zOff) || !this.checkIfSphere(xR, xOff, yOff, zOff + 1) || !this.checkIfSphere(xR, xOff, yOff, zOff - 1);
    }

    public boolean checkIfSphere(float R, float xOff, float yOff, float zOff) {
        float possOffset = 0.5f;
        return xOff * xOff + yOff * yOff + zOff * zOff <= (R + possOffset) * (R + possOffset);
    }

    public JsonObject serialize() {
        JsonObject json = new JsonObject();
        json.addProperty("radius", (Number)this.layerRadius);
        json.addProperty("additionalWeight", (Number)this.additionalTotalWeight);
        json.addProperty("minWeight", (Number)this.minWeight);
        if (this.weightList.size() > 0) {
            JsonArray mainArray = new JsonArray();
            for (Pair<RandomBlockContainer, Integer> weightedPair : this.weightList) {
                JsonObject jsonObj = new JsonObject();
                jsonObj.addProperty("tag", ((RandomBlockContainer)weightedPair.getKey()).getEntry());
                jsonObj.addProperty("weight", (Number)weightedPair.getValue());
                mainArray.add((JsonElement)jsonObj);
            }
            json.add("weightMap", (JsonElement)mainArray);
        }
        json.addProperty("fill", this.fillBlock.getEntry());
        if (this.shellBlock != null) {
            json.addProperty("shell", this.shellBlock.getEntry());
        }
        return json;
    }

    public static MeteorLayer deserialize(JsonObject json) {
        int layerRadius = JSONUtils.func_151203_m((JsonObject)json, (String)"radius");
        int maxWeight = JSONUtils.func_151203_m((JsonObject)json, (String)"additionalWeight");
        int minWeight = JSONUtils.func_151203_m((JsonObject)json, (String)"minWeight");
        ArrayList<Pair<RandomBlockContainer, Integer>> weightList = new ArrayList<Pair<RandomBlockContainer, Integer>>();
        if (json.has("weightMap") && JSONUtils.func_151202_d((JsonObject)json, (String)"weightMap")) {
            JsonArray mainArray = JSONUtils.func_151214_t((JsonObject)json, (String)"weightMap");
            for (JsonElement element : mainArray) {
                JsonObject obj = element.getAsJsonObject();
                RandomBlockContainer container = RandomBlockContainer.parseEntry(JSONUtils.func_151200_h((JsonObject)obj, (String)"tag"));
                int weight = JSONUtils.func_151203_m((JsonObject)obj, (String)"weight");
                if (container == null) continue;
                weightList.add((Pair<RandomBlockContainer, Integer>)Pair.of((Object)container, (Object)weight));
            }
        }
        RandomBlockContainer fillBlock = RandomBlockContainer.parseEntry(JSONUtils.func_151200_h((JsonObject)json, (String)"fill"));
        MeteorLayer layer = new MeteorLayer(layerRadius, maxWeight, weightList, fillBlock);
        if (JSONUtils.func_151204_g((JsonObject)json, (String)"shell")) {
            layer.addShellBlock(RandomBlockContainer.parseEntry(JSONUtils.func_151200_h((JsonObject)json, (String)"shell")));
        }
        layer.setMinWeight(minWeight);
        return layer;
    }

    public void write(PacketBuffer buffer) {
        buffer.writeInt(this.layerRadius);
        buffer.writeInt(this.additionalTotalWeight);
        buffer.writeInt(this.minWeight);
        buffer.writeInt(this.weightList.size());
        for (int i = 0; i < this.weightList.size(); ++i) {
            buffer.func_180714_a(((RandomBlockContainer)this.weightList.get(i).getKey()).getEntry());
            buffer.writeInt(((Integer)this.weightList.get(i).getValue()).intValue());
        }
        buffer.func_180714_a(this.fillBlock.getEntry());
        if (this.shellBlock == null) {
            buffer.func_180714_a("");
        } else {
            buffer.func_180714_a(this.shellBlock.getEntry());
        }
    }

    public static MeteorLayer read(@Nonnull PacketBuffer buffer) {
        int layerRadius = buffer.readInt();
        int maxWeight = buffer.readInt();
        int minWeight = buffer.readInt();
        int listSize = buffer.readInt();
        ArrayList<Pair<RandomBlockContainer, Integer>> weightList = new ArrayList<Pair<RandomBlockContainer, Integer>>();
        for (int i = 0; i < listSize; ++i) {
            String entry = buffer.func_218666_n();
            int weight = buffer.readInt();
            if (entry.isEmpty()) continue;
            RandomBlockContainer container = RandomBlockContainer.parseEntry(entry);
            weightList.add((Pair<RandomBlockContainer, Integer>)Pair.of((Object)container, (Object)weight));
        }
        RandomBlockContainer fillBlock = RandomBlockContainer.parseEntry(buffer.func_218666_n());
        MeteorLayer layer = new MeteorLayer(layerRadius, maxWeight, weightList, fillBlock);
        String shellEntry = buffer.func_218666_n();
        if (!shellEntry.isEmpty()) {
            layer.addShellBlock(RandomBlockContainer.parseEntry(shellEntry));
        }
        layer.setMinWeight(minWeight);
        return layer;
    }
}

