/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.api.compat.IDemonWillGem;
import wayoftime.bloodmagic.common.loot.BloodMagicLootFunctionManager;

public class SetWillFraction
extends LootFunction {
    private static final Logger LOGGER = LogManager.getLogger();
    private final RandomValueRange damageRange;

    private SetWillFraction(ILootCondition[] conditionsIn, RandomValueRange damageRangeIn) {
        super(conditionsIn);
        this.damageRange = damageRangeIn;
    }

    public LootFunctionType func_230425_b_() {
        return BloodMagicLootFunctionManager.SET_WILL_FRACTION;
    }

    public ItemStack func_215859_a(ItemStack stack, LootContext context) {
        if (stack.func_77973_b() instanceof IDemonWillGem) {
            int maxWill = ((IDemonWillGem)stack.func_77973_b()).getMaxWill(EnumDemonWillType.DEFAULT, stack);
            float f = 1.0f - this.damageRange.func_186507_b(context.func_216032_b());
            ((IDemonWillGem)stack.func_77973_b()).setWill(EnumDemonWillType.DEFAULT, stack, (float)maxWill * f);
        } else {
            LOGGER.warn("Couldn't set will of loot item {}", (Object)stack);
        }
        return stack;
    }

    public static LootFunction.Builder<?> withRange(RandomValueRange p_215931_0_) {
        return SetWillFraction.func_215860_a(p_215930_1_ -> new SetWillFraction((ILootCondition[])p_215930_1_, p_215931_0_));
    }

    public static class Serializer
    extends LootFunction.Serializer<SetWillFraction> {
        public void serialize(JsonObject p_230424_1_, SetWillFraction p_230424_2_, JsonSerializationContext p_230424_3_) {
            super.func_230424_a_(p_230424_1_, (LootFunction)p_230424_2_, p_230424_3_);
            p_230424_1_.add("damage", p_230424_3_.serialize((Object)p_230424_2_.damageRange));
        }

        public SetWillFraction deserialize(JsonObject object, JsonDeserializationContext deserializationContext, ILootCondition[] conditionsIn) {
            return new SetWillFraction(conditionsIn, (RandomValueRange)JSONUtils.func_188174_a((JsonObject)object, (String)"damage", (JsonDeserializationContext)deserializationContext, RandomValueRange.class));
        }
    }
}

