/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.soul;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.api.compat.IDemonWill;
import wayoftime.bloodmagic.util.ChatUtil;
import wayoftime.bloodmagic.util.helper.NBTHelper;

public class ItemMonsterSoul
extends Item
implements IDemonWill {
    private final EnumDemonWillType type;

    public ItemMonsterSoul(EnumDemonWillType type) {
        super(new Item.Properties().func_200917_a(1).func_200916_a(BloodMagic.TAB));
        this.type = type;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        if (!stack.func_77942_o()) {
            return;
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.will", new Object[]{ChatUtil.DECIMAL_FORMAT.format(this.getWill(this.getType(stack), stack))}).func_240699_a_(TextFormatting.GRAY));
        super.func_77624_a(stack, world, tooltip, flag);
    }

    @Override
    public EnumDemonWillType getType(ItemStack stack) {
        return this.type;
    }

    @Override
    public double getWill(EnumDemonWillType type, ItemStack soulStack) {
        if (type != this.getType(soulStack)) {
            return 0.0;
        }
        NBTHelper.checkNBT(soulStack);
        CompoundNBT tag = soulStack.func_77978_p();
        return tag.func_74769_h("souls");
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            ItemStack stack = new ItemStack((IItemProvider)this);
            this.setWill(this.type, stack, 5.0);
            items.add((Object)stack);
        }
    }

    @Override
    public boolean setWill(EnumDemonWillType type, ItemStack soulStack, double souls) {
        if (type != this.getType(soulStack)) {
            return false;
        }
        NBTHelper.checkNBT(soulStack);
        CompoundNBT tag = soulStack.func_77978_p();
        tag.func_74780_a("souls", souls);
        return true;
    }

    @Override
    public double drainWill(EnumDemonWillType type, ItemStack soulStack, double drainAmount) {
        double souls = this.getWill(type, soulStack);
        double soulsDrained = Math.min(drainAmount, souls);
        this.setWill(type, soulStack, souls - soulsDrained);
        return soulsDrained;
    }

    @Override
    public ItemStack createWill(double number) {
        ItemStack soulStack = new ItemStack((IItemProvider)this);
        this.setWill(this.getType(soulStack), soulStack, number);
        return soulStack;
    }
}

