/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.routing;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.common.routing.IMasterRoutingNode;
import wayoftime.bloodmagic.common.routing.INodeRenderer;
import wayoftime.bloodmagic.common.routing.IRoutingNode;
import wayoftime.bloodmagic.util.helper.NBTHelper;

public class ItemNodeRouter
extends Item
implements INodeRenderer {
    public ItemNodeRouter() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(BloodMagic.TAB));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        if (!stack.func_77942_o()) {
            return;
        }
        CompoundNBT tag = stack.func_77978_p();
        BlockPos coords = this.getBlockPos(stack);
        if (coords != null && tag != null) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.telepositionfocus.coords", new Object[]{coords.func_177958_n(), coords.func_177956_o(), coords.func_177952_p()}));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ActionResultType func_195939_a(ItemUseContext context) {
        Hand hand = context.func_221531_n();
        PlayerEntity player = context.func_195999_j();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return ActionResultType.PASS;
        }
        TileEntity tileHit = world.func_175625_s(pos);
        if (!(tileHit instanceof IRoutingNode)) {
            BlockPos containedPos = this.getBlockPos(stack);
            if (containedPos.equals((Object)BlockPos.field_177992_a)) return ActionResultType.FAIL;
            this.setBlockPos(stack, BlockPos.field_177992_a);
            player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.bloodmagic.routing.remove"), true);
            return ActionResultType.FAIL;
        }
        IRoutingNode node = (IRoutingNode)tileHit;
        BlockPos containedPos = this.getBlockPos(stack);
        if (containedPos.equals((Object)BlockPos.field_177992_a)) {
            this.setBlockPos(stack, pos);
            player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.bloodmagic.routing.set"), true);
            return ActionResultType.SUCCESS;
        }
        if (containedPos.func_177951_i((Vector3i)pos) > 256.0) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.bloodmagic.routing.distance"), true);
            return ActionResultType.SUCCESS;
        }
        if (containedPos.equals((Object)pos)) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.bloodmagic.routing.same"), true);
            return ActionResultType.SUCCESS;
        }
        TileEntity pastTile = world.func_175625_s(containedPos);
        if (!(pastTile instanceof IRoutingNode)) return ActionResultType.FAIL;
        IRoutingNode pastNode = (IRoutingNode)pastTile;
        if (pastNode instanceof IMasterRoutingNode) {
            IMasterRoutingNode master = (IMasterRoutingNode)pastNode;
            if (!node.isMaster(master)) {
                if (!node.getMasterPos().equals((Object)BlockPos.field_177992_a)) return ActionResultType.FAIL;
                node.connectMasterToRemainingNode(world, new LinkedList<BlockPos>(), master);
                master.addConnection(pos, containedPos);
                master.addNodeToList(node);
                node.addConnection(containedPos);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.bloodmagic.routing.link.master"), true);
                this.setBlockPos(stack, BlockPos.field_177992_a);
                return ActionResultType.SUCCESS;
            }
            master.addConnection(pos, containedPos);
            node.addConnection(containedPos);
            player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.bloodmagic.routing.link.master"), true);
            this.setBlockPos(stack, BlockPos.field_177992_a);
            return ActionResultType.SUCCESS;
        }
        if (node instanceof IMasterRoutingNode) {
            IMasterRoutingNode master = (IMasterRoutingNode)node;
            if (!pastNode.isMaster(master)) {
                if (!pastNode.getMasterPos().equals((Object)BlockPos.field_177992_a)) return ActionResultType.FAIL;
                pastNode.connectMasterToRemainingNode(world, new LinkedList<BlockPos>(), master);
                master.addConnection(pos, containedPos);
                pastNode.addConnection(pos);
                master.addNodeToList(pastNode);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.bloodmagic.routing.link.master"), true);
                this.setBlockPos(stack, BlockPos.field_177992_a);
                return ActionResultType.SUCCESS;
            }
            master.addConnection(pos, containedPos);
            pastNode.addConnection(pos);
            player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.bloodmagic.routing.link.master"), true);
            this.setBlockPos(stack, BlockPos.field_177992_a);
            return ActionResultType.SUCCESS;
        }
        if (pastNode.getMasterPos().equals((Object)node.getMasterPos())) {
            TileEntity testTile;
            if (!pastNode.getMasterPos().equals((Object)BlockPos.field_177992_a) && (testTile = world.func_175625_s(pastNode.getMasterPos())) instanceof IMasterRoutingNode) {
                IMasterRoutingNode master = (IMasterRoutingNode)testTile;
                master.addConnection(pos, containedPos);
            }
            pastNode.addConnection(pos);
            node.addConnection(containedPos);
            player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.bloodmagic.routing.link"), true);
            this.setBlockPos(stack, BlockPos.field_177992_a);
            return ActionResultType.SUCCESS;
        }
        if (pastNode.getMasterPos().equals((Object)BlockPos.field_177992_a)) {
            TileEntity tile = world.func_175625_s(node.getMasterPos());
            if (tile instanceof IMasterRoutingNode) {
                IMasterRoutingNode master = (IMasterRoutingNode)tile;
                master.addConnection(pos, containedPos);
                master.addNodeToList(pastNode);
                pastNode.connectMasterToRemainingNode(world, new LinkedList<BlockPos>(), master);
            }
            pastNode.addConnection(pos);
            node.addConnection(containedPos);
            player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.bloodmagic.routing.link"), true);
            this.setBlockPos(stack, BlockPos.field_177992_a);
            return ActionResultType.SUCCESS;
        }
        if (node.getMasterPos().equals((Object)BlockPos.field_177992_a)) {
            TileEntity tile = world.func_175625_s(pastNode.getMasterPos());
            if (tile instanceof IMasterRoutingNode) {
                IMasterRoutingNode master = (IMasterRoutingNode)tile;
                master.addConnection(pos, containedPos);
                master.addNodeToList(node);
                node.connectMasterToRemainingNode(world, new LinkedList<BlockPos>(), master);
            }
            pastNode.addConnection(pos);
            node.addConnection(containedPos);
            player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.bloodmagic.routing.link"), true);
            this.setBlockPos(stack, BlockPos.field_177992_a);
            return ActionResultType.SUCCESS;
        }
        this.setBlockPos(stack, BlockPos.field_177992_a);
        return ActionResultType.SUCCESS;
    }

    public BlockPos getBlockPos(ItemStack stack) {
        stack = NBTHelper.checkNBT(stack);
        return new BlockPos(stack.func_77978_p().func_74762_e("xCoord"), stack.func_77978_p().func_74762_e("yCoord"), stack.func_77978_p().func_74762_e("zCoord"));
    }

    public ItemStack setBlockPos(ItemStack stack, BlockPos pos) {
        NBTHelper.checkNBT(stack);
        CompoundNBT itemTag = stack.func_77978_p();
        itemTag.func_74768_a("xCoord", pos.func_177958_n());
        itemTag.func_74768_a("yCoord", pos.func_177956_o());
        itemTag.func_74768_a("zCoord", pos.func_177952_p());
        return stack;
    }
}

