/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.routing;

import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import wayoftime.bloodmagic.common.item.routing.IFilterKey;

public class CollectionEnchantFilterKey
implements IFilterKey {
    private Map<Enchantment, Integer> enchantMap;
    private boolean isFuzzy;
    private boolean matchAll;
    private int count;

    public CollectionEnchantFilterKey(Map<Enchantment, Integer> enchantMap, boolean isFuzzy, boolean matchAll, int count) {
        this.enchantMap = enchantMap;
        this.isFuzzy = isFuzzy;
        this.matchAll = matchAll;
        this.count = count;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean doesStackMatch(ItemStack testStack) {
        for (Map.Entry<Enchantment, Integer> entry : this.enchantMap.entrySet()) {
            int level = 0;
            if (testStack.func_77973_b() == Items.field_151134_bR) {
                Map enchants = EnchantmentHelper.func_82781_a((ItemStack)testStack);
                if (!enchants.containsKey(entry.getKey())) return false;
                level = (Integer)enchants.get(entry.getKey());
            } else {
                level = EnchantmentHelper.func_77506_a((Enchantment)entry.getKey(), (ItemStack)testStack);
            }
            if (this.isFuzzy ? level > 0 : level == entry.getValue()) {
                if (this.matchAll) continue;
                return true;
            }
            if (!this.matchAll) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public void setCount(int count) {
        this.count = count;
    }

    @Override
    public void shrink(int changeAmount) {
        this.count -= changeAmount;
    }

    @Override
    public void grow(int changeAmount) {
        this.count += changeAmount;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }
}

