/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.HoeItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.api.compat.IDemonWill;
import wayoftime.bloodmagic.api.compat.IDemonWillWeapon;
import wayoftime.bloodmagic.api.compat.IMultiWillTool;
import wayoftime.bloodmagic.common.item.BMItemTier;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.common.tags.BloodMagicTags;
import wayoftime.bloodmagic.util.helper.NBTHelper;
import wayoftime.bloodmagic.will.PlayerDemonWillHandler;

public class ItemSentientScythe
extends HoeItem
implements IDemonWillWeapon,
IMultiWillTool {
    public static int[] soulBracket = new int[]{16, 60, 200, 400, 1000};
    public static double[] defaultDamageAdded = new double[]{0.5, 1.0, 1.5, 2.0, 2.5};
    public static double[] destructiveDamageAdded = new double[]{1.0, 1.5, 2.0, 2.5, 3.0};
    public static double[] vengefulDamageAdded = new double[]{0.0, 0.5, 1.0, 1.5, 2.0};
    public static double[] steadfastDamageAdded = new double[]{0.0, 0.5, 1.0, 1.5, 2.0};
    public static double[] defaultDigSpeedAdded = new double[]{1.0, 1.5, 2.0, 3.0, 4.0};
    public static double[] soulDrainPerSwing = new double[]{0.05, 0.1, 0.2, 0.4, 0.75};
    public static double[] soulDrop = new double[]{2.0, 4.0, 7.0, 10.0, 13.0};
    public static double[] staticDrop = new double[]{1.0, 1.0, 2.0, 3.0, 3.0};
    public static double[] healthBonus = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
    public static double[] vengefulAttackSpeed = new double[]{-3.0, -2.8, -2.7, -2.6, -2.5};
    public static double[] destructiveAttackSpeed = new double[]{-3.1, -3.1, -3.2, -3.3, -3.3};
    public static int[] absorptionTime = new int[]{200, 300, 400, 500, 600};
    public static double maxAbsorptionHearts = 10.0;
    public static int[] poisonTime = new int[]{25, 50, 60, 80, 100};
    public static int[] poisonLevel = new int[]{0, 0, 0, 1, 1};
    public static double[] movementSpeed = new double[]{0.05, 0.1, 0.15, 0.2, 0.25};
    public static final double baseAttackDamage = 4.0;
    public static final double baseAttackSpeed = -3.0;
    private static Map<UUID, Boolean> hitMap = new HashMap<UUID, Boolean>();

    public ItemSentientScythe() {
        super((IItemTier)BMItemTier.SENTIENT, 4, -3.0f, new Item.Properties().func_200918_c(520).func_200916_a(BloodMagic.TAB));
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return BloodMagicTags.CRYSTAL_DEMON.func_230235_a_((Object)repair.func_77973_b()) || super.func_82789_a(toRepair, repair);
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        float value = super.func_150893_a(stack, state);
        if (value > 1.0f) {
            return (float)((double)value + this.getDigSpeedOfSword(stack));
        }
        return value;
    }

    public void recalculatePowers(ItemStack stack, World world, PlayerEntity player) {
        EnumDemonWillType type = PlayerDemonWillHandler.getLargestWillType(player);
        double soulsRemaining = PlayerDemonWillHandler.getTotalDemonWill(type, player);
        this.setCurrentType(stack, soulsRemaining > 0.0 ? type : EnumDemonWillType.DEFAULT);
        int level = this.getLevel(stack, soulsRemaining);
        double drain = level >= 0 ? soulDrainPerSwing[level] : 0.0;
        double extraDamage = this.getExtraDamage(type, level);
        this.setDrainOfActivatedSword(stack, drain);
        this.setDamageOfActivatedSword(stack, 4.0 + extraDamage);
        this.setStaticDropOfActivatedSword(stack, level >= 0 ? staticDrop[level] : 1.0);
        this.setDropOfActivatedSword(stack, level >= 0 ? soulDrop[level] : 0.0);
        this.setAttackSpeedOfSword(stack, level >= 0 ? this.getAttackSpeed(type, level) : -3.0);
        this.setHealthBonusOfSword(stack, level >= 0 ? this.getHealthBonus(type, level) : 0.0);
        this.setSpeedOfSword(stack, level >= 0 ? this.getMovementSpeed(type, level) : 0.0);
        this.setDigSpeedOfSword(stack, level >= 0 ? this.getDigSpeed(type, level) : 0.0);
    }

    public double getExtraDamage(EnumDemonWillType type, int willBracket) {
        if (willBracket < 0) {
            return 0.0;
        }
        switch (type) {
            case CORROSIVE: 
            case DEFAULT: {
                return defaultDamageAdded[willBracket];
            }
            case DESTRUCTIVE: {
                return destructiveDamageAdded[willBracket];
            }
            case VENGEFUL: {
                return vengefulDamageAdded[willBracket];
            }
            case STEADFAST: {
                return steadfastDamageAdded[willBracket];
            }
        }
        return 0.0;
    }

    public double getAttackSpeed(EnumDemonWillType type, int willBracket) {
        switch (type) {
            case VENGEFUL: {
                return vengefulAttackSpeed[willBracket];
            }
            case DESTRUCTIVE: {
                return destructiveAttackSpeed[willBracket];
            }
        }
        return -2.9;
    }

    public double getHealthBonus(EnumDemonWillType type, int willBracket) {
        switch (type) {
            case STEADFAST: {
                return healthBonus[willBracket];
            }
        }
        return 0.0;
    }

    public double getMovementSpeed(EnumDemonWillType type, int willBracket) {
        switch (type) {
            case VENGEFUL: {
                return movementSpeed[willBracket];
            }
        }
        return 0.0;
    }

    public double getDigSpeed(EnumDemonWillType type, int willBracket) {
        switch (type) {
            default: 
        }
        return defaultDigSpeedAdded[willBracket];
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity attacker) {
        if (attacker instanceof PlayerEntity) {
            PlayerEntity attackerPlayer = (PlayerEntity)attacker;
            this.recalculatePowers(stack, attackerPlayer.func_130014_f_(), attackerPlayer);
            EnumDemonWillType type = this.getCurrentType(stack);
            double will = PlayerDemonWillHandler.getTotalDemonWill(type, attackerPlayer);
            int willBracket = this.getLevel(stack, will);
            this.recalculatePowers(stack, attacker.field_70170_p, attackerPlayer);
            this.attackEntitiesInAreaExcludingEntity(stack, attackerPlayer, type, willBracket, null);
        }
        return false;
    }

    public void attackEntitiesInAreaExcludingEntity(ItemStack stack, PlayerEntity attacker, EnumDemonWillType type, int willBracket, LivingEntity attackedEntity) {
        boolean flag;
        double verticalRange = 2.0;
        double horizontalRange = 2.0;
        double range = 2.0;
        AxisAlignedBB aabb = null;
        List list = null;
        if (attackedEntity != null) {
            aabb = attackedEntity.func_174813_aQ().func_72321_a(horizontalRange, verticalRange, horizontalRange);
            list = attacker.field_70170_p.func_175674_a((Entity)attackedEntity, aabb, EntityPredicates.field_94557_a);
        } else {
            Vector3d eyeVec = attacker.func_174824_e(1.0f).func_178787_e(attacker.func_70040_Z().func_186678_a(range));
            aabb = new AxisAlignedBB(eyeVec.func_82615_a() - horizontalRange, eyeVec.func_82617_b() - verticalRange, eyeVec.func_82616_c() - horizontalRange, eyeVec.func_82615_a() + horizontalRange, eyeVec.func_82617_b() + verticalRange, eyeVec.func_82616_c() + horizontalRange);
            list = attacker.field_70170_p.func_175674_a((Entity)attacker, aabb, EntityPredicates.field_94557_a);
        }
        list = attacker.field_70170_p.func_217357_a(LivingEntity.class, aabb);
        float f = (float)attacker.func_233637_b_(Attributes.field_233823_f_);
        float f2 = attacker.func_184825_o(0.5f);
        f *= 0.2f + f2 * f2 * 0.8f;
        attacker.func_184821_cY();
        boolean flag1 = false;
        int i = 0;
        i += EnchantmentHelper.func_77501_a((LivingEntity)attacker);
        boolean bl = flag = f2 > 0.9f;
        if (attacker.func_70051_ag() && flag) {
            attacker.field_70170_p.func_184148_a((PlayerEntity)null, attacker.func_226277_ct_(), attacker.func_226278_cu_(), attacker.func_226281_cx_(), SoundEvents.field_187721_dT, attacker.func_184176_by(), 1.0f, 1.0f);
            ++i;
            flag1 = true;
        }
        boolean didHit = false;
        boolean strongAttackHit = false;
        boolean weakAttackHit = false;
        boolean noDamageHit = false;
        for (Entity targetEntity : list) {
            if (targetEntity.equals((Object)attacker) || !targetEntity.func_70075_an() || targetEntity.func_85031_j((Entity)attacker)) continue;
            float f1 = targetEntity instanceof LivingEntity ? EnchantmentHelper.func_152377_a((ItemStack)stack, (CreatureAttribute)((LivingEntity)targetEntity).func_70668_bt()) : EnchantmentHelper.func_152377_a((ItemStack)stack, (CreatureAttribute)CreatureAttribute.field_223222_a_);
            f1 *= f2;
            if (!(f > 0.0f) && !(f1 > 0.0f)) continue;
            boolean flag2 = flag && attacker.field_70143_R > 0.0f && !attacker.func_233570_aj_() && !attacker.func_70617_f_() && !attacker.func_70090_H() && !attacker.func_70644_a(Effects.field_76440_q) && !attacker.func_184218_aH() && targetEntity instanceof LivingEntity;
            flag2 = flag2 && !attacker.func_70051_ag();
            CriticalHitEvent hitResult = ForgeHooks.getCriticalHit((PlayerEntity)attacker, (Entity)targetEntity, (boolean)flag2, (float)(flag2 ? 1.5f : 1.0f));
            boolean bl2 = flag2 = hitResult != null;
            if (flag2) {
                f *= hitResult.getDamageModifier();
            }
            f += f1;
            boolean flag3 = false;
            double d0 = attacker.field_70140_Q - attacker.field_70141_P;
            float f4 = 0.0f;
            boolean flag4 = false;
            int j = EnchantmentHelper.func_90036_a((LivingEntity)attacker);
            if (targetEntity instanceof LivingEntity) {
                f4 = ((LivingEntity)targetEntity).func_110143_aJ();
                if (j > 0 && !targetEntity.func_70027_ad()) {
                    flag4 = true;
                    targetEntity.func_70015_d(1);
                }
            }
            Vector3d vector3d = targetEntity.func_213322_ci();
            boolean flag5 = targetEntity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)attacker), f);
            if (flag5) {
                didHit = true;
                if (i > 0) {
                    if (targetEntity instanceof LivingEntity) {
                        ((LivingEntity)targetEntity).func_233627_a_((float)i * 0.5f, (double)MathHelper.func_76126_a((float)(attacker.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(attacker.field_70177_z * ((float)Math.PI / 180)))));
                    } else {
                        targetEntity.func_70024_g((double)(-MathHelper.func_76126_a((float)(attacker.field_70177_z * ((float)Math.PI / 180))) * (float)i * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(attacker.field_70177_z * ((float)Math.PI / 180))) * (float)i * 0.5f));
                    }
                }
                attacker.func_184810_cG();
                if (targetEntity instanceof ServerPlayerEntity && targetEntity.field_70133_I) {
                    ((ServerPlayerEntity)targetEntity).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket(targetEntity));
                    targetEntity.field_70133_I = false;
                    targetEntity.func_213317_d(vector3d);
                }
                if (flag2) {
                    attacker.func_71009_b(targetEntity);
                }
                if (!flag2 && !flag3) {
                    if (flag) {
                        strongAttackHit = true;
                    } else {
                        weakAttackHit = true;
                    }
                }
                if (f1 > 0.0f) {
                    attacker.func_71047_c(targetEntity);
                }
                attacker.func_130011_c(targetEntity);
                if (targetEntity instanceof LivingEntity) {
                    EnchantmentHelper.func_151384_a((LivingEntity)((LivingEntity)targetEntity), (Entity)attacker);
                }
                EnchantmentHelper.func_151385_b((LivingEntity)attacker, (Entity)targetEntity);
                ItemStack itemstack1 = stack;
                Entity entity = targetEntity;
                if (!attacker.field_70170_p.field_72995_K && !itemstack1.func_190926_b() && entity instanceof LivingEntity) {
                    ItemStack copy = itemstack1.func_77946_l();
                    itemstack1.func_77961_a((LivingEntity)entity, attacker);
                    if (itemstack1.func_190926_b()) {
                        ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)attacker, (ItemStack)copy, (Hand)Hand.MAIN_HAND);
                        attacker.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                    }
                }
                if (!(targetEntity instanceof LivingEntity)) continue;
                float f5 = f4 - ((LivingEntity)targetEntity).func_110143_aJ();
                attacker.func_195067_a(Stats.field_188111_y, Math.round(f5 * 10.0f));
                if (j > 0) {
                    targetEntity.func_70015_d(j * 4);
                }
                if (attacker.field_70170_p instanceof ServerWorld && f5 > 2.0f) {
                    int k = (int)((double)f5 * 0.5);
                    ((ServerWorld)attacker.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197615_h, targetEntity.func_226277_ct_(), targetEntity.func_226283_e_(0.5), targetEntity.func_226281_cx_(), k, 0.1, 0.0, 0.1, 0.2);
                }
                this.applyEffectToEntity(type, willBracket, (LivingEntity)targetEntity, attacker);
                continue;
            }
            noDamageHit = true;
            if (!flag4) continue;
            targetEntity.func_70066_B();
        }
        if (didHit) {
            if (flag1) {
                attacker.func_213317_d(attacker.func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
                attacker.func_70031_b(false);
            }
            attacker.func_71020_j(0.1f);
            attacker.field_70170_p.func_184148_a((PlayerEntity)null, attacker.func_226277_ct_(), attacker.func_226278_cu_(), attacker.func_226281_cx_(), SoundEvents.field_187730_dW, attacker.func_184176_by(), 1.0f, 1.0f);
        }
        if (noDamageHit) {
            attacker.field_70170_p.func_184148_a((PlayerEntity)null, attacker.func_226277_ct_(), attacker.func_226278_cu_(), attacker.func_226281_cx_(), SoundEvents.field_187724_dU, attacker.func_184176_by(), 1.0f, 1.0f);
        }
        if (strongAttackHit) {
            attacker.field_70170_p.func_184148_a((PlayerEntity)null, attacker.func_226277_ct_(), attacker.func_226278_cu_(), attacker.func_226281_cx_(), SoundEvents.field_187727_dV, attacker.func_184176_by(), 1.0f, 1.0f);
        }
        if (weakAttackHit) {
            attacker.field_70170_p.func_184148_a((PlayerEntity)null, attacker.func_226277_ct_(), attacker.func_226278_cu_(), attacker.func_226281_cx_(), SoundEvents.field_187733_dX, attacker.func_184176_by(), 1.0f, 1.0f);
        }
    }

    public void applyEffectToEntity(EnumDemonWillType type, int willBracket, LivingEntity target, PlayerEntity attacker) {
        switch (type) {
            case CORROSIVE: {
                target.func_195064_c(new EffectInstance(Effects.field_82731_v, poisonTime[willBracket], poisonLevel[willBracket]));
                break;
            }
            case DEFAULT: {
                break;
            }
            case DESTRUCTIVE: {
                break;
            }
            case STEADFAST: {
                if (target.func_70089_S()) break;
                float absorption = attacker.func_110139_bj();
                attacker.func_195064_c(new EffectInstance(Effects.field_76444_x, absorptionTime[willBracket], 127, true, false));
                attacker.func_110149_m((float)Math.min((double)(absorption + target.func_110138_aP() * 0.05f), maxAbsorptionHearts));
                break;
            }
        }
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.func_222118_a(1, attacker, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
        if (attacker instanceof PlayerEntity) {
            UUID id = attacker.func_110124_au();
            PlayerEntity attackerPlayer = (PlayerEntity)attacker;
            if (hitMap.containsKey(id) && hitMap.get(id).booleanValue()) {
                EnumDemonWillType type = this.getCurrentType(stack);
                double will = PlayerDemonWillHandler.getTotalDemonWill(type, attackerPlayer);
                int willBracket = this.getLevel(stack, will);
                this.applyEffectToEntity(type, willBracket, target, attackerPlayer);
            } else {
                this.recalculatePowers(stack, attackerPlayer.func_130014_f_(), attackerPlayer);
                EnumDemonWillType type = this.getCurrentType(stack);
                double will = PlayerDemonWillHandler.getTotalDemonWill(type, attackerPlayer);
                int willBracket = this.getLevel(stack, will);
                hitMap.put(id, true);
                this.attackEntitiesInAreaExcludingEntity(stack, attackerPlayer, type, willBracket, target);
                hitMap.remove(id);
            }
        }
        return true;
    }

    @Override
    public EnumDemonWillType getCurrentType(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        CompoundNBT tag = stack.func_77978_p();
        if (!tag.func_74764_b("demonWillType")) {
            return EnumDemonWillType.DEFAULT;
        }
        return EnumDemonWillType.valueOf(tag.func_74779_i("demonWillType").toUpperCase(Locale.ROOT));
    }

    public void setCurrentType(ItemStack stack, EnumDemonWillType type) {
        NBTHelper.checkNBT(stack);
        CompoundNBT tag = stack.func_77978_p();
        tag.func_74778_a("demonWillType", type.toString());
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        this.recalculatePowers(player.func_184586_b(hand), world, player);
        return super.func_77659_a(world, player, hand);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.func_77973_b() != newStack.func_77973_b();
    }

    private int getLevel(ItemStack stack, double soulsRemaining) {
        int lvl = -1;
        for (int i = 0; i < soulBracket.length; ++i) {
            if (!(soulsRemaining >= (double)soulBracket[i])) continue;
            lvl = i;
        }
        return lvl;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        if (!stack.func_77942_o()) {
            return;
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.sentientAxe.desc").func_240699_a_(TextFormatting.GRAY));
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.currentType." + this.getCurrentType(stack).name().toLowerCase(Locale.ROOT)).func_240699_a_(TextFormatting.GRAY));
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        this.recalculatePowers(stack, player.func_130014_f_(), player);
        double drain = this.getDrainOfActivatedSword(stack);
        if (drain > 0.0) {
            EnumDemonWillType type = this.getCurrentType(stack);
            double soulsRemaining = PlayerDemonWillHandler.getTotalDemonWill(type, player);
            if (drain > soulsRemaining) {
                return false;
            }
            PlayerDemonWillHandler.consumeDemonWill(type, player, drain);
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    @Override
    public List<ItemStack> getRandomDemonWillDrop(LivingEntity killedEntity, LivingEntity attackingEntity, ItemStack stack, int looting) {
        IDemonWill soul;
        ArrayList<ItemStack> soulList = new ArrayList<ItemStack>();
        if (killedEntity.func_130014_f_().func_175659_aa() != Difficulty.PEACEFUL && !(killedEntity instanceof IMob)) {
            return soulList;
        }
        double willModifier = killedEntity instanceof SlimeEntity ? 0.67 : 1.0;
        EnumDemonWillType type = this.getCurrentType(stack);
        switch (type) {
            case CORROSIVE: {
                soul = (IDemonWill)BloodMagicItems.MONSTER_SOUL_CORROSIVE.get();
                break;
            }
            case DESTRUCTIVE: {
                soul = (IDemonWill)BloodMagicItems.MONSTER_SOUL_DESTRUCTIVE.get();
                break;
            }
            case STEADFAST: {
                soul = (IDemonWill)BloodMagicItems.MONSTER_SOUL_STEADFAST.get();
                break;
            }
            case VENGEFUL: {
                soul = (IDemonWill)BloodMagicItems.MONSTER_SOUL_VENGEFUL.get();
                break;
            }
            default: {
                soul = (IDemonWill)BloodMagicItems.MONSTER_SOUL_RAW.get();
            }
        }
        for (int i = 0; i <= looting; ++i) {
            if (i != 0 && !(attackingEntity.func_130014_f_().field_73012_v.nextDouble() < 0.4)) continue;
            ItemStack soulStack = soul.createWill(willModifier * (this.getDropOfActivatedSword(stack) * attackingEntity.func_130014_f_().field_73012_v.nextDouble() + this.getStaticDropOfActivatedSword(stack)) * (double)killedEntity.func_110138_aP() / 20.0);
            soulList.add(soulStack);
        }
        return soulList;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EquipmentSlotType.MAINHAND) {
            multimap.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", this.getDamageOfActivatedSword(stack), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", this.getAttackSpeedOfSword(stack), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.field_233818_a_, (Object)new AttributeModifier(new UUID(0L, 31818145L), "Weapon modifier", this.getHealthBonusOfSword(stack), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.field_233821_d_, (Object)new AttributeModifier(new UUID(0L, 4218052L), "Weapon modifier", this.getSpeedOfSword(stack), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    public double getDamageOfActivatedSword(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        CompoundNBT tag = stack.func_77978_p();
        return tag.func_74769_h("soulSwordDamage");
    }

    public void setDamageOfActivatedSword(ItemStack stack, double damage) {
        NBTHelper.checkNBT(stack);
        CompoundNBT tag = stack.func_77978_p();
        tag.func_74780_a("soulSwordDamage", damage);
    }

    public double getDrainOfActivatedSword(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        CompoundNBT tag = stack.func_77978_p();
        return tag.func_74769_h("soulSwordActiveDrain");
    }

    public void setDrainOfActivatedSword(ItemStack stack, double drain) {
        NBTHelper.checkNBT(stack);
        CompoundNBT tag = stack.func_77978_p();
        tag.func_74780_a("soulSwordActiveDrain", drain);
    }

    public double getStaticDropOfActivatedSword(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        CompoundNBT tag = stack.func_77978_p();
        return tag.func_74769_h("soulSwordStaticDrop");
    }

    public void setStaticDropOfActivatedSword(ItemStack stack, double drop) {
        NBTHelper.checkNBT(stack);
        CompoundNBT tag = stack.func_77978_p();
        tag.func_74780_a("soulSwordStaticDrop", drop);
    }

    public double getDropOfActivatedSword(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        CompoundNBT tag = stack.func_77978_p();
        return tag.func_74769_h("soulSwordDrop");
    }

    public void setDropOfActivatedSword(ItemStack stack, double drop) {
        NBTHelper.checkNBT(stack);
        CompoundNBT tag = stack.func_77978_p();
        tag.func_74780_a("soulSwordDrop", drop);
    }

    public double getHealthBonusOfSword(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        CompoundNBT tag = stack.func_77978_p();
        return tag.func_74769_h("soulSwordHealth");
    }

    public void setHealthBonusOfSword(ItemStack stack, double hp) {
        NBTHelper.checkNBT(stack);
        CompoundNBT tag = stack.func_77978_p();
        tag.func_74780_a("soulSwordHealth", hp);
    }

    public double getAttackSpeedOfSword(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        CompoundNBT tag = stack.func_77978_p();
        return tag.func_74769_h("soulSwordAttackSpeed");
    }

    public void setAttackSpeedOfSword(ItemStack stack, double speed) {
        NBTHelper.checkNBT(stack);
        CompoundNBT tag = stack.func_77978_p();
        tag.func_74780_a("soulSwordAttackSpeed", speed);
    }

    public double getSpeedOfSword(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        CompoundNBT tag = stack.func_77978_p();
        return tag.func_74769_h("soulSwordSpeed");
    }

    public void setSpeedOfSword(ItemStack stack, double speed) {
        NBTHelper.checkNBT(stack);
        CompoundNBT tag = stack.func_77978_p();
        tag.func_74780_a("soulSwordSpeed", speed);
    }

    public double getDigSpeedOfSword(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        CompoundNBT tag = stack.func_77978_p();
        return tag.func_74769_h("soulSwordDigSpeed");
    }

    public void setDigSpeedOfSword(ItemStack stack, double speed) {
        NBTHelper.checkNBT(stack);
        CompoundNBT tag = stack.func_77978_p();
        tag.func_74780_a("soulSwordDigSpeed", speed);
    }
}

