/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.common.item.inventory.ContainerTrainingBracelet;
import wayoftime.bloodmagic.common.item.inventory.InventoryTrainingBracelet;
import wayoftime.bloodmagic.core.living.ILivingContainer;
import wayoftime.bloodmagic.core.living.LivingStats;
import wayoftime.bloodmagic.core.living.LivingUpgrade;
import wayoftime.bloodmagic.util.Utils;

public class ItemLivingTrainer
extends Item
implements ILivingContainer,
INamedContainerProvider {
    public static final int MAX_SIZE = 16;

    public ItemLivingTrainer() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(BloodMagic.TAB));
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            Utils.setUUID(stack);
            ILivingContainer.setDisplayIfZero(stack, true);
            if (player instanceof ServerPlayerEntity) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this, buf -> buf.writeItemStack(stack, false));
            }
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        if (stack.func_77978_p() != null) {
            LivingStats stats = this.getLivingStats(stack);
            if (stats == null) {
                return;
            }
            boolean isWhitelist = this.getIsWhitelist(stack);
            if (isWhitelist) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.trainer.whitelist"));
            } else {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.trainer.blacklist"));
            }
            HashMap<LivingUpgrade, Integer> positiveUpgradeMap = new HashMap<LivingUpgrade, Integer>();
            ArrayList zeroUpgradeList = new ArrayList();
            stats.getUpgrades().forEach((k, v) -> {
                int level = k.getLevel(v.intValue());
                if (level > 0) {
                    positiveUpgradeMap.put((LivingUpgrade)((Object)k), level);
                } else {
                    zeroUpgradeList.add(k);
                }
            });
            positiveUpgradeMap.forEach((k, v) -> tooltip.add((ITextComponent)new TranslationTextComponent("%s %s", new Object[]{new TranslationTextComponent(k.getTranslationKey()), new TranslationTextComponent("enchantment.level." + v)}).func_240699_a_(TextFormatting.GRAY)));
            if (!zeroUpgradeList.isEmpty() && !isWhitelist) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.trainer.deny"));
                for (LivingUpgrade upgrade : zeroUpgradeList) {
                    tooltip.add((ITextComponent)new TranslationTextComponent(upgrade.getTranslationKey()).func_240699_a_(TextFormatting.GRAY));
                }
            }
        }
    }

    public void setIsWhitelist(ItemStack trainerStack, boolean isWhitelist) {
        if (trainerStack.func_77978_p() == null) {
            trainerStack.func_77982_d(new CompoundNBT());
        }
        trainerStack.func_77978_p().func_74757_a("button:blackwhitelist", isWhitelist);
    }

    public boolean getIsWhitelist(ItemStack trainerStack) {
        if (trainerStack.func_77978_p() == null) {
            trainerStack.func_77982_d(new CompoundNBT());
        }
        return trainerStack.func_77978_p().func_74767_n("button:blackwhitelist");
    }

    public Container createMenu(int p_createMenu_1_, PlayerInventory p_createMenu_2_, PlayerEntity player) {
        assert (player.func_130014_f_() != null);
        return new ContainerTrainingBracelet(p_createMenu_1_, player, p_createMenu_2_, player.func_184614_ca());
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent("Bracelet");
    }

    public void setTomeLevel(ItemStack trainerStack, int slot, int desiredLevel) {
        InventoryTrainingBracelet inv = new InventoryTrainingBracelet(trainerStack);
        ItemStack tomeStack = inv.func_70301_a(slot);
        if (!tomeStack.func_190926_b() && tomeStack.func_77973_b() instanceof ILivingContainer) {
            LivingStats tomeStats = ((ILivingContainer)tomeStack.func_77973_b()).getLivingStats(tomeStack);
            if (tomeStats != null) {
                LivingStats newStats = new LivingStats();
                for (Map.Entry<LivingUpgrade, Double> entry : tomeStats.getUpgrades().entrySet()) {
                    int maxLevel = entry.getKey().getLevel(Integer.MAX_VALUE);
                    desiredLevel = Math.min(desiredLevel, maxLevel);
                    double wantedExp = entry.getKey().getLevelExp(desiredLevel);
                    newStats.addExperience(entry.getKey().getKey(), wantedExp);
                }
                ((ILivingContainer)tomeStack.func_77973_b()).updateLivingStats(tomeStack, newStats);
                inv.func_70299_a(slot, tomeStack);
                inv.save();
                this.fromInventory(trainerStack, inv);
            } else {
                System.out.println("Stats are null");
            }
        } else {
            System.out.println("Something went wrong when setting tomeLevel");
        }
    }

    public void fromInventory(ItemStack trainerStack, InventoryTrainingBracelet inv) {
        ArrayList<ItemStack> invList = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            invList.add(inv.func_70301_a(i));
        }
        this.fromItemStackList(trainerStack, invList);
    }

    public void fromItemStackList(ItemStack trainerStack, List<ItemStack> tomeList) {
        LivingStats stats = new LivingStats();
        int n = 0;
        block0: for (int i = 0; i < tomeList.size(); ++i) {
            LivingStats tomeStats;
            ItemStack tomeStack = tomeList.get(i);
            if (tomeStack.func_190926_b() || !(tomeStack.func_77973_b() instanceof ILivingContainer) || (tomeStats = ((ILivingContainer)tomeStack.func_77973_b()).getLivingStats(tomeStack)) == null) continue;
            for (Map.Entry<LivingUpgrade, Double> entry : tomeStats.getUpgrades().entrySet()) {
                stats.addExperience(entry.getKey().getKey(), entry.getValue());
                if (++n < 16) continue;
                break block0;
            }
        }
        this.updateLivingStats(trainerStack, stats);
    }

    public InventoryTrainingBracelet toInventory(ItemStack trainerStack) {
        InventoryTrainingBracelet inv = new InventoryTrainingBracelet(trainerStack);
        inv.func_174888_l();
        List<ItemStack> stackList = this.toItemStackList(trainerStack);
        for (int i = 0; i < Math.min(stackList.size(), inv.func_70302_i_()); ++i) {
            inv.func_70299_a(i, stackList.get(i));
        }
        return inv;
    }

    public List<ItemStack> toItemStackList(ItemStack trainerStack) {
        ArrayList<ItemStack> tomeList = new ArrayList<ItemStack>();
        LivingStats stats = this.getLivingStats(trainerStack);
        if (stats == null) {
            return tomeList;
        }
        Map<LivingUpgrade, Double> upgradeMap = stats.getUpgrades();
        for (Map.Entry<LivingUpgrade, Double> upgrade : upgradeMap.entrySet()) {
            ItemStack tomeStack = new ItemStack((IItemProvider)BloodMagicItems.LIVING_TOME.get());
            LivingStats tomeStats = new LivingStats();
            tomeStats.addExperience(upgrade.getKey().getKey(), upgrade.getValue());
            ((ILivingContainer)tomeStack.func_77973_b()).updateLivingStats(tomeStack, tomeStats);
            ILivingContainer.setDisplayIfZero(tomeStack, true);
            tomeList.add(tomeStack);
        }
        return tomeList;
    }
}

