/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.common.item.ILivingUpgradePointsProvider;

public class ItemLivingTomeScrap
extends Item
implements ILivingUpgradePointsProvider {
    public ItemLivingTomeScrap() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(BloodMagic.TAB));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.livingtomescrap.desc").func_240699_a_(TextFormatting.GRAY));
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.livingtomescrap.points", new Object[]{this.getTotalUpgradePoints(stack)}).func_240699_a_(TextFormatting.GOLD));
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(group)) {
            return;
        }
        ItemStack stack = new ItemStack((IItemProvider)this);
        this.setTotalUpgradePoints(stack, 256);
        items.add((Object)stack);
    }

    @Override
    public int getAvailableUpgradePoints(ItemStack stack, int drain) {
        return Math.min(this.getTotalUpgradePoints(stack), drain);
    }

    @Override
    public ItemStack getResultingStack(ItemStack stack, int syphonedPoints) {
        if (this.canSyphonPoints(stack, syphonedPoints)) {
            int totalPoints = this.getTotalUpgradePoints(stack);
            int remaining = Math.max(0, totalPoints - syphonedPoints);
            if (remaining > 0) {
                ItemStack newStack = stack.func_77946_l();
                this.setTotalUpgradePoints(newStack, remaining);
                return newStack;
            }
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    @Override
    public int getExcessUpgradePoints(ItemStack stack, int drain) {
        return this.getTotalUpgradePoints(stack) - this.getAvailableUpgradePoints(stack, drain);
    }

    @Override
    public boolean canSyphonPoints(ItemStack stack, int drain) {
        return true;
    }

    public void setTotalUpgradePoints(ItemStack stack, int points) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        CompoundNBT tag = stack.func_77978_p();
        tag.func_74768_a("storedPoints", points);
    }

    @Override
    public int getTotalUpgradePoints(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        CompoundNBT tag = stack.func_77978_p();
        return tag.func_74762_e("storedPoints");
    }

    @Override
    public int getPriority(ItemStack stack) {
        return 0;
    }
}

