/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item;

import java.util.List;
import java.util.Map;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.common.item.ILivingUpgradePointsProvider;
import wayoftime.bloodmagic.core.LivingArmorRegistrar;
import wayoftime.bloodmagic.core.living.ILivingContainer;
import wayoftime.bloodmagic.core.living.LivingStats;
import wayoftime.bloodmagic.core.living.LivingUpgrade;
import wayoftime.bloodmagic.core.living.LivingUtil;

public class ItemLivingTome
extends Item
implements ILivingContainer,
ILivingUpgradePointsProvider {
    public ItemLivingTome() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(BloodMagic.TAB));
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        boolean oneLevel = !player.func_225608_bj_();
        ItemStack held = player.func_184586_b(hand);
        LivingStats armorStats = LivingStats.fromPlayer(player, true);
        if (armorStats == null) {
            return ActionResult.func_226250_c_((Object)held);
        }
        LivingStats tomeStats = this.getLivingStats(held);
        if (tomeStats == null) {
            return ActionResult.func_226250_c_((Object)held);
        }
        Map<LivingUpgrade, Double> upgradeMap = tomeStats.getUpgrades();
        boolean[] flag = new boolean[]{false};
        double[] expUsedArray = new double[upgradeMap.size()];
        int[] i = new int[]{0};
        upgradeMap.forEach((k, v) -> {
            if (oneLevel) {
                double curExp = armorStats.getUpgrades().getOrDefault(k, 0.0);
                double expToNextLevel = (double)k.getNextRequirement((int)curExp) - curExp;
                v = Math.min(expToNextLevel, v);
            }
            Pair<LivingStats, Double> upgraded = LivingUtil.applyExperienceToUpgradeCap(player, k, v);
            flag[0] = flag[0] || (Double)upgraded.getRight() > 0.0;
            expUsedArray[i[0]] = (Double)upgraded.getRight();
            i[0] = i[0] + 1;
        });
        if (flag[0]) {
            Object[] upgradeArray = upgradeMap.entrySet().toArray();
            for (int j = 0; j < expUsedArray.length; ++j) {
                double expUsed = expUsedArray[j];
                if (!(expUsed > 0.0)) continue;
                ResourceLocation key = ((LivingUpgrade)((Object)((Map.Entry)upgradeArray[j]).getKey())).getKey();
                tomeStats.addExperience(key, -expUsed);
                this.updateLivingStats(held, tomeStats);
            }
            if (!player.func_184812_l_()) {
                boolean doShrink = true;
                for (Map.Entry<LivingUpgrade, Double> entry : tomeStats.getUpgrades().entrySet()) {
                    LivingUpgrade upgrade = entry.getKey();
                    int level = upgrade.getLevel(entry.getValue().intValue());
                    if (level <= 0) continue;
                    doShrink = false;
                }
                if (doShrink) {
                    held.func_190918_g(1);
                }
            }
            return ActionResult.func_226248_a_((Object)held);
        }
        return ActionResult.func_226250_c_((Object)held);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(group)) {
            return;
        }
        for (Map.Entry<ResourceLocation, LivingUpgrade> entry : LivingArmorRegistrar.UPGRADE_MAP.entrySet()) {
            LivingUpgrade upgrade = entry.getValue();
            int exp = 0;
            while ((exp = upgrade.getNextRequirement(exp)) != 0) {
                ItemStack tome = new ItemStack((IItemProvider)this);
                this.updateLivingStats(tome, new LivingStats().setMaxPoints(upgrade.getLevelCost(exp)).addExperience(upgrade.getKey(), exp));
                items.add((Object)tome);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        ILivingContainer.appendLivingTooltip(stack, this.getLivingStats(stack), tooltip, false);
    }

    @Override
    public int getAvailableUpgradePoints(ItemStack stack, int drain) {
        return this.getTotalUpgradePoints(stack);
    }

    @Override
    public ItemStack getResultingStack(ItemStack stack, int drain) {
        return ItemStack.field_190927_a;
    }

    @Override
    public int getExcessUpgradePoints(ItemStack stack, int drain) {
        return 0;
    }

    @Override
    public int getTotalUpgradePoints(ItemStack stack) {
        LivingStats tomeStats = this.getLivingStats(stack);
        if (tomeStats == null) {
            return 0;
        }
        int containedPoints = 0;
        Map<LivingUpgrade, Double> upgradeMap = tomeStats.getUpgrades();
        for (Map.Entry<LivingUpgrade, Double> entry : upgradeMap.entrySet()) {
            if (entry.getKey().isNegative()) {
                containedPoints += entry.getValue().intValue();
                continue;
            }
            containedPoints += entry.getKey().getLevelCost(entry.getKey().getLevel(entry.getValue().intValue()));
        }
        return containedPoints;
    }

    @Override
    public boolean canSyphonPoints(ItemStack stack, int drain) {
        return true;
    }

    @Override
    public int getPriority(ItemStack stack) {
        return 1;
    }
}

