/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.common.block.BlockDemonCrystal;
import wayoftime.bloodmagic.tile.TileDemonCrystal;

public class ItemCrystalCatalyst
extends Item {
    public final EnumDemonWillType type;
    public final double injectedWill;
    public final double speedModifier;
    public final double conversionRate;
    public final double maxInjectedWill;

    public ItemCrystalCatalyst(EnumDemonWillType type, double injectedWill, double speedModifier, double conversionRate, double maxInjectedWill) {
        super(new Item.Properties().func_200916_a(BloodMagic.TAB));
        this.type = type;
        this.injectedWill = injectedWill;
        this.speedModifier = speedModifier;
        this.conversionRate = conversionRate;
        this.maxInjectedWill = maxInjectedWill;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.crystalCatalyst").func_240699_a_(TextFormatting.GRAY));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack stack = context.func_195996_i();
        BlockPos pos = context.func_195995_a();
        World world = context.func_195991_k();
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileDemonCrystal) {
            TileDemonCrystal crystalTile;
            if (!world.field_72995_K && this.applyCatalyst(crystalTile = (TileDemonCrystal)tile)) {
                ServerWorld server = (ServerWorld)world;
                ItemStack crystalStack = BlockDemonCrystal.getItemStackDropped(this.type, 1);
                ItemParticleData particleData = new ItemParticleData(ParticleTypes.field_197591_B, crystalStack);
                for (int i = 0; i < 8; ++i) {
                    server.func_195598_a((IParticleData)particleData, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.6, (double)pos.func_177952_p() + 0.5, 1, 0.2, 0.2, 0.2, 0.03);
                }
                stack.func_190920_e(stack.func_190916_E() - 1);
                world.func_184133_a(null, pos, SoundEvents.field_191241_J, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public boolean applyCatalyst(TileDemonCrystal crystalTile) {
        if (this.type.equals((Object)crystalTile.getWillType()) && crystalTile.getInjectedWill() + this.injectedWill <= this.maxInjectedWill) {
            crystalTile.applyCatalyst(this.injectedWill, this.speedModifier, this.conversionRate);
            return true;
        }
        return false;
    }
}

