/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.block;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import wayoftime.bloodmagic.tile.TileMimic;

public class BlockMimic
extends Block {
    private static final VoxelShape SHAPE = VoxelShapes.func_197873_a((double)0.01, (double)0.0, (double)0.01, (double)0.99, (double)1.0, (double)0.99);

    public BlockMimic(AbstractBlock.Properties prop) {
        super(prop);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        BlockState mimic;
        TileEntity te = reader.func_175625_s(pos);
        if (te instanceof TileMimic && (mimic = ((TileMimic)te).getMimic()) != null && !(mimic.func_177230_c() instanceof BlockMimic)) {
            return mimic.func_215700_a(reader, pos, context);
        }
        return SHAPE;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileMimic();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult trace) {
        TileMimic mimic = (TileMimic)world.func_175625_s(pos);
        return mimic != null && mimic.onBlockActivated(world, pos, state, player, hand, player.func_184586_b(hand), trace.func_216354_b()) ? ActionResultType.SUCCESS : ActionResultType.FAIL;
    }

    public void func_176206_d(IWorld world, BlockPos blockPos, BlockState blockState) {
        TileMimic altar = (TileMimic)world.func_175625_s(blockPos);
        if (altar != null) {
            altar.dropItems();
        }
        super.func_176206_d(world, blockPos, blockState);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.func_203425_a(newState.func_177230_c())) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof TileMimic) {
                ((TileMimic)tileentity).dropItems();
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }
}

