/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.client.render.block;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.fluids.FluidStack;
import wayoftime.bloodmagic.client.render.BloodMagicRenderer;
import wayoftime.bloodmagic.client.render.RenderResizableCuboid;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.tile.TileAltar;

public class RenderAltar
extends TileEntityRenderer<TileAltar> {
    private static final float MIN_HEIGHT = 0.499f;
    private static final float MAX_HEIGHT = 0.745f;

    public RenderAltar(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(TileAltar tileAltar, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        ItemStack inputStack = tileAltar.func_70301_a(0);
        float level = (float)tileAltar.getCurrentBlood() / (float)tileAltar.getCapacity();
        this.renderItem(inputStack, tileAltar, matrixStack, buffer, combinedLightIn, combinedOverlayIn);
        this.renderFluid(level, matrixStack, buffer, combinedLightIn, combinedOverlayIn);
    }

    private void renderFluid(float fluidLevel, MatrixStack matrixStack, IRenderTypeBuffer renderer, int combinedLightIn, int combinedOverlayIn) {
        Fluid fluid = (Fluid)BloodMagicBlocks.LIFE_ESSENCE_FLUID.get();
        FluidStack fluidStack = new FluidStack(fluid, 1000);
        FluidRenderData data = new FluidRenderData(fluidStack);
        matrixStack.func_227860_a_();
        BloodMagicRenderer.Model3D model = this.getFluidModel(fluidLevel, data);
        IVertexBuilder buffer = renderer.getBuffer(Atlases.func_228785_j_());
        RenderResizableCuboid.INSTANCE.renderCube(model, matrixStack, buffer, data.getColorARGB(1.0f), combinedLightIn, combinedOverlayIn);
        matrixStack.func_227865_b_();
    }

    private void renderItem(ItemStack stack, TileAltar tileAltar, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        matrixStack.func_227860_a_();
        Minecraft mc = Minecraft.func_71410_x();
        ItemRenderer itemRenderer = mc.func_175599_af();
        if (!stack.func_190926_b()) {
            matrixStack.func_227861_a_(0.5, 1.0, 0.5);
            matrixStack.func_227860_a_();
            float rotation = (float)(720.0 * (double)(System.currentTimeMillis() & 0x3FFFL) / 16383.0);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotation));
            matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
            RenderHelper.func_227780_a_();
            IBakedModel ibakedmodel = itemRenderer.func_184393_a(stack, tileAltar.func_145831_w(), (LivingEntity)null);
            itemRenderer.func_229111_a_(stack, ItemCameraTransforms.TransformType.FIXED, true, matrixStack, buffer, combinedLightIn, combinedOverlayIn, ibakedmodel);
            RenderHelper.func_74518_a();
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227865_b_();
    }

    private BloodMagicRenderer.Model3D getFluidModel(float fluidLevel, FluidRenderData data) {
        BloodMagicRenderer.Model3D model = new BloodMagicRenderer.Model3D();
        model.setTexture(data.getTexture());
        model.minX = 0.1;
        model.minY = 0.499f;
        model.minZ = 0.1;
        model.maxX = 0.9;
        model.maxY = 0.24599999f * fluidLevel + 0.499f;
        model.maxZ = 0.9;
        return model;
    }

    public class FluidRenderData {
        public BlockPos location;
        public int height;
        public int length;
        public int width;
        public final FluidStack fluidType;

        public FluidRenderData(FluidStack fluidType) {
            this.fluidType = fluidType;
        }

        public TextureAtlasSprite getTexture() {
            return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(this.fluidType.getFluid().getAttributes().getStillTexture());
        }

        public boolean isGaseous() {
            return this.fluidType.getFluid().getAttributes().isGaseous(this.fluidType);
        }

        public int getColorARGB(float scale) {
            return this.fluidType.getFluid().getAttributes().getColor(this.fluidType);
        }

        public int calculateGlowLight(int light) {
            return light;
        }

        public int hashCode() {
            int code = super.hashCode();
            code = 31 * code + this.fluidType.getFluid().getRegistryName().hashCode();
            if (this.fluidType.hasTag()) {
                code = 31 * code + this.fluidType.getTag().hashCode();
            }
            return code;
        }

        public boolean equals(Object data) {
            return super.equals(data) && data instanceof FluidRenderData && this.fluidType.isFluidEqual(((FluidRenderData)data).fluidType);
        }
    }
}

