/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.client.hud.element;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import wayoftime.bloodmagic.client.Sprite;
import wayoftime.bloodmagic.client.hud.element.HUDElement;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.common.item.sigil.ItemSigilHolding;

public class ElementHolding
extends HUDElement {
    private static final Sprite HOLDING_BAR = new Sprite(new ResourceLocation("bloodmagic", "textures/gui/widgets.png"), 0, 0, 102, 22);
    private static final Sprite SELECTED_OVERLAY = new Sprite(new ResourceLocation("bloodmagic", "textures/gui/widgets.png"), 0, 22, 24, 24);

    public ElementHolding() {
        super(HOLDING_BAR.getTextureWidth(), HOLDING_BAR.getTextureHeight());
    }

    @Override
    public void draw(MatrixStack matrixStack, float partialTicks, int drawX, int drawY) {
        matrixStack.func_227860_a_();
        HOLDING_BAR.draw(matrixStack, drawX, drawY);
        Minecraft minecraft = Minecraft.func_71410_x();
        ItemStack sigilHolding = minecraft.field_71439_g.func_184614_ca();
        if (sigilHolding.func_77973_b() != BloodMagicItems.HOLDING_SIGIL.get()) {
            sigilHolding = minecraft.field_71439_g.func_184592_cb();
        }
        if (sigilHolding.func_77973_b() != BloodMagicItems.HOLDING_SIGIL.get()) {
            return;
        }
        int currentSlot = ItemSigilHolding.getCurrentItemOrdinal(sigilHolding);
        SELECTED_OVERLAY.draw(matrixStack, drawX - 1 + currentSlot * 20, drawY - 1);
        RenderHelper.func_227780_a_();
        NonNullList<ItemStack> inventory = ItemSigilHolding.getInternalInventory(sigilHolding);
        int xOffset = 0;
        for (ItemStack stack : inventory) {
            this.renderHotbarItem(matrixStack, drawX + 3 + xOffset, drawY + 3, partialTicks, (PlayerEntity)minecraft.field_71439_g, stack);
            xOffset += 20;
        }
        matrixStack.func_227865_b_();
    }

    @Override
    public boolean shouldRender(Minecraft minecraft) {
        ItemStack sigilHolding = minecraft.field_71439_g.func_184614_ca();
        if (sigilHolding.func_77973_b() != BloodMagicItems.HOLDING_SIGIL.get()) {
            sigilHolding = minecraft.field_71439_g.func_184592_cb();
        }
        return sigilHolding.func_77973_b() == BloodMagicItems.HOLDING_SIGIL.get();
    }

    protected void renderHotbarItem(MatrixStack matrixStack, int x, int y, float partialTicks, PlayerEntity player, ItemStack stack) {
        if (!stack.func_190926_b()) {
            float animation = (float)stack.func_190921_D() - partialTicks;
            if (animation > 0.0f) {
                matrixStack.func_227860_a_();
                float f1 = 1.0f + animation / 5.0f;
                matrixStack.func_227861_a_((double)(x + 8), (double)(y + 12), 0.0);
                matrixStack.func_227862_a_(1.0f / f1, (f1 + 1.0f) / 2.0f, 1.0f);
                matrixStack.func_227861_a_((double)(-(x + 8)), (double)(-(y + 12)), 0.0);
            }
            Minecraft.func_71410_x().func_175599_af().func_184391_a((LivingEntity)player, stack, x, y);
            if (animation > 0.0f) {
                matrixStack.func_227865_b_();
            }
            Minecraft.func_71410_x().func_175599_af().func_175030_a(Minecraft.func_71410_x().field_71466_p, stack, x, y);
        }
    }
}

