/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.layer;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.common.util.biome.BiomeUtil;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraft.world.gen.layer.LayerUtil;
import net.minecraft.world.gen.layer.traits.ICastleTransformer;

public enum BOPBiomeEdgeLayer implements ICastleTransformer
{
    INSTANCE;

    private static final int DESERT;
    private static final int MOUNTAINS;
    private static final int WOODED_MOUNTAINS;
    private static final int SNOWY_TUNDRA;
    private static final int JUNGLE;
    private static final int JUNGLE_HILLS;
    private static final int JUNGLE_EDGE;
    private static final int BADLANDS;
    private static final int BADLANDS_PLATEAU;
    private static final int WOODED_BADLANDS_PLATEAU;
    private static final int PLAINS;
    private static final int GIANT_TREE_TAIGA;
    private static final int MOUNTAIN_EDGE;
    private static final int SWAMP;
    private static final int TAIGA;
    private static final int SNOWY_TAIGA;

    public int func_202748_a(INoiseRandom context, int northBiomeId, int eastBiomeId, int southBiomeId, int westBiomeId, int biomeId) {
        int[] outBiomeId = new int[1];
        if (this.replaceBiomeEdge(outBiomeId, northBiomeId, eastBiomeId, southBiomeId, westBiomeId, biomeId, BOPBiomes.alps, BOPBiomes.alps_foothills)) {
            return outBiomeId[0];
        }
        if (this.replaceBiomeEdge(outBiomeId, northBiomeId, eastBiomeId, southBiomeId, westBiomeId, biomeId, BOPBiomes.redwood_forest, BOPBiomes.redwood_forest_edge)) {
            return outBiomeId[0];
        }
        if (this.replaceBiomeEdge(outBiomeId, northBiomeId, eastBiomeId, southBiomeId, westBiomeId, biomeId, BOPBiomes.redwood_hills, BOPBiomes.redwood_forest_edge)) {
            return outBiomeId[0];
        }
        if (this.replaceBiomeEdge(outBiomeId, northBiomeId, eastBiomeId, southBiomeId, westBiomeId, biomeId, BOPBiomes.volcano, BOPBiomes.volcanic_plains)) {
            return outBiomeId[0];
        }
        if (this.replaceBiomeEdge(outBiomeId, northBiomeId, eastBiomeId, southBiomeId, westBiomeId, biomeId, WOODED_BADLANDS_PLATEAU, BADLANDS)) {
            return outBiomeId[0];
        }
        if (this.replaceBiomeEdge(outBiomeId, northBiomeId, eastBiomeId, southBiomeId, westBiomeId, biomeId, BADLANDS_PLATEAU, BADLANDS)) {
            return outBiomeId[0];
        }
        if (this.replaceBiomeEdge(outBiomeId, northBiomeId, eastBiomeId, southBiomeId, westBiomeId, biomeId, GIANT_TREE_TAIGA, TAIGA)) {
            return outBiomeId[0];
        }
        if (biomeId == DESERT && (northBiomeId == SNOWY_TUNDRA || eastBiomeId == SNOWY_TUNDRA || westBiomeId == SNOWY_TUNDRA || southBiomeId == SNOWY_TUNDRA)) {
            return WOODED_MOUNTAINS;
        }
        if (biomeId == SWAMP) {
            if (northBiomeId == DESERT || eastBiomeId == DESERT || westBiomeId == DESERT || southBiomeId == DESERT || northBiomeId == SNOWY_TAIGA || eastBiomeId == SNOWY_TAIGA || westBiomeId == SNOWY_TAIGA || southBiomeId == SNOWY_TAIGA || northBiomeId == SNOWY_TUNDRA || eastBiomeId == SNOWY_TUNDRA || westBiomeId == SNOWY_TUNDRA || southBiomeId == SNOWY_TUNDRA) {
                return PLAINS;
            }
            if (northBiomeId == JUNGLE || southBiomeId == JUNGLE || eastBiomeId == JUNGLE || westBiomeId == JUNGLE || northBiomeId == JUNGLE_HILLS || southBiomeId == JUNGLE_HILLS || eastBiomeId == JUNGLE_HILLS || westBiomeId == JUNGLE_HILLS) {
                return JUNGLE_EDGE;
            }
        }
        return biomeId;
    }

    private boolean replaceBiomeEdge(int[] outId, int northBiomeId, int eastBiomeId, int southBiomeId, int westBiomeId, int biomeId, RegistryKey<Biome> fromBiome, RegistryKey<Biome> toBiome) {
        return BiomeUtil.exists(fromBiome) && BiomeUtil.exists(toBiome) && this.replaceBiomeEdge(outId, northBiomeId, eastBiomeId, southBiomeId, westBiomeId, biomeId, BiomeUtil.getBiomeId(fromBiome), BiomeUtil.getBiomeId(toBiome));
    }

    private boolean replaceBiomeEdge(int[] outId, int northBiomeId, int eastBiomeId, int southBiomeId, int westBiomeId, int biomeId, int fromBiome, int toBiome) {
        if (biomeId != fromBiome) {
            return false;
        }
        outId[0] = LayerUtil.func_202826_a((int)northBiomeId, (int)fromBiome) && LayerUtil.func_202826_a((int)eastBiomeId, (int)fromBiome) && LayerUtil.func_202826_a((int)westBiomeId, (int)fromBiome) && LayerUtil.func_202826_a((int)southBiomeId, (int)fromBiome) ? biomeId : toBiome;
        return true;
    }

    static {
        DESERT = BiomeUtil.getBiomeId((RegistryKey<Biome>)Biomes.field_76769_d);
        MOUNTAINS = BiomeUtil.getBiomeId((RegistryKey<Biome>)Biomes.field_76770_e);
        WOODED_MOUNTAINS = BiomeUtil.getBiomeId((RegistryKey<Biome>)Biomes.field_150580_W);
        SNOWY_TUNDRA = BiomeUtil.getBiomeId((RegistryKey<Biome>)Biomes.field_76774_n);
        JUNGLE = BiomeUtil.getBiomeId((RegistryKey<Biome>)Biomes.field_76782_w);
        JUNGLE_HILLS = BiomeUtil.getBiomeId((RegistryKey<Biome>)Biomes.field_76792_x);
        JUNGLE_EDGE = BiomeUtil.getBiomeId((RegistryKey<Biome>)Biomes.field_150574_L);
        BADLANDS = BiomeUtil.getBiomeId((RegistryKey<Biome>)Biomes.field_150589_Z);
        BADLANDS_PLATEAU = BiomeUtil.getBiomeId((RegistryKey<Biome>)Biomes.field_150608_ab);
        WOODED_BADLANDS_PLATEAU = BiomeUtil.getBiomeId((RegistryKey<Biome>)Biomes.field_150607_aa);
        PLAINS = BiomeUtil.getBiomeId((RegistryKey<Biome>)Biomes.field_76772_c);
        GIANT_TREE_TAIGA = BiomeUtil.getBiomeId((RegistryKey<Biome>)Biomes.field_150578_U);
        MOUNTAIN_EDGE = BiomeUtil.getBiomeId((RegistryKey<Biome>)Biomes.field_76783_v);
        SWAMP = BiomeUtil.getBiomeId((RegistryKey<Biome>)Biomes.field_76780_h);
        TAIGA = BiomeUtil.getBiomeId((RegistryKey<Biome>)Biomes.field_76768_g);
        SNOWY_TAIGA = BiomeUtil.getBiomeId((RegistryKey<Biome>)Biomes.field_150584_S);
    }
}

