/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.entity.item;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.item.BOPItems;
import biomesoplenty.init.ModEntities;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class BoatEntityBOP
extends BoatEntity {
    public BoatEntityBOP(EntityType<? extends BoatEntityBOP> type, World world) {
        super(type, world);
    }

    public BoatEntityBOP(World world, double x, double y, double z) {
        super(ModEntities.boat, world);
        this.func_70107_b(x, y, z);
        this.func_213317_d(Vector3d.field_186680_a);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    public BoatEntityBOP(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this(world, spawnEntity.getPosX(), spawnEntity.getPosY(), spawnEntity.getPosZ());
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void func_213281_b(CompoundNBT nbt) {
        nbt.func_74778_a("model", this.getModel().getName());
    }

    protected void func_70037_a(CompoundNBT nbt) {
        if (nbt.func_150297_b("model", 8)) {
            this.field_70180_af.func_187227_b(field_184466_d, (Object)BoatModel.byName(nbt.func_74779_i("model")).ordinal());
        }
    }

    protected void func_184231_a(double y, boolean onGround, BlockState state, BlockPos pos) {
        this.field_184473_aH = this.func_213322_ci().field_72448_b;
        if (!this.func_184218_aH()) {
            if (onGround) {
                if (this.field_70143_R > 3.0f) {
                    if (this.field_184469_aF != BoatEntity.Status.ON_LAND) {
                        this.field_70143_R = 0.0f;
                        return;
                    }
                    this.func_225503_b_(this.field_70143_R, 1.0f);
                    if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
                        this.func_70106_y();
                        if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                            for (int i = 0; i < 3; ++i) {
                                this.func_199703_a((IItemProvider)this.getModel().getPlanks());
                            }
                            for (int j = 0; j < 2; ++j) {
                                this.func_199703_a((IItemProvider)Items.field_151055_y);
                            }
                        }
                    }
                }
                this.field_70143_R = 0.0f;
            } else if (!this.field_70170_p.func_204610_c(this.func_233580_cy_().func_177977_b()).func_206884_a((ITag)FluidTags.field_206959_a) && y < 0.0) {
                this.field_70143_R = (float)((double)this.field_70143_R - y);
            }
        }
    }

    public Item func_184455_j() {
        switch (BoatModel.byId((Integer)this.field_70180_af.func_187225_a(field_184466_d))) {
            case FIR: {
                return BOPItems.fir_boat;
            }
            case REDWOOD: {
                return BOPItems.redwood_boat;
            }
            case CHERRY: {
                return BOPItems.cherry_boat;
            }
            case MAHOGANY: {
                return BOPItems.mahogany_boat;
            }
            case JACARANDA: {
                return BOPItems.jacaranda_boat;
            }
            case PALM: {
                return BOPItems.palm_boat;
            }
            case WILLOW: {
                return BOPItems.willow_boat;
            }
            case DEAD: {
                return BOPItems.dead_boat;
            }
            case MAGIC: {
                return BOPItems.magic_boat;
            }
            case UMBRAN: {
                return BOPItems.umbran_boat;
            }
            case HELLBARK: {
                return BOPItems.hellbark_boat;
            }
        }
        return Items.field_151124_az;
    }

    public BoatEntityBOP withModel(BoatModel type) {
        this.field_70180_af.func_187227_b(field_184466_d, (Object)type.ordinal());
        return this;
    }

    public BoatModel getModel() {
        return BoatModel.byId((Integer)this.field_70180_af.func_187225_a(field_184466_d));
    }

    @Deprecated
    public void func_184458_a(BoatEntity.Type vanillaType) {
    }

    @Deprecated
    public BoatEntity.Type func_184453_r() {
        return BoatEntity.Type.OAK;
    }

    public static enum BoatModel {
        FIR("fir", () -> BOPBlocks.fir_planks),
        REDWOOD("redwood", () -> BOPBlocks.redwood_planks),
        CHERRY("cherry", () -> BOPBlocks.cherry_planks),
        MAHOGANY("mahogany", () -> BOPBlocks.mahogany_planks),
        JACARANDA("jacaranda", () -> BOPBlocks.jacaranda_planks),
        PALM("palm", () -> BOPBlocks.palm_planks),
        WILLOW("willow", () -> BOPBlocks.willow_planks),
        DEAD("dead", () -> BOPBlocks.dead_planks),
        MAGIC("magic", () -> BOPBlocks.magic_planks),
        UMBRAN("umbran", () -> BOPBlocks.umbran_planks),
        HELLBARK("hellbark", () -> BOPBlocks.hellbark_planks);

        private final String name;
        private final Supplier<Block> supplierPlanks;

        private BoatModel(String name, Supplier<Block> supplierPlanks) {
            this.name = name;
            this.supplierPlanks = supplierPlanks;
        }

        public String getName() {
            return this.name;
        }

        public Block getPlanks() {
            return this.supplierPlanks.get();
        }

        public String toString() {
            return this.name;
        }

        public static BoatModel byId(int id) {
            BoatModel[] type = BoatModel.values();
            return type[id < 0 || id >= type.length ? 0 : id];
        }

        public static BoatModel byName(String aName) {
            BoatModel[] type = BoatModel.values();
            return Arrays.stream(type).filter(t -> t.getName().equals(aName)).findFirst().orElse(type[0]);
        }
    }
}

