/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.client;

import biomesoplenty.core.BiomesOPlenty;
import com.google.common.base.Joiner;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourcePack;
import net.minecraft.resources.ResourcePackFileNotFoundException;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.forgespi.locating.IModFile;

@OnlyIn(value=Dist.CLIENT)
public class BOPClassicPack
extends ResourcePack {
    private final ModFile modFile;
    private static final String subDir = "classic/";

    public BOPClassicPack(ModFile modFile) {
        super(modFile.getFilePath().toFile());
        this.modFile = modFile;
    }

    public Set<String> func_195759_a(ResourcePackType type) {
        try {
            Path root = this.modFile.getLocator().findPath((IModFile)this.modFile, new String[]{subDir + type.func_198956_a()}).toAbsolutePath();
            return Files.walk(root, 1, new FileVisitOption[0]).map(path -> root.relativize(path.toAbsolutePath())).filter(path -> path.getNameCount() > 0).map(p -> p.toString().replaceAll("/$", "")).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
        }
        catch (Throwable t) {
            BiomesOPlenty.logger.error("BOPClassicPack failed to collect resource namespaces!", t);
            return Collections.emptySet();
        }
    }

    protected InputStream func_195766_a(String location) throws IOException {
        Path path = this.modFile.getLocator().findPath((IModFile)this.modFile, new String[]{subDir + location});
        if (!Files.exists(path, new LinkOption[0])) {
            BiomesOPlenty.logger.error("File does not exist!");
            throw new ResourcePackFileNotFoundException(path.toFile(), location);
        }
        return Files.newInputStream(path, StandardOpenOption.READ);
    }

    protected boolean func_195768_c(String resourcePath) {
        return Files.exists(this.modFile.getLocator().findPath((IModFile)this.modFile, new String[]{subDir + resourcePath}), new LinkOption[0]);
    }

    public Collection<ResourceLocation> func_225637_a_(ResourcePackType type, String namespaceIn, String pathIn, int maxDepthIn, Predicate<String> filterIn) {
        try {
            Path root = this.modFile.getLocator().findPath((IModFile)this.modFile, new String[]{subDir + type.func_198956_a()}).toAbsolutePath();
            Path inputPath = root.getFileSystem().getPath(pathIn, new String[0]);
            return Files.walk(root, new FileVisitOption[0]).map(path -> root.relativize(path.toAbsolutePath())).filter(path -> path.getNameCount() > 1 && path.getNameCount() - 1 <= maxDepthIn).filter(path -> !path.toString().endsWith(".mcmeta")).filter(path -> path.subpath(1, path.getNameCount()).startsWith(inputPath)).filter(path -> filterIn.test(path.getFileName().toString())).map(path -> new ResourceLocation(path.getName(0).toString(), Joiner.on((char)'/').join((Iterable)path.subpath(1, Math.min(maxDepthIn, path.getNameCount()))))).collect(Collectors.toList());
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    public void close() {
    }

    public String func_195762_a() {
        return "BOP Programmer Art";
    }

    @Nullable
    public <T> T func_195760_a(IMetadataSectionSerializer<T> serializer) throws IOException {
        Object resourceMetaData;
        try (InputStream inputStream = this.func_195766_a("pack.mcmeta");){
            resourceMetaData = BOPClassicPack.func_195770_a(serializer, (InputStream)inputStream);
        }
        return (T)resourceMetaData;
    }
}

