/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.turbine;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.roguelogix.biggerreactors.Config;
import net.roguelogix.biggerreactors.multiblocks.turbine.blocks.TurbineBaseBlock;
import net.roguelogix.biggerreactors.multiblocks.turbine.blocks.TurbineRotorBearing;
import net.roguelogix.biggerreactors.multiblocks.turbine.blocks.TurbineRotorBlade;
import net.roguelogix.biggerreactors.multiblocks.turbine.blocks.TurbineRotorShaft;
import net.roguelogix.biggerreactors.multiblocks.turbine.simulation.ITurbineSimulation;
import net.roguelogix.biggerreactors.multiblocks.turbine.simulation.classic.ClassicTurbineSimulation;
import net.roguelogix.biggerreactors.multiblocks.turbine.simulation.modern.ModernTurbineSimulation;
import net.roguelogix.biggerreactors.multiblocks.turbine.state.TurbineActivity;
import net.roguelogix.biggerreactors.multiblocks.turbine.state.TurbineState;
import net.roguelogix.biggerreactors.multiblocks.turbine.state.VentState;
import net.roguelogix.biggerreactors.multiblocks.turbine.tiles.TurbineBaseTile;
import net.roguelogix.biggerreactors.multiblocks.turbine.tiles.TurbineCoolantPortTile;
import net.roguelogix.biggerreactors.multiblocks.turbine.tiles.TurbineGlassTile;
import net.roguelogix.biggerreactors.multiblocks.turbine.tiles.TurbinePowerTapTile;
import net.roguelogix.biggerreactors.multiblocks.turbine.tiles.TurbineRotorBearingTile;
import net.roguelogix.biggerreactors.multiblocks.turbine.tiles.TurbineRotorBladeTile;
import net.roguelogix.biggerreactors.multiblocks.turbine.tiles.TurbineRotorShaftTile;
import net.roguelogix.biggerreactors.multiblocks.turbine.tiles.TurbineTerminalTile;
import net.roguelogix.biggerreactors.registries.TurbineCoilRegistry;
import net.roguelogix.phosphophyllite.Phosphophyllite;
import net.roguelogix.phosphophyllite.multiblock.generic.ValidationError;
import net.roguelogix.phosphophyllite.multiblock.rectangular.RectangularMultiblockController;
import net.roguelogix.phosphophyllite.repack.org.joml.Matrix4f;
import net.roguelogix.phosphophyllite.repack.org.joml.Matrix4fc;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3f;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3fc;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3i;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3ic;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector4f;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector4i;
import net.roguelogix.phosphophyllite.util.Util;

public class TurbineMultiblockController
extends RectangularMultiblockController<TurbineMultiblockController, TurbineBaseTile, TurbineBaseBlock> {
    private final Set<TurbineTerminalTile> terminals = new HashSet<TurbineTerminalTile>();
    private final Set<TurbineCoolantPortTile> coolantPorts = new HashSet<TurbineCoolantPortTile>();
    private final Set<TurbineRotorBearingTile> rotorBearings = new HashSet<TurbineRotorBearingTile>();
    private final Set<TurbineRotorShaftTile> rotorShafts = new HashSet<TurbineRotorShaftTile>();
    private final Set<TurbineRotorBladeTile> rotorBlades = new HashSet<TurbineRotorBladeTile>();
    private final Set<TurbinePowerTapTile> powerTaps = new HashSet<TurbinePowerTapTile>();
    private long glassCount = 0L;
    public final ArrayList<Vector4i> rotorConfiguration = new ArrayList();
    public net.minecraft.util.math.vector.Vector3i rotationAxis = new net.minecraft.util.math.vector.Vector3i(0, 0, 0);
    ITurbineSimulation simulation = TurbineMultiblockController.createSimulation();
    boolean updateBlockStates = false;

    public TurbineMultiblockController(World world) {
        super(world, tile -> tile instanceof TurbineBaseTile, block -> block instanceof TurbineBaseBlock);
        this.minSize.set(5, 4, 5);
        this.maxSize.set(Config.Turbine.MaxLength, Config.Turbine.MaxHeight, Config.Turbine.MaxWidth);
        this.exteriorValidator = this.frameValidator = block -> false;
        this.interiorValidator = block -> TurbineCoilRegistry.isBlockAllowed(block) || block instanceof AirBlock;
        this.setAssemblyValidator(multiblockController -> {
            TileEntity te;
            Direction marchDirection;
            if (this.rotorBearings.size() != 2) {
                throw new ValidationError("multiblock.error.biggerreactors.turbine.rotor_bearing_count");
            }
            Iterator<TurbineRotorBearingTile> iterator = this.rotorBearings.iterator();
            TurbineRotorBearingTile primaryBearing = iterator.next();
            TurbineRotorBearingTile secondaryBearing = iterator.next();
            BlockPos bearingPosition = primaryBearing.func_174877_v();
            if (bearingPosition.func_177958_n() == this.minCoord().x()) {
                marchDirection = Direction.EAST;
            } else if (bearingPosition.func_177958_n() == this.maxCoord().x()) {
                marchDirection = Direction.WEST;
            } else if (bearingPosition.func_177956_o() == this.minCoord().y()) {
                marchDirection = Direction.UP;
            } else if (bearingPosition.func_177956_o() == this.maxCoord().y()) {
                marchDirection = Direction.DOWN;
            } else if (bearingPosition.func_177952_p() == this.minCoord().z()) {
                marchDirection = Direction.SOUTH;
            } else if (bearingPosition.func_177952_p() == this.maxCoord().z()) {
                marchDirection = Direction.NORTH;
            } else {
                throw new ValidationError("multiblock.error.biggerreactors.turbine.rotor_bearing_position_undefined");
            }
            int marchedBlocks = 0;
            BlockPos currentPos = bearingPosition.func_177972_a(marchDirection);
            while (world.func_180495_p(currentPos).func_177230_c() instanceof TurbineRotorShaft) {
                currentPos = currentPos.func_177972_a(marchDirection);
                ++marchedBlocks;
            }
            if (!(world.func_180495_p(currentPos).func_177230_c() instanceof TurbineRotorBearing)) {
                throw new ValidationError("multiblock.error.biggerreactors.turbine.rotor_shaft_bearing_ends");
            }
            if (this.rotorShafts.size() != marchedBlocks) {
                throw new ValidationError("multiblock.error.biggerreactors.turbine.rotor_shaft_off_shaft");
            }
            marchedBlocks = 0;
            for (TurbineRotorShaftTile rotorShaft : this.rotorShafts) {
                for (Direction value : Direction.values()) {
                    Block block2;
                    BlockPos pos2 = rotorShaft.func_174877_v();
                    while ((block2 = world.func_180495_p(pos2 = pos2.func_177972_a(value)).func_177230_c()) instanceof TurbineRotorBlade) {
                        ++marchedBlocks;
                    }
                }
            }
            if (marchedBlocks != this.rotorBlades.size()) {
                throw new ValidationError("multiblock.error.biggerreactors.turbine.rotor_blade_off_blade");
            }
            boolean inCoil = false;
            boolean inBlades = false;
            boolean switched = false;
            int[] validCoilBlocks = new int[]{0};
            currentPos = bearingPosition;
            Vector3i sliceMin = new Vector3i(this.minCoord()).add(1, 1, 1);
            Vector3i sliceMax = new Vector3i(this.maxCoord()).sub(1, 1, 1);
            int axisComponent = marchDirection.func_176740_k().func_196052_a(0, 1, 2);
            sliceMin.setComponent(axisComponent, marchDirection.func_176743_c().func_179524_a() < 0 ? sliceMax.get(axisComponent) : sliceMin.get(axisComponent));
            sliceMax.setComponent(axisComponent, sliceMin.get(axisComponent));
            boolean[] flags = new boolean[2];
            while ((te = world.func_175625_s(currentPos = currentPos.func_177972_a(marchDirection))) instanceof TurbineRotorShaftTile) {
                flags[0] = false;
                flags[1] = false;
                Util.chunkCachedBlockStateIteration((Vector3ic)sliceMin, (Vector3ic)sliceMax, (World)world, (state, pos) -> {
                    Block block = state.func_177230_c();
                    if (block instanceof AirBlock || block instanceof TurbineRotorShaft) {
                        return;
                    }
                    if (block instanceof TurbineRotorBlade) {
                        flags[0] = true;
                        return;
                    }
                    flags[1] = true;
                    validCoilBlocks[0] = validCoilBlocks[0] + 1;
                });
                if (flags[0] && flags[1]) {
                    throw new ValidationError("multiblock.error.biggerreactors.turbine.mixed_blades_and_coil");
                }
                if (flags[1]) {
                    if (inBlades) {
                        if (switched) {
                            throw new ValidationError("multiblock.error.biggerreactors.turbine.multiple_groups");
                        }
                        inBlades = false;
                        switched = true;
                        primaryBearing.isRenderBearing = true;
                        secondaryBearing.isRenderBearing = false;
                    }
                    inCoil = true;
                }
                if (flags[0]) {
                    if (inCoil) {
                        if (switched) {
                            throw new ValidationError("multiblock.error.biggerreactors.turbine.multiple_groups");
                        }
                        inCoil = false;
                        switched = true;
                        primaryBearing.isRenderBearing = false;
                        secondaryBearing.isRenderBearing = true;
                    }
                    inBlades = true;
                }
                sliceMin.setComponent(axisComponent, sliceMin.get(axisComponent) + marchDirection.func_176743_c().func_179524_a());
                sliceMax.setComponent(axisComponent, sliceMax.get(axisComponent) + marchDirection.func_176743_c().func_179524_a());
            }
            if (!switched) {
                primaryBearing.isRenderBearing = true;
                secondaryBearing.isRenderBearing = false;
            }
            int[] totalCoilBlocks = new int[]{0};
            Util.chunkCachedBlockStateIteration((Vector3ic)new Vector3i(1).add(this.minCoord()), (Vector3ic)new Vector3i(-1).add(this.maxCoord()), (World)world, (block, pos) -> {
                if (block.func_177230_c() instanceof TurbineBaseBlock) {
                    TileEntity te = world.func_175625_s(new BlockPos(pos.x, pos.y, pos.z));
                    if (te instanceof TurbineBaseTile && !((TurbineBaseTile)te).isCurrentController(this)) {
                        throw new ValidationError("multiblock.error.biggerreactors.dangling_internal_part");
                    }
                    return;
                }
                if (block.func_177230_c() instanceof AirBlock) {
                    return;
                }
                totalCoilBlocks[0] = totalCoilBlocks[0] + 1;
            });
            if (totalCoilBlocks[0] != validCoilBlocks[0]) {
                throw new ValidationError("multiblock.error.biggerreactors.turbine.dangling_coil");
            }
            return true;
        });
    }

    protected void onPartPlaced(@Nonnull TurbineBaseTile placed) {
        this.onPartAttached(placed);
    }

    protected void onPartAttached(@Nonnull TurbineBaseTile tile) {
        if (tile instanceof TurbineTerminalTile) {
            this.terminals.add((TurbineTerminalTile)tile);
        }
        if (tile instanceof TurbineCoolantPortTile) {
            this.coolantPorts.add((TurbineCoolantPortTile)tile);
        }
        if (tile instanceof TurbineRotorBearingTile) {
            this.rotorBearings.add((TurbineRotorBearingTile)tile);
        }
        if (tile instanceof TurbineRotorShaftTile) {
            this.rotorShafts.add((TurbineRotorShaftTile)tile);
        }
        if (tile instanceof TurbineRotorBladeTile) {
            this.rotorBlades.add((TurbineRotorBladeTile)tile);
        }
        if (tile instanceof TurbinePowerTapTile) {
            this.powerTaps.add((TurbinePowerTapTile)tile);
        }
        if (tile instanceof TurbineGlassTile) {
            ++this.glassCount;
        }
    }

    protected void onPartBroken(@Nonnull TurbineBaseTile broken) {
        this.onPartDetached(broken);
    }

    protected void onPartDetached(@Nonnull TurbineBaseTile tile) {
        if (tile instanceof TurbineTerminalTile) {
            this.terminals.remove((Object)tile);
        }
        if (tile instanceof TurbineCoolantPortTile) {
            this.coolantPorts.remove((Object)tile);
        }
        if (tile instanceof TurbineRotorBearingTile) {
            this.rotorBearings.remove((Object)tile);
        }
        if (tile instanceof TurbineRotorShaftTile) {
            this.rotorShafts.remove((Object)tile);
        }
        if (tile instanceof TurbineRotorBladeTile) {
            this.rotorBlades.remove((Object)tile);
        }
        if (tile instanceof TurbinePowerTapTile) {
            this.powerTaps.remove((Object)tile);
        }
        if (tile instanceof TurbineGlassTile) {
            --this.glassCount;
        }
    }

    public void updateBlockStates() {
        this.terminals.forEach(terminal -> {
            this.world.func_175656_a(terminal.func_174877_v(), (BlockState)terminal.func_195044_w().func_206870_a(TurbineActivity.TURBINE_STATE_ENUM_PROPERTY, (Comparable)((Object)(this.simulation.active() ? TurbineActivity.ACTIVE : TurbineActivity.INACTIVE))));
            terminal.func_70296_d();
        });
    }

    private static ITurbineSimulation createSimulation() {
        switch (Config.mode) {
            case CLASSIC: {
                return new ClassicTurbineSimulation();
            }
        }
        return new ModernTurbineSimulation();
    }

    public ITurbineSimulation simulation() {
        return this.simulation;
    }

    protected void onAssembled() {
        this.onUnpaused();
        this.simulation.reset();
    }

    protected void onUnpaused() {
        for (TurbinePowerTapTile powerPort : this.powerTaps) {
            powerPort.updateOutputDirection();
        }
        Vector3i internalVolume = new Vector3i().add(this.maxCoord()).sub(this.minCoord()).sub(1, 1, 1);
        BlockPos bearingPos = this.rotorBearings.iterator().next().func_174877_v();
        if (bearingPos.func_177958_n() == this.minCoord().x() || bearingPos.func_177958_n() == this.maxCoord().x()) {
            internalVolume.y ^= internalVolume.x;
            internalVolume.x ^= internalVolume.y;
            internalVolume.y ^= internalVolume.x;
        }
        if (bearingPos.func_177952_p() == this.minCoord().z() || bearingPos.func_177952_p() == this.maxCoord().z()) {
            internalVolume.y ^= internalVolume.z;
            internalVolume.z ^= internalVolume.y;
            internalVolume.y ^= internalVolume.z;
        }
        this.simulation.resize(internalVolume.x, internalVolume.y, internalVolume.z);
        block1: for (TurbineRotorBearingTile rotorBearing : this.rotorBearings) {
            if (!rotorBearing.isRenderBearing) continue;
            for (Direction value : Direction.values()) {
                BlockPos possibleRotorPos = rotorBearing.func_174877_v().func_177972_a(value);
                if (this.world.func_180495_p(possibleRotorPos).func_177230_c() != TurbineRotorShaft.INSTANCE) continue;
                this.rotationAxis = value.func_176730_m();
                this.rotorConfiguration.clear();
                Direction.Axis shaftAxis = value.func_176740_k();
                BlockPos currentRotorPosition = possibleRotorPos;
                while (this.world.func_180495_p(currentRotorPosition).func_177230_c() == TurbineRotorShaft.INSTANCE) {
                    Vector4i shaftSectionConfiguration = new Vector4i();
                    int i = 0;
                    for (Direction bladeDirection : Direction.values()) {
                        if (bladeDirection.func_176740_k() == shaftAxis) continue;
                        int bladeCount = 0;
                        BlockPos currentBladePosition = currentRotorPosition;
                        currentBladePosition = currentBladePosition.func_177972_a(bladeDirection);
                        while (this.world.func_180495_p(currentBladePosition).func_177230_c() == TurbineRotorBlade.INSTANCE) {
                            ++bladeCount;
                            currentBladePosition = currentBladePosition.func_177972_a(bladeDirection);
                        }
                        shaftSectionConfiguration.setComponent(i, bladeCount);
                        ++i;
                    }
                    this.rotorConfiguration.add(shaftSectionConfiguration);
                    currentRotorPosition = currentRotorPosition.func_177972_a(value);
                }
                continue block1;
            }
        }
        this.simulation.setRotorConfiguration(this.rotorConfiguration);
        if (this.glassCount <= 0L) {
            for (TurbineRotorBearingTile rotorBearing : this.rotorBearings) {
                rotorBearing.isRenderBearing = false;
            }
        }
        Matrix4f blockToRotorRelativePos = new Matrix4f();
        if (this.rotationAxis.func_177956_o() == -1) {
            blockToRotorRelativePos.rotate((float)Math.PI, 0.0f, 0.0f, 1.0f);
        } else {
            Vector3f cross = new Vector3f();
            cross.set((float)this.rotationAxis.func_177958_n(), (float)this.rotationAxis.func_177956_o(), (float)this.rotationAxis.func_177952_p());
            cross.cross(0.0f, 1.0f, 0.0f);
            cross.normalize();
            blockToRotorRelativePos.rotate(1.5707964f, (Vector3fc)cross);
        }
        blockToRotorRelativePos.translate((float)(-bearingPos.func_177958_n()), (float)(-bearingPos.func_177956_o()), (float)(-bearingPos.func_177952_p()));
        Vector4f translationPos = new Vector4f();
        Util.chunkCachedBlockStateIteration((Vector3ic)new Vector3i(1).add(this.minCoord()), (Vector3ic)new Vector3i(-1).add(this.maxCoord()), (World)this.world, (blockState, pos) -> {
            Block block = blockState.func_177230_c();
            if (block instanceof AirBlock) {
                return;
            }
            TurbineCoilRegistry.CoilData coilData = TurbineCoilRegistry.getCoilData(block);
            if (coilData != null) {
                translationPos.set((Vector3ic)pos, 1.0f);
                translationPos.mul((Matrix4fc)blockToRotorRelativePos);
                this.simulation.setCoilData((int)translationPos.x, (int)translationPos.z, coilData);
            }
        });
        this.simulation.updateInternalValues();
    }

    public void tick() {
        if (this.updateBlockStates) {
            this.updateBlockStates = false;
            this.updateBlockStates();
        }
        this.simulation.tick();
        long totalPowerRequested = 0L;
        for (TurbinePowerTapTile powerPort : this.powerTaps) {
            totalPowerRequested += powerPort.distributePower(this.simulation.battery().stored(), true);
        }
        long startingPower = this.simulation.battery().stored();
        double distributionMultiplier = Math.min(1.0, (double)startingPower / (double)totalPowerRequested);
        for (TurbinePowerTapTile powerPort : this.powerTaps) {
            long powerRequested = powerPort.distributePower(startingPower, true);
            powerRequested = (long)((double)powerRequested * distributionMultiplier);
            powerRequested = Math.min(this.simulation.battery().stored(), powerRequested);
            this.simulation.battery().extract(powerPort.distributePower(powerRequested, false));
        }
        for (TurbineCoolantPortTile coolantPort : this.coolantPorts) {
            if (this.simulation.fluidTank().liquidAmount() < 0L) break;
            this.simulation.fluidTank().drain((Fluid)Fluids.field_204546_a, null, coolantPort.pushFluid(), false);
        }
        if (Phosphophyllite.tickNumber() % 10L == 0L) {
            for (TurbineRotorBearingTile rotorBearing : this.rotorBearings) {
                this.world.func_184138_a(rotorBearing.func_174877_v(), rotorBearing.func_195044_w(), rotorBearing.func_195044_w(), 0);
            }
        }
        if (Phosphophyllite.tickNumber() % 2L == 0L) {
            this.markDirty();
        }
    }

    public void updateDataPacket(@Nonnull TurbineState turbineState) {
        turbineState.turbineActivity = this.simulation.active() ? TurbineActivity.ACTIVE : TurbineActivity.INACTIVE;
        turbineState.ventState = this.simulation.ventState();
        turbineState.coilStatus = this.simulation.coilEngaged();
        turbineState.flowRate = this.simulation.nominalFlowRate();
        turbineState.efficiencyRate = this.simulation.bladeEfficiencyLastTick();
        turbineState.turbineOutputRate = this.simulation.FEGeneratedLastTick();
        turbineState.currentRPM = this.simulation.RPM();
        turbineState.maxRPM = 2200.0;
        turbineState.intakeStored = this.simulation.fluidTank().vaporAmount();
        turbineState.intakeCapacity = this.simulation.fluidTank().perSideCapacity();
        turbineState.intakeResourceLocation = this.simulation().fluidTank().vaporType().getRegistryName().toString();
        turbineState.exhaustStored = this.simulation.fluidTank().liquidAmount();
        turbineState.exhaustCapacity = this.simulation.fluidTank().perSideCapacity();
        turbineState.exhaustResourceLocation = this.simulation().fluidTank().liquidType().getRegistryName().toString();
        turbineState.energyStored = this.simulation.battery().stored();
        turbineState.energyCapacity = this.simulation.battery().capacity();
    }

    public void runRequest(@Nonnull String requestName, @Nullable Object requestData) {
        switch (requestName) {
            case "setActive": {
                if (!(requestData instanceof Integer)) {
                    return;
                }
                this.setActive(TurbineActivity.fromInt((Integer)requestData) == TurbineActivity.ACTIVE);
                return;
            }
            case "changeFlowRate": {
                if (!(requestData instanceof Long)) {
                    return;
                }
                this.simulation.setNominalFlowRate(this.simulation.nominalFlowRate() + (Long)requestData);
                return;
            }
            case "setCoilEngaged": {
                if (!(requestData instanceof Integer)) {
                    return;
                }
                this.setCoilEngaged((Integer)requestData != 0);
                return;
            }
            case "setVentState": {
                if (!(requestData instanceof Integer)) {
                    return;
                }
                this.setVentState(VentState.fromInt((Integer)requestData));
                return;
            }
        }
    }

    private void setVentState(@Nonnull VentState newVentState) {
        this.simulation.setVentState(newVentState);
    }

    private void setMaxFlowRate(long flowRate) {
        if (flowRate < 0L) {
            flowRate = 0L;
        }
        if (flowRate > this.simulation.flowRateLimit()) {
            flowRate = this.simulation.flowRateLimit();
        }
        this.simulation.setNominalFlowRate(flowRate);
    }

    private void setCoilEngaged(boolean engaged) {
        this.simulation.setCoilEngaged(engaged);
    }

    @Nonnull
    protected CompoundNBT write() {
        return (CompoundNBT)this.simulation().serializeNBT();
    }

    protected void read(@Nonnull CompoundNBT compound) {
        this.simulation.deserializeNBT((INBT)compound);
        this.updateBlockStates = true;
    }

    public void toggleActive() {
        this.setActive(!this.simulation.active());
    }

    public void setActive(boolean active) {
        if (this.simulation.active() != active) {
            this.simulation.setActive(active);
            this.updateBlockStates = true;
        }
    }

    @Nonnull
    public String getDebugInfo() {
        return super.getDebugInfo() + "\n" + this.simulation.debugString() + "";
    }
}

