/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor.tiles;

import com.mojang.datafixers.util.Pair;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkHooks;
import net.roguelogix.biggerreactors.multiblocks.reactor.ReactorMultiblockController;
import net.roguelogix.biggerreactors.multiblocks.reactor.blocks.ReactorControlRod;
import net.roguelogix.biggerreactors.multiblocks.reactor.containers.ReactorControlRodContainer;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorControlRodState;
import net.roguelogix.biggerreactors.multiblocks.reactor.tiles.ReactorBaseTile;
import net.roguelogix.phosphophyllite.gui.client.api.IHasUpdatableState;
import net.roguelogix.phosphophyllite.multiblock.generic.MultiblockBlock;
import net.roguelogix.phosphophyllite.registry.RegisterTileEntity;
import net.roguelogix.phosphophyllite.registry.TileSupplier;

@RegisterTileEntity(name="reactor_control_rod")
public class ReactorControlRodTile
extends ReactorBaseTile
implements INamedContainerProvider,
IHasUpdatableState<ReactorControlRodState> {
    @RegisterTileEntity.Type
    public static TileEntityType<?> TYPE;
    @RegisterTileEntity.Supplier
    public static final TileSupplier SUPPLIER;
    public final ReactorControlRodState reactorControlRodState = new ReactorControlRodState(this);
    private double insertion = 0.0;
    private String name = "";

    public ReactorControlRodTile() {
        super(TYPE);
    }

    @Nonnull
    public ReactorControlRodState getState() {
        this.updateState();
        return this.reactorControlRodState;
    }

    public void updateState() {
        this.reactorControlRodState.name = this.name;
        this.reactorControlRodState.insertionLevel = this.insertion;
    }

    @Nonnull
    public ActionResultType onBlockActivated(@Nonnull PlayerEntity player, @Nonnull Hand handIn) {
        assert (this.field_145850_b != null);
        if (((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((Property)MultiblockBlock.ASSEMBLED)).booleanValue()) {
            if (!this.field_145850_b.field_72995_K) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this, (BlockPos)this.func_174877_v());
            }
            return ActionResultType.SUCCESS;
        }
        return super.onBlockActivated(player, handIn);
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(ReactorControlRod.INSTANCE.func_149739_a());
    }

    @Nullable
    public Container createMenu(int windowId, @Nonnull PlayerInventory playerInventory, @Nonnull PlayerEntity player) {
        return new ReactorControlRodContainer(windowId, this.field_174879_c, player);
    }

    @Override
    public void runRequest(String requestName, Object requestData) {
        if (this.controller == null) {
            return;
        }
        if (requestName.equals("changeInsertionLevel")) {
            Pair dataPair = (Pair)requestData;
            double newLevel = this.insertion + (Double)dataPair.getFirst();
            newLevel = Math.max(0.0, Math.min(100.0, newLevel));
            if (((Boolean)dataPair.getSecond()).booleanValue()) {
                ((ReactorMultiblockController)this.controller).setAllControlRodLevels(newLevel);
            } else {
                this.insertion = newLevel;
                ((ReactorMultiblockController)this.controller).updateControlRodLevels();
            }
        }
        if (requestName.equals("setName")) {
            this.setName((String)requestData);
        }
        super.runRequest(requestName, requestData);
    }

    public void setInsertion(double newLevel) {
        if (Double.isNaN(newLevel)) {
            return;
        }
        if (newLevel < 0.0) {
            newLevel = 0.0;
        }
        if (newLevel > 100.0) {
            newLevel = 100.0;
        }
        this.insertion = newLevel;
    }

    public double getInsertion() {
        return this.insertion;
    }

    public void setName(@Nonnull String name) {
        this.name = name;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    protected CompoundNBT writeNBT() {
        CompoundNBT compound = super.writeNBT();
        compound.func_74780_a("insertion", this.insertion);
        compound.func_74778_a("name", this.name);
        return compound;
    }

    protected void readNBT(@Nonnull CompoundNBT compound) {
        super.readNBT(compound);
        if (compound.func_74764_b("insertion")) {
            this.insertion = compound.func_74769_h("insertion");
        }
        if (compound.func_74764_b("name")) {
            this.name = compound.func_74779_i("name");
        }
    }

    static {
        SUPPLIER = ReactorControlRodTile::new;
    }
}

