/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor.tiles;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;
import net.roguelogix.biggerreactors.Config;
import net.roguelogix.biggerreactors.blocks.materials.BlutoniumBlock;
import net.roguelogix.biggerreactors.items.ingots.BlutoniumIngot;
import net.roguelogix.biggerreactors.items.ingots.CyaniteIngot;
import net.roguelogix.biggerreactors.items.ingots.YelloriumIngot;
import net.roguelogix.biggerreactors.multiblocks.reactor.ReactorMultiblockController;
import net.roguelogix.biggerreactors.multiblocks.reactor.blocks.ReactorAccessPort;
import net.roguelogix.biggerreactors.multiblocks.reactor.containers.ReactorAccessPortContainer;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorAccessPortState;
import net.roguelogix.biggerreactors.multiblocks.reactor.tiles.ReactorBaseTile;
import net.roguelogix.phosphophyllite.gui.client.api.IHasUpdatableState;
import net.roguelogix.phosphophyllite.multiblock.generic.IOnAssemblyTile;
import net.roguelogix.phosphophyllite.multiblock.generic.IOnDisassemblyTile;
import net.roguelogix.phosphophyllite.multiblock.generic.MultiblockBlock;
import net.roguelogix.phosphophyllite.registry.RegisterTileEntity;
import net.roguelogix.phosphophyllite.registry.TileSupplier;
import net.roguelogix.phosphophyllite.util.BlockStates;

@RegisterTileEntity(name="reactor_access_port")
public class ReactorAccessPortTile
extends ReactorBaseTile
implements IItemHandler,
INamedContainerProvider,
IHasUpdatableState<ReactorAccessPortState>,
IOnAssemblyTile,
IOnDisassemblyTile {
    @RegisterTileEntity.Type
    public static TileEntityType<?> TYPE;
    @RegisterTileEntity.Supplier
    public static final TileSupplier SUPPLIER;
    private static final ResourceLocation uraniumIngotTag;
    private static final ResourceLocation uraniumBlockTag;
    private static final ResourceLocation yelloriumIngotTag;
    private static final ResourceLocation yelloriumBlockTag;
    public static final int FUEL_SLOT = 0;
    public static final int WASTE_SLOT = 1;
    public static final int FUEL_INSERT_SLOT = 2;
    private ReactorAccessPort.PortDirection direction = ReactorAccessPort.PortDirection.INLET;
    private boolean fuelMode = false;
    LazyOptional<IItemHandler> itemStackHandler = LazyOptional.of(() -> this);
    Direction itemOutputDirection;
    boolean connected;
    LazyOptional<IItemHandler> itemOutput = LazyOptional.empty();
    public final ReactorAccessPortState reactorAccessPortState = new ReactorAccessPortState(this);

    public ReactorAccessPortTile() {
        super(TYPE);
    }

    public boolean isInlet() {
        return this.direction == ReactorAccessPort.PortDirection.INLET;
    }

    public void setDirection(ReactorAccessPort.PortDirection direction) {
        this.direction = direction;
        this.func_70296_d();
    }

    public void onLoad() {
        super.onLoad();
    }

    protected void readNBT(@Nonnull CompoundNBT compound) {
        if (compound.func_74764_b("direction")) {
            this.direction = ReactorAccessPort.PortDirection.valueOf(compound.func_74779_i("direction"));
        }
        if (compound.func_74764_b("fuelMode")) {
            this.fuelMode = compound.func_74767_n("fuelMode");
        }
    }

    @Nonnull
    protected CompoundNBT writeNBT() {
        CompoundNBT NBT = new CompoundNBT();
        NBT.func_74778_a("direction", String.valueOf((Object)this.direction));
        NBT.func_74757_a("fuelMode", this.fuelMode);
        return NBT;
    }

    @Nonnull
    protected String getDebugInfo() {
        return this.direction.toString();
    }

    public void onAssembly() {
        assert (this.field_145850_b != null);
        this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a(ReactorAccessPort.PortDirection.PORT_DIRECTION_ENUM_PROPERTY, (Comparable)((Object)this.direction)));
        this.itemOutputDirection = (Direction)this.func_195044_w().func_177229_b((Property)BlockStates.FACING);
        this.neighborChanged();
    }

    public void onDisassembly() {
        this.itemOutputDirection = null;
        this.neighborChanged();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemStackHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public int getSlots() {
        return 3;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        if (this.controller == null) {
            return ItemStack.field_190927_a;
        }
        if (slot == 1) {
            long availableIngots = ((ReactorMultiblockController)this.controller).simulation().fuelTank().waste() / Config.Reactor.FuelMBPerIngot;
            return new ItemStack((IItemProvider)CyaniteIngot.INSTANCE, (int)availableIngots);
        }
        if (slot == 0) {
            long availableIngots = ((ReactorMultiblockController)this.controller).simulation().fuelTank().fuel() / Config.Reactor.FuelMBPerIngot;
            return new ItemStack((IItemProvider)YelloriumIngot.INSTANCE, (int)availableIngots);
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        long canAccept;
        long maxAcceptable;
        if (!this.isInlet() || this.controller == null || slot != 2) {
            return stack;
        }
        if ((stack = stack.func_77946_l()).func_77973_b().getTags().contains(uraniumIngotTag) || stack.func_77973_b().getTags().contains(yelloriumIngotTag) || stack.func_77973_b() == BlutoniumIngot.INSTANCE) {
            maxAcceptable = ((ReactorMultiblockController)this.controller).refuel((long)stack.func_190916_E() * Config.Reactor.FuelMBPerIngot, true);
            canAccept = maxAcceptable - maxAcceptable % Config.Reactor.FuelMBPerIngot;
            ((ReactorMultiblockController)this.controller).refuel(canAccept, simulate);
            if (canAccept > 0L) {
                stack.func_190920_e(stack.func_190916_E() - (int)(canAccept / Config.Reactor.FuelMBPerIngot));
            }
        }
        if (stack.func_77973_b().getTags().contains(uraniumBlockTag) || stack.func_77973_b().getTags().contains(yelloriumBlockTag) || stack.func_77973_b() == BlutoniumBlock.INSTANCE.func_199767_j()) {
            maxAcceptable = ((ReactorMultiblockController)this.controller).refuel((long)stack.func_190916_E() * (Config.Reactor.FuelMBPerIngot * 9L), true);
            canAccept = maxAcceptable - maxAcceptable % (Config.Reactor.FuelMBPerIngot * 9L);
            ((ReactorMultiblockController)this.controller).refuel(canAccept, simulate);
            if (canAccept > 0L) {
                stack.func_190920_e(stack.func_190916_E() - (int)(canAccept / (Config.Reactor.FuelMBPerIngot * 9L)));
            }
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.isInlet() || this.controller == null || slot == 2) {
            return ItemStack.field_190927_a;
        }
        if (slot == 1 && !this.fuelMode) {
            long maxExtractable = ((ReactorMultiblockController)this.controller).extractWaste((long)amount * Config.Reactor.FuelMBPerIngot, true);
            long toExtracted = maxExtractable - maxExtractable % Config.Reactor.FuelMBPerIngot;
            long extracted = ((ReactorMultiblockController)this.controller).extractWaste(toExtracted, simulate);
            return new ItemStack((IItemProvider)CyaniteIngot.INSTANCE, (int)Math.min((long)amount, extracted / Config.Reactor.FuelMBPerIngot));
        }
        if (slot == 0 && this.fuelMode) {
            long maxExtractable = ((ReactorMultiblockController)this.controller).extractFuel((long)amount * Config.Reactor.FuelMBPerIngot, true);
            long toExtracted = maxExtractable - maxExtractable % Config.Reactor.FuelMBPerIngot;
            long extracted = ((ReactorMultiblockController)this.controller).extractFuel(toExtracted, simulate);
            return new ItemStack((IItemProvider)YelloriumIngot.INSTANCE, (int)Math.min((long)amount, extracted / Config.Reactor.FuelMBPerIngot));
        }
        return ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        if (this.controller == null) {
            return 0;
        }
        return (int)(((ReactorMultiblockController)this.controller).simulation().fuelTank().capacity() / Config.Reactor.FuelMBPerIngot);
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        if (slot == 2) {
            return stack.func_77973_b().getTags().contains(uraniumIngotTag) || stack.func_77973_b().getTags().contains(yelloriumIngotTag) || stack.func_77973_b() == BlutoniumIngot.INSTANCE || stack.func_77973_b().getTags().contains(uraniumBlockTag) || stack.func_77973_b().getTags().contains(yelloriumBlockTag) || stack.func_77973_b() == BlutoniumBlock.INSTANCE.func_199767_j();
        }
        if (slot == 0) {
            return stack.func_77973_b() == YelloriumIngot.INSTANCE;
        }
        return stack.func_77973_b() == CyaniteIngot.INSTANCE;
    }

    public int pushWaste(int waste, boolean simulated) {
        if (this.itemOutput.isPresent()) {
            ItemStack remainingStack;
            ItemStack toInsertStack;
            IItemHandler output = (IItemHandler)this.itemOutput.orElse((Object)EmptyHandler.INSTANCE);
            waste = (int)((long)waste / Config.Reactor.FuelMBPerIngot);
            int wasteHandled = 0;
            for (int i = 0; i < output.getSlots() && waste != 0; waste -= toInsertStack.func_190916_E() - remainingStack.func_190916_E(), ++i) {
                toInsertStack = new ItemStack((IItemProvider)CyaniteIngot.INSTANCE, waste);
                remainingStack = output.insertItem(i, toInsertStack, simulated);
                wasteHandled += toInsertStack.func_190916_E() - remainingStack.func_190916_E();
            }
            return (int)((long)wasteHandled * Config.Reactor.FuelMBPerIngot);
        }
        return 0;
    }

    public void ejectWaste() {
        ((ReactorMultiblockController)this.controller).extractWaste(this.pushWaste((int)((ReactorMultiblockController)this.controller).extractWaste(Integer.MAX_VALUE, true), false), false);
    }

    public int pushFuel(int fuel, boolean simulated) {
        if (this.itemOutput.isPresent()) {
            ItemStack remainingStack;
            ItemStack toInsertStack;
            IItemHandler output = (IItemHandler)this.itemOutput.orElse((Object)EmptyHandler.INSTANCE);
            fuel = (int)((long)fuel / Config.Reactor.FuelMBPerIngot);
            int fuelHandled = 0;
            for (int i = 0; i < output.getSlots() && fuel != 0; fuel -= toInsertStack.func_190916_E() - remainingStack.func_190916_E(), ++i) {
                toInsertStack = new ItemStack((IItemProvider)YelloriumIngot.INSTANCE, fuel);
                remainingStack = output.insertItem(i, toInsertStack, simulated);
                fuelHandled += toInsertStack.func_190916_E() - remainingStack.func_190916_E();
            }
            return (int)((long)fuelHandled * Config.Reactor.FuelMBPerIngot);
        }
        return 0;
    }

    public void ejectFuel() {
        ((ReactorMultiblockController)this.controller).extractFuel(this.pushFuel((int)((ReactorMultiblockController)this.controller).extractFuel(Integer.MAX_VALUE, true), false), false);
    }

    public void neighborChanged() {
        this.itemOutput = LazyOptional.empty();
        if (this.itemOutputDirection == null) {
            this.connected = false;
            return;
        }
        assert (this.field_145850_b != null);
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.itemOutputDirection));
        if (te == null) {
            this.connected = false;
            return;
        }
        this.itemOutput = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.itemOutputDirection.func_176734_d());
        this.connected = this.itemOutput.isPresent();
    }

    @Nonnull
    public ActionResultType onBlockActivated(@Nonnull PlayerEntity player, @Nonnull Hand handIn) {
        assert (this.field_145850_b != null);
        if (((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((Property)MultiblockBlock.ASSEMBLED)).booleanValue()) {
            if (!this.field_145850_b.field_72995_K) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this, (BlockPos)this.func_174877_v());
            }
            return ActionResultType.SUCCESS;
        }
        return super.onBlockActivated(player, handIn);
    }

    @Override
    public void runRequest(String requestName, Object requestData) {
        if (this.controller == null) {
            return;
        }
        if (requestName.equals("setDirection")) {
            this.setDirection((Integer)requestData != 0 ? ReactorAccessPort.PortDirection.OUTLET : ReactorAccessPort.PortDirection.INLET);
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a(ReactorAccessPort.PortDirection.PORT_DIRECTION_ENUM_PROPERTY, (Comparable)((Object)this.direction)));
            return;
        }
        if (requestName.equals("setFuelMode")) {
            this.fuelMode = (Integer)requestData != 0;
            return;
        }
        if (requestName.equals("ejectWaste")) {
            if (this.fuelMode) {
                this.ejectFuel();
            } else {
                this.ejectWaste();
            }
            return;
        }
        super.runRequest(requestName, requestData);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(ReactorAccessPort.INSTANCE.func_149739_a());
    }

    @Nullable
    public Container createMenu(int windowId, @Nonnull PlayerInventory playerInventory, @Nonnull PlayerEntity player) {
        return new ReactorAccessPortContainer(windowId, this.field_174879_c, player);
    }

    @Nullable
    public ReactorAccessPortState getState() {
        this.updateState();
        return this.reactorAccessPortState;
    }

    public void updateState() {
        this.reactorAccessPortState.direction = this.direction == ReactorAccessPort.PortDirection.INLET;
        this.reactorAccessPortState.fuelMode = this.fuelMode;
    }

    static {
        SUPPLIER = ReactorAccessPortTile::new;
        uraniumIngotTag = new ResourceLocation("forge:ingots/uranium");
        uraniumBlockTag = new ResourceLocation("forge:storage_blocks/uranium");
        yelloriumIngotTag = new ResourceLocation("forge:ingots/yellorium");
        yelloriumBlockTag = new ResourceLocation("forge:storage_blocks/yellorium");
    }
}

