/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor.simulation.experimental;

import net.minecraft.nbt.CompoundNBT;
import net.roguelogix.biggerreactors.Config;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.IReactorBattery;
import net.roguelogix.phosphophyllite.util.HeatBody;

public class Battery
extends HeatBody
implements IReactorBattery {
    private long capacity;
    private long stored;
    private long generatedLastTick;

    public Battery() {
        this.setInfinite(true);
    }

    public void setCapacity(long capacity) {
        this.capacity = capacity;
    }

    public double transferWith(HeatBody other, double rfkt) {
        double newTemp = other.temperature() - this.temperature();
        newTemp *= Math.exp(-rfkt / other.rfPerKelvin());
        double rfTransferred = ((newTemp += this.temperature()) - other.temperature()) * other.rfPerKelvin();
        this.generatedLastTick = (long)(-rfTransferred * Config.Reactor.OutputMultiplier * Config.Reactor.PassiveOutputMultiplier);
        this.stored += this.generatedLastTick;
        if (this.stored > this.capacity) {
            this.stored = this.capacity;
        }
        other.setTemperature(newTemp);
        return rfTransferred;
    }

    @Override
    public long extract(long toExtract) {
        this.stored -= toExtract;
        return toExtract;
    }

    @Override
    public long stored() {
        return this.stored;
    }

    @Override
    public long capacity() {
        return this.capacity;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74772_a("storedPower", this.stored);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.stored = nbt.func_74763_f("storedPower");
    }

    public long generatedLastTick() {
        return this.generatedLastTick;
    }
}

