/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor.simulation.classic;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.roguelogix.biggerreactors.Config;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.IReactorBattery;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.IReactorCoolantTank;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.IReactorFuelTank;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.IReactorSimulation;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.classic.Battery;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.classic.CoolantTank;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.classic.FuelTank;
import net.roguelogix.biggerreactors.registries.ReactorModeratorRegistry;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector2i;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector2ic;

public class ClassicReactorSimulation
implements IReactorSimulation {
    private final FuelTank fuelTank = new FuelTank();
    private final CoolantTank coolantTank = new CoolantTank();
    private final Battery battery = new Battery();
    private final ArrayList<ControlRod> controlRods = new ArrayList();
    private final Vector2i[] directions = new Vector2i[]{new Vector2i(1, 0), new Vector2i(-1, 0), new Vector2i(0, 1), new Vector2i(0, -1)};
    public double fuelConsumedLastTick = 0.0;
    public long FEProducedLastTick = 0L;
    private int x;
    private int y;
    private int z;
    private ReactorModeratorRegistry.IModeratorProperties[][][] moderatorProperties;
    private ControlRod[][] controlRodsXZ;
    private double fuelToReactorHeatTransferCoefficient = 0.0;
    private double reactorToCoolantSystemHeatTransferCoefficient = 0.0;
    private double reactorHeatLossCoefficient = 0.0;
    private boolean active = false;
    private double fuelFertility = 1.0;
    private double fuelHeat = Config.Reactor.Classic.AmbientTemperature;
    private double reactorHeat = Config.Reactor.Classic.AmbientTemperature;
    private boolean passive = true;
    private int rodToIrradiate = 0;
    private int yLevelToIrradiate = 0;

    public static double getRFFromVolumeAndTemp(double volume, double temperature) {
        return temperature * volume * Config.Reactor.Classic.FEPerCentigradePerUnitVolume;
    }

    public static double getTempFromVolumeAndRF(double volume, double rf) {
        return rf / (volume * Config.Reactor.Classic.FEPerCentigradePerUnitVolume);
    }

    double reactorVolume() {
        return this.x * this.y * this.z;
    }

    double fuelRodVolume() {
        return this.controlRods.size() * this.y;
    }

    @Override
    public void resize(int x, int y, int z) {
        int i;
        this.x = x;
        this.y = y;
        this.z = z;
        this.moderatorProperties = new ReactorModeratorRegistry.IModeratorProperties[x][][];
        for (i = 0; i < this.moderatorProperties.length; ++i) {
            this.moderatorProperties[i] = new ReactorModeratorRegistry.IModeratorProperties[y][];
            for (int j = 0; j < this.moderatorProperties[i].length; ++j) {
                this.moderatorProperties[i][j] = new ReactorModeratorRegistry.IModeratorProperties[z];
            }
        }
        this.controlRodsXZ = new ControlRod[x][];
        for (i = 0; i < this.controlRodsXZ.length; ++i) {
            this.controlRodsXZ[i] = new ControlRod[z];
        }
        this.controlRods.clear();
    }

    @Override
    public void setModeratorProperties(int x, int y, int z, ReactorModeratorRegistry.IModeratorProperties properties) {
        this.moderatorProperties[x][y][z] = properties;
    }

    @Override
    public void setControlRod(int x, int z) {
        ControlRod rod = new ControlRod(x, z);
        this.controlRods.add(rod);
        this.controlRodsXZ[x][z] = rod;
    }

    @Override
    public void setManifold(int x, int y, int z) {
        this.moderatorProperties[x][y][x] = this.coolantTank;
    }

    public int controlRodCount() {
        return this.controlRods.size();
    }

    @Override
    public void setControlRodInsertion(int x, int z, double insertion) {
        this.controlRodsXZ[x][z].insertion = insertion;
    }

    @Override
    public void updateInternalValues() {
        this.fuelTank.setCapacity(Config.Reactor.Classic.PerFuelRodCapacity * (long)this.controlRods.size() * (long)this.y);
        this.coolantTank.perSideCapacity = 0L;
        this.fuelToReactorHeatTransferCoefficient = 0.0;
        for (ControlRod controlRod : this.controlRods) {
            for (int i = 0; i < this.y; ++i) {
                for (Vector2i direction : this.directions) {
                    if (controlRod.x + direction.x < 0 || controlRod.x + direction.x >= this.x || controlRod.z + direction.y < 0 || controlRod.z + direction.y >= this.z) {
                        this.fuelToReactorHeatTransferCoefficient += Config.Reactor.Classic.CasingHeatTransferCoefficient;
                        continue;
                    }
                    ReactorModeratorRegistry.IModeratorProperties properties = this.moderatorProperties[controlRod.x + direction.x][i][controlRod.z + direction.y];
                    if (properties == null) continue;
                    this.fuelToReactorHeatTransferCoefficient += properties.heatConductivity();
                }
            }
        }
        this.fuelToReactorHeatTransferCoefficient *= Config.Reactor.Classic.FuelToCasingTransferCoefficientMultiplier;
        this.reactorToCoolantSystemHeatTransferCoefficient = (double)(2 * (this.x * this.y + this.x * this.z + this.z * this.y)) * Config.Reactor.Classic.CasingToCoolantSystemCoefficientMultiplier;
        this.reactorHeatLossCoefficient = (double)(2 * ((this.x + 2) * (this.y + 2) + (this.x + 2) * (this.z + 2) + (this.z + 2) * (this.y + 2))) * Config.Reactor.Classic.HeatLossCoefficientMultiplier;
        if (this.passive) {
            this.battery.setMaxStoredPower((long)((this.x + 2) * (this.y + 2) * (this.z + 2) - this.x * this.y * this.z) * Config.Reactor.Classic.PassiveBatteryPerExternalBlock);
        } else {
            this.coolantTank.perSideCapacity = (long)((this.x + 2) * (this.y + 2) * (this.z + 2) - this.x * this.y * this.z) * Config.Reactor.Classic.CoolantTankAmountPerExternalBlock;
        }
        this.rodToIrradiate = 0;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public void tick() {
        double rfTransferred;
        if (this.active) {
            this.radiate();
        } else {
            this.fuelConsumedLastTick = 0.0;
        }
        this.FEProducedLastTick = 0L;
        double denominator = Config.Reactor.Classic.FuelFertilityDecayDenominator;
        if (!this.active) {
            denominator *= Config.Reactor.Classic.FuelFertilityDecayDenominatorInactiveMultiplier;
        }
        this.fuelFertility = Math.max(0.0, this.fuelFertility - Math.max(Config.Reactor.Classic.FuelFertilityMinimumDecay, this.fuelFertility / denominator));
        double tempDiff = this.fuelHeat - this.reactorHeat;
        if (tempDiff > (double)0.01f) {
            rfTransferred = tempDiff * this.fuelToReactorHeatTransferCoefficient;
            double fuelRf = ClassicReactorSimulation.getRFFromVolumeAndTemp(this.fuelRodVolume(), this.fuelHeat);
            this.fuelHeat = ClassicReactorSimulation.getTempFromVolumeAndRF(this.fuelRodVolume(), fuelRf -= rfTransferred);
            double reactorRf = ClassicReactorSimulation.getRFFromVolumeAndTemp(this.reactorVolume(), this.reactorHeat);
            this.reactorHeat = ClassicReactorSimulation.getTempFromVolumeAndRF(this.reactorVolume(), reactorRf += rfTransferred);
        }
        if ((tempDiff = this.reactorHeat - this.getCoolantTemperature()) > (double)0.01f) {
            rfTransferred = tempDiff * this.reactorToCoolantSystemHeatTransferCoefficient;
            double reactorRf = ClassicReactorSimulation.getRFFromVolumeAndTemp(this.reactorVolume(), this.reactorHeat);
            if (this.passive) {
                this.FEProducedLastTick = this.battery.addPower((rfTransferred *= Config.Reactor.Classic.PassiveCoolingTransferEfficiency) * Config.Reactor.OutputMultiplier * Config.Reactor.PassiveOutputMultiplier);
            } else {
                rfTransferred -= this.coolantTank.absorbHeat(rfTransferred * Config.Reactor.OutputMultiplier * Config.Reactor.ActiveOutputMultiplier) / (Config.Reactor.OutputMultiplier * Config.Reactor.ActiveOutputMultiplier);
                this.FEProducedLastTick = this.coolantTank.transitionedLastTick();
            }
            this.reactorHeat = ClassicReactorSimulation.getTempFromVolumeAndRF(this.reactorVolume(), reactorRf -= rfTransferred);
        }
        if ((tempDiff = this.reactorHeat - Config.Reactor.Classic.AmbientTemperature) > (double)1.0E-6f) {
            double rfLost = Math.max(1.0, tempDiff * this.reactorHeatLossCoefficient);
            double reactorNewRf = Math.max(0.0, ClassicReactorSimulation.getRFFromVolumeAndTemp(this.reactorVolume(), this.reactorHeat) - rfLost);
            this.reactorHeat = ClassicReactorSimulation.getTempFromVolumeAndRF(this.reactorVolume(), reactorNewRf);
        }
        if (this.reactorHeat < Config.Reactor.Classic.AmbientTemperature + (double)0.01f) {
            this.reactorHeat = Config.Reactor.Classic.AmbientTemperature;
        }
        if (this.fuelHeat < Config.Reactor.Classic.AmbientTemperature + (double)0.01f) {
            this.fuelHeat = Config.Reactor.Classic.AmbientTemperature;
        }
    }

    @Override
    public void setPassivelyCooled(boolean passivelyCooled) {
        this.passive = passivelyCooled;
    }

    private double getCoolantTemperature() {
        if (this.passive) {
            return Config.Reactor.Classic.AmbientTemperature;
        }
        return this.coolantTank.getCoolantTemperature(this.reactorHeat);
    }

    private void radiate() {
        ++this.rodToIrradiate;
        if (this.rodToIrradiate == this.controlRods.size()) {
            this.rodToIrradiate = 0;
            ++this.yLevelToIrradiate;
        }
        if (this.yLevelToIrradiate == this.y) {
            this.yLevelToIrradiate = 0;
        }
        if (this.fuelTank.fuel() <= 0L) {
            return;
        }
        double radiationPenaltyBase = Math.exp(-Config.Reactor.Classic.RadPenaltyShiftMultiplier * Math.exp(-0.001 * Config.Reactor.Classic.RadPenaltyRateMultiplier * this.fuelHeat));
        long baseFuelAmount = this.fuelTank.fuel() + this.fuelTank.waste() / 100L;
        double rawRadIntensity = (double)baseFuelAmount * Config.Reactor.Classic.FissionEventsPerFuelUnit;
        double scaledRadIntensity = Math.pow(rawRadIntensity, Config.Reactor.Classic.FuelReactivity);
        scaledRadIntensity = Math.pow(scaledRadIntensity / (double)this.controlRods.size(), Config.Reactor.Classic.FuelReactivity) * (double)this.controlRods.size();
        double controlRodModifier = (100.0 - this.controlRods.get((int)this.rodToIrradiate).insertion) / 100.0;
        double effectiveRadIntensity = (scaledRadIntensity *= controlRodModifier) * (1.0 + -Config.Reactor.Classic.RadIntensityScalingMultiplier * Math.exp(-10.0 * Config.Reactor.Classic.RadIntensityScalingShiftMultiplier * Math.exp((double)-0.001f * Config.Reactor.Classic.RadIntensityScalingRateExponentMultiplier * this.fuelHeat)));
        double radHardness = (double)0.2f + 0.8 * radiationPenaltyBase;
        double rawFuelUsage = Config.Reactor.Classic.FuelPerRadiationUnit * (rawRadIntensity *= controlRodModifier) / this.fertility() * Config.Reactor.FuelUsageMultiplier;
        double fuelRfChange = Config.Reactor.Classic.FEPerRadiationUnit * effectiveRadIntensity;
        double environmentRfChange = 0.0;
        effectiveRadIntensity *= 0.25;
        double fuelAbsorbedRadiation = 0.0;
        Vector2i position = new Vector2i();
        block0: for (Vector2i direction : this.directions) {
            position.set(this.controlRods.get((int)this.rodToIrradiate).x, this.controlRods.get((int)this.rodToIrradiate).z);
            double hardness = radHardness;
            double intensity = effectiveRadIntensity;
            int i = 0;
            while ((long)i < Config.Reactor.Classic.IrradiationDistance && intensity > (double)1.0E-4f) {
                position.add((Vector2ic)direction);
                if (position.x < 0 || position.x >= this.x || position.y < 0 || position.y >= this.z) continue block0;
                ReactorModeratorRegistry.IModeratorProperties properties = this.moderatorProperties[position.x][this.yLevelToIrradiate][position.y];
                if (properties != null) {
                    double radiationAbsorbed = intensity * properties.absorption() * (1.0 - hardness);
                    intensity = Math.max(0.0, intensity - radiationAbsorbed);
                    hardness /= properties.moderation();
                    environmentRfChange += properties.heatEfficiency() * radiationAbsorbed * Config.Reactor.Classic.FEPerRadiationUnit;
                } else {
                    double controlRodInsertion = Math.min(1.0, Math.max(0.0, this.controlRodsXZ[position.x][position.y].insertion / 100.0));
                    double baseAbsorption = (1.0 - Config.Reactor.Classic.FuelAbsorptionScalingMultiplier * Math.exp(-10.0 * Config.Reactor.Classic.FuelAbsorptionScalingShiftMultiplier * Math.exp(-0.001 * Config.Reactor.Classic.FuelAbsorptionScalingRateExponentMultiplier * this.fuelHeat))) * (1.0 - hardness / Config.Reactor.Classic.FuelHardnessDivisor);
                    double scaledAbsorption = Math.min(1.0, baseAbsorption * Config.Reactor.Classic.FuelAbsorptionCoefficient);
                    double controlRodBonus = (1.0 - scaledAbsorption) * controlRodInsertion * 0.5;
                    double controlRodPenalty = scaledAbsorption * controlRodInsertion * 0.5;
                    double radiationAbsorbed = (scaledAbsorption + controlRodBonus) * intensity;
                    double fertilityAbsorbed = (scaledAbsorption - controlRodPenalty) * intensity;
                    double fuelModerationFactor = Config.Reactor.Classic.FuelModerationFactor;
                    fuelModerationFactor += fuelModerationFactor * controlRodInsertion + controlRodInsertion;
                    intensity = Math.max(0.0, intensity - radiationAbsorbed);
                    hardness /= fuelModerationFactor;
                    fuelRfChange += radiationAbsorbed * Config.Reactor.Classic.FEPerRadiationUnit;
                    fuelAbsorbedRadiation += fertilityAbsorbed;
                }
                ++i;
            }
        }
        this.fuelFertility += fuelAbsorbedRadiation;
        if (Double.isNaN(this.fuelFertility)) {
            this.fuelFertility = 1.0;
        }
        this.fuelTank.burn(rawFuelUsage);
        this.addFuelHeat(ClassicReactorSimulation.getTempFromVolumeAndRF(this.fuelRodVolume(), fuelRfChange));
        this.addReactorHeat(ClassicReactorSimulation.getTempFromVolumeAndRF(this.reactorVolume(), environmentRfChange));
        this.fuelConsumedLastTick = rawFuelUsage;
    }

    protected void addReactorHeat(double newCasingHeat) {
        if (Double.isNaN(newCasingHeat)) {
            return;
        }
        this.reactorHeat += newCasingHeat;
        if ((double)-1.0E-5f < this.reactorHeat && this.reactorHeat < (double)1.0E-5f) {
            this.reactorHeat = 0.0;
        }
    }

    protected void addFuelHeat(double additionalHeat) {
        if (Double.isNaN(additionalHeat)) {
            return;
        }
        this.fuelHeat += additionalHeat;
        if ((double)-1.0E-5f < this.fuelHeat & this.fuelHeat < (double)1.0E-5f) {
            this.fuelHeat = 0.0;
        }
    }

    @Override
    public double fertility() {
        if (this.fuelFertility <= 1.0) {
            return 1.0;
        }
        return Math.log10(this.fuelFertility) + 1.0;
    }

    @Override
    public double fuelHeat() {
        return this.fuelHeat;
    }

    @Override
    public double caseHeat() {
        return this.reactorHeat;
    }

    @Override
    public double ambientTemperature() {
        return 20.0;
    }

    @Override
    public double fuelConsumptionLastTick() {
        return this.fuelConsumedLastTick;
    }

    @Override
    public long outputLastTick() {
        return this.FEProducedLastTick;
    }

    @Override
    public long FEProducedLastTick() {
        return this.FEProducedLastTick;
    }

    @Override
    public long MBProducedLastTick() {
        if (this.isPassive()) {
            return 0L;
        }
        return this.FEProducedLastTick;
    }

    @Override
    public long maxMBProductionLastTick() {
        if (this.isPassive()) {
            return 0L;
        }
        return this.coolantTank.maxTransitionedLastTick();
    }

    @Override
    public IReactorBattery battery() {
        return this.battery;
    }

    @Override
    public IReactorCoolantTank coolantTank() {
        return this.coolantTank;
    }

    @Override
    public IReactorFuelTank fuelTank() {
        return this.fuelTank;
    }

    @Nonnull
    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("fuelTank", (INBT)this.fuelTank.serializeNBT());
        nbt.func_218657_a("coolantTank", (INBT)this.coolantTank.serializeNBT());
        nbt.func_218657_a("battery", (INBT)this.battery.serializeNBT());
        nbt.func_74780_a("fuelFertility", this.fuelFertility);
        nbt.func_74780_a("fuelHeat", this.fuelHeat);
        nbt.func_74780_a("reactorHeat", this.reactorHeat);
        return nbt;
    }

    public void deserializeNBT(@Nonnull CompoundNBT nbt) {
        if (nbt.func_74764_b("fuelTank")) {
            this.fuelTank.deserializeNBT(nbt.func_74775_l("fuelTank"));
        }
        if (nbt.func_74764_b("coolantTank")) {
            this.coolantTank.deserializeNBT(nbt.func_74775_l("coolantTank"));
        }
        if (nbt.func_74764_b("battery")) {
            this.battery.deserializeNBT(nbt.func_74775_l("battery"));
        }
        if (nbt.func_74764_b("fuelFertility")) {
            this.fuelFertility = nbt.func_74769_h("fuelFertility");
        }
        if (nbt.func_74764_b("fuelHeat")) {
            this.fuelHeat = nbt.func_74769_h("fuelHeat");
        }
        if (nbt.func_74764_b("reactorHeat")) {
            this.reactorHeat = nbt.func_74769_h("reactorHeat");
        }
    }

    @Override
    public boolean isPassive() {
        return this.passive;
    }

    private static class ControlRod {
        final int x;
        final int z;
        double insertion = 0.0;

        private ControlRod(int x, int z) {
            this.x = x;
            this.z = z;
        }
    }
}

