/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor.deps;

import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.util.LazyOptional;
import net.roguelogix.biggerreactors.multiblocks.reactor.ReactorMultiblockController;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorActivity;
import net.roguelogix.phosphophyllite.multiblock.generic.MultiblockController;

public class ReactorPeripheral
implements IPeripheral {
    @Nonnull
    private final Supplier<ReactorMultiblockController> rawControllerSupplier;
    @Nonnull
    private final LamdbaExceptionUtils.Supplier_WithExceptions<ReactorMultiblockController, LuaException> controllerSupplier;
    private final Battery battery;
    private final CoolantTank coolantTank;
    private final FuelTank fuelTank;
    ArrayList<ControlRod> controlRods = new ArrayList();

    public static LazyOptional<ReactorPeripheral> create(@Nonnull Supplier<ReactorMultiblockController> controllerSupplier) {
        return LazyOptional.of(() -> new ReactorPeripheral(controllerSupplier));
    }

    private ReactorPeripheral(@Nonnull Supplier<ReactorMultiblockController> rawControllerSupplier) {
        this.rawControllerSupplier = rawControllerSupplier;
        this.controllerSupplier = this::getController;
        this.battery = new Battery(this.controllerSupplier);
        this.coolantTank = new CoolantTank(this.controllerSupplier);
        this.fuelTank = new FuelTank(this.controllerSupplier);
    }

    @LuaFunction
    public boolean connected() {
        ReactorMultiblockController controller = this.rawControllerSupplier.get();
        if (controller == null) {
            return false;
        }
        return controller.assemblyState() == MultiblockController.AssemblyState.ASSEMBLED;
    }

    @Nonnull
    private ReactorMultiblockController getController() throws LuaException {
        ReactorMultiblockController controller = this.rawControllerSupplier.get();
        if (controller == null || controller.assemblyState() != MultiblockController.AssemblyState.ASSEMBLED) {
            throw new LuaException("Invalid multiblock controller");
        }
        return controller;
    }

    @LuaFunction
    public boolean active() throws LuaException {
        return ((ReactorMultiblockController)((Object)this.controllerSupplier.get())).isActive();
    }

    @LuaFunction
    public void setActive(boolean active) throws LuaException {
        ((ReactorMultiblockController)((Object)this.controllerSupplier.get())).setActive(active ? ReactorActivity.ACTIVE : ReactorActivity.INACTIVE);
    }

    @LuaFunction
    public Battery battery() throws LuaException {
        ReactorMultiblockController controller = (ReactorMultiblockController)((Object)this.controllerSupplier.get());
        if (!controller.simulation().isPassive()) {
            return null;
        }
        return this.battery;
    }

    @LuaFunction
    public CoolantTank coolantTank() throws LuaException {
        ReactorMultiblockController controller = (ReactorMultiblockController)((Object)this.controllerSupplier.get());
        if (controller.simulation().isPassive()) {
            return null;
        }
        return this.coolantTank;
    }

    @LuaFunction
    public FuelTank fuelTank() throws LuaException {
        return this.fuelTank;
    }

    @LuaFunction
    public int controlRodCount() {
        return this.controlRods.size();
    }

    @LuaFunction
    public ControlRod getControlRod(int index) {
        return this.controlRods.get(index);
    }

    @LuaFunction
    public void setAllControlRodLevels(double newLevel) throws LuaException {
        ((ReactorMultiblockController)((Object)this.controllerSupplier.get())).setAllControlRodLevels(newLevel);
    }

    public void rebuildControlRodList() {
        ReactorMultiblockController controller = this.rawControllerSupplier.get();
        if (controller == null) {
            return;
        }
        this.controlRods.forEach(ControlRod::invalidate);
        this.controlRods.clear();
        for (int i = 0; i < controller.controlRodCount(); ++i) {
            this.controlRods.add(new ControlRod(this.controllerSupplier, i));
        }
    }

    @LuaFunction
    public double fuelTemperature() throws LuaException {
        return ((ReactorMultiblockController)((Object)this.controllerSupplier.get())).simulation().fuelHeat();
    }

    @LuaFunction
    public double casingTemperature() throws LuaException {
        return ((ReactorMultiblockController)((Object)this.controllerSupplier.get())).simulation().caseHeat();
    }

    @LuaFunction
    public double ambientTemperature() throws LuaException {
        return ((ReactorMultiblockController)((Object)this.controllerSupplier.get())).simulation().ambientTemperature();
    }

    @Nonnull
    public String getType() {
        return "BiggerReactors_Reactor";
    }

    public boolean equals(@Nullable IPeripheral other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ReactorPeripheral) {
            if (this.rawControllerSupplier.get() == null) {
                return false;
            }
            return ((ReactorPeripheral)other).rawControllerSupplier.get() == this.rawControllerSupplier.get();
        }
        return false;
    }

    public static class ControlRod {
        private final LamdbaExceptionUtils.Supplier_WithExceptions<ReactorMultiblockController, LuaException> controllerSupplier;
        private final int index;
        private boolean isValid = true;

        public ControlRod(LamdbaExceptionUtils.Supplier_WithExceptions<ReactorMultiblockController, LuaException> controllerSupplier, int index) {
            this.controllerSupplier = controllerSupplier;
            this.index = index;
        }

        @LuaFunction
        public boolean valid() {
            return this.isValid;
        }

        @LuaFunction
        public int index() {
            return this.index;
        }

        @LuaFunction
        public double level() throws LuaException {
            if (!this.isValid) {
                throw new LuaException("Invalid control rod object");
            }
            return ((ReactorMultiblockController)((Object)this.controllerSupplier.get())).controlRodLevel(this.index);
        }

        @LuaFunction
        public void setLevel(double newLevel) throws LuaException {
            if (!this.isValid) {
                throw new LuaException("Invalid control rod object");
            }
            ((ReactorMultiblockController)((Object)this.controllerSupplier.get())).setControlRodLevel(this.index, newLevel);
        }

        @LuaFunction
        public String name() throws LuaException {
            if (!this.isValid) {
                throw new LuaException("Invalid control rod object");
            }
            return ((ReactorMultiblockController)((Object)this.controllerSupplier.get())).controlRodName(this.index);
        }

        @LuaFunction
        public void setName(String newName) throws LuaException {
            if (!this.isValid) {
                throw new LuaException("Invalid control rod object");
            }
            ((ReactorMultiblockController)((Object)this.controllerSupplier.get())).setControlRodName(this.index, newName);
        }

        void invalidate() {
            this.isValid = false;
        }
    }

    public static class FuelTank {
        private final LamdbaExceptionUtils.Supplier_WithExceptions<ReactorMultiblockController, LuaException> controllerSupplier;

        public FuelTank(LamdbaExceptionUtils.Supplier_WithExceptions<ReactorMultiblockController, LuaException> controllerSupplier) {
            this.controllerSupplier = controllerSupplier;
        }

        @LuaFunction
        public long capacity() throws LuaException {
            return ((ReactorMultiblockController)((Object)this.controllerSupplier.get())).simulation().fuelTank().capacity();
        }

        @LuaFunction
        public long totalReactant() throws LuaException {
            return ((ReactorMultiblockController)((Object)this.controllerSupplier.get())).simulation().fuelTank().totalStored();
        }

        @LuaFunction
        public long fuel() throws LuaException {
            return ((ReactorMultiblockController)((Object)this.controllerSupplier.get())).simulation().fuelTank().fuel();
        }

        @LuaFunction
        public long waste() throws LuaException {
            return ((ReactorMultiblockController)((Object)this.controllerSupplier.get())).simulation().fuelTank().waste();
        }

        @LuaFunction
        public void ejectWaste() throws LuaException {
            ((ReactorMultiblockController)((Object)this.controllerSupplier.get())).ejectWaste();
        }

        @LuaFunction
        public double fuelReactivity() throws LuaException {
            return ((ReactorMultiblockController)((Object)this.controllerSupplier.get())).simulation().fertility();
        }

        @LuaFunction
        public double burnedLastTick() throws LuaException {
            return ((ReactorMultiblockController)((Object)this.controllerSupplier.get())).simulation().fuelConsumptionLastTick();
        }
    }

    public static class CoolantTank {
        private final LamdbaExceptionUtils.Supplier_WithExceptions<ReactorMultiblockController, LuaException> controllerSupplier;

        public CoolantTank(LamdbaExceptionUtils.Supplier_WithExceptions<ReactorMultiblockController, LuaException> controllerSupplier) {
            this.controllerSupplier = controllerSupplier;
        }

        @LuaFunction
        public long coldFluidAmount() throws LuaException {
            return ((ReactorMultiblockController)((Object)this.controllerSupplier.get())).simulation().coolantTank().liquidAmount();
        }

        @LuaFunction
        public long hotFluidAmount() throws LuaException {
            return ((ReactorMultiblockController)((Object)this.controllerSupplier.get())).simulation().coolantTank().vaporAmount();
        }

        @LuaFunction
        public long capacity() throws LuaException {
            return ((ReactorMultiblockController)((Object)this.controllerSupplier.get())).simulation().coolantTank().perSideCapacity();
        }

        @LuaFunction
        public long transitionedLastTick() throws LuaException {
            return ((ReactorMultiblockController)((Object)this.controllerSupplier.get())).simulation().MBProducedLastTick();
        }

        @LuaFunction
        public long maxTransitionedLastTick() throws LuaException {
            return ((ReactorMultiblockController)((Object)this.controllerSupplier.get())).simulation().maxMBProductionLastTick();
        }
    }

    public static class Battery {
        private final LamdbaExceptionUtils.Supplier_WithExceptions<ReactorMultiblockController, LuaException> controllerSupplier;

        public Battery(LamdbaExceptionUtils.Supplier_WithExceptions<ReactorMultiblockController, LuaException> controllerSupplier) {
            this.controllerSupplier = controllerSupplier;
        }

        @LuaFunction
        public long stored() throws LuaException {
            return ((ReactorMultiblockController)((Object)this.controllerSupplier.get())).simulation().battery().stored();
        }

        @LuaFunction
        public long capacity() throws LuaException {
            return ((ReactorMultiblockController)((Object)this.controllerSupplier.get())).simulation().battery().capacity();
        }

        @LuaFunction
        public long producedLastTick() throws LuaException {
            return ((ReactorMultiblockController)((Object)this.controllerSupplier.get())).simulation().FEProducedLastTick();
        }
    }
}

