/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.machine.tiles;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.roguelogix.biggerreactors.Config;
import net.roguelogix.biggerreactors.api.IWorkHandler;
import net.roguelogix.biggerreactors.api.WorkHandler;
import net.roguelogix.biggerreactors.items.ingots.BlutoniumIngot;
import net.roguelogix.biggerreactors.machine.blocks.CyaniteReprocessor;
import net.roguelogix.biggerreactors.machine.containers.CyaniteReprocessorContainer;
import net.roguelogix.biggerreactors.machine.state.CyaniteReprocessorState;
import net.roguelogix.biggerreactors.machine.tiles.impl.CyaniteReprocessorItemHandler;
import net.roguelogix.phosphophyllite.gui.client.api.IHasUpdatableState;
import net.roguelogix.phosphophyllite.items.DebugTool;
import net.roguelogix.phosphophyllite.registry.RegisterTileEntity;
import net.roguelogix.phosphophyllite.registry.TileSupplier;

@RegisterTileEntity(name="cyanite_reprocessor")
public class CyaniteReprocessorTile
extends LockableTileEntity
implements INamedContainerProvider,
ITickableTileEntity,
IHasUpdatableState<CyaniteReprocessorState> {
    @RegisterTileEntity.Type
    public static TileEntityType<CyaniteReprocessorTile> INSTANCE;
    @RegisterTileEntity.Supplier
    public static final TileSupplier SUPPLIER;
    public final CyaniteReprocessorState cyaniteReprocessorState = new CyaniteReprocessorState(this);
    private WorkHandler workHandler;
    private final LazyOptional<IWorkHandler> WORK_HANDLER_CAPABILITY = LazyOptional.of(() -> this.workHandler);
    private CyaniteReprocessorItemHandler itemHandler;
    private final LazyOptional<IItemHandler> ITEM_HANDLER_CAPABILITY = LazyOptional.of(() -> this.itemHandler.pipeHandler());
    private EnergyStorage energyStorage;
    private final LazyOptional<IEnergyStorage> ENERGY_STORAGE_CAPABILITY = LazyOptional.of(() -> this.energyStorage);
    private FluidTank fluidTank;
    private final LazyOptional<IFluidTank> FLUID_TANK_CAPABILITY = LazyOptional.of(() -> this.fluidTank);
    private ItemStack itemPresentLastTick = ItemStack.field_190927_a;

    public CyaniteReprocessorTile() {
        super(INSTANCE);
        this.func_174888_l();
        this.updateState();
    }

    @Nonnull
    public ActionResultType onBlockActivated(@Nonnull BlockState blockState, World world, @Nonnull BlockPos blockPos, @Nonnull PlayerEntity player, @Nonnull Hand hand, @Nonnull BlockRayTraceResult trace) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (ItemStack.func_179545_c((ItemStack)player.func_184614_ca(), (ItemStack)new ItemStack((IItemProvider)DebugTool.INSTANCE))) {
            player.func_145747_a((ITextComponent)new StringTextComponent(String.format("[%s] Progress: %s/%s", "biggerreactors", this.cyaniteReprocessorState.workTime, this.cyaniteReprocessorState.workTimeTotal)), player.func_110124_au());
            player.func_145747_a((ITextComponent)new StringTextComponent(String.format("[%s] Energy: %s/%s RF", "biggerreactors", this.cyaniteReprocessorState.energyStored, this.cyaniteReprocessorState.energyCapacity)), player.func_110124_au());
            player.func_145747_a((ITextComponent)new StringTextComponent(String.format("[%s] Fluid Tank: %s/%s mB", "biggerreactors", this.cyaniteReprocessorState.waterStored, this.cyaniteReprocessorState.waterCapacity)), player.func_110124_au());
            return ActionResultType.SUCCESS;
        }
        if (ItemStack.func_179545_c((ItemStack)player.func_184614_ca(), (ItemStack)new ItemStack((IItemProvider)Items.field_151131_as))) {
            if (this.fluidTank.getFluidAmount() <= Config.CyaniteReprocessor.WaterTankCapacity - 1000) {
                this.fluidTank.fill(new FluidStack((Fluid)Fluids.field_204546_a, 1000), IFluidHandler.FluidAction.EXECUTE);
                player.func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)Items.field_151133_ar));
            }
            return ActionResultType.SUCCESS;
        }
        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this, (BlockPos)blockPos);
        return ActionResultType.SUCCESS;
    }

    public void onReplaced(BlockState blockState, World world, BlockPos blockPos, BlockState newBlockState, boolean isMoving) {
        ItemStack outputStack;
        ItemStack inputStack = this.itemHandler.getStackInSlot(0);
        if (!inputStack.func_190926_b()) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)blockPos, (IInventory)new Inventory(new ItemStack[]{inputStack}));
        }
        if (!(outputStack = this.itemHandler.getStackInSlot(1)).func_190926_b()) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)blockPos, (IInventory)new Inventory(new ItemStack[]{outputStack}));
        }
    }

    public ITextComponent func_145748_c_() {
        return this.func_213907_g();
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("block.biggerreactors.cyanite_reprocessor");
    }

    protected Container func_213906_a(int windowId, PlayerInventory playerInventory) {
        return new CyaniteReprocessorContainer(windowId, this.func_174877_v(), playerInventory.field_70458_d);
    }

    @Nonnull
    public CyaniteReprocessorState getState() {
        this.updateState();
        return this.cyaniteReprocessorState;
    }

    public void updateState() {
        this.cyaniteReprocessorState.workTime = this.workHandler.getProgress();
        this.cyaniteReprocessorState.workTimeTotal = this.workHandler.getGoal();
        this.cyaniteReprocessorState.energyStored = this.energyStorage.getEnergyStored();
        this.cyaniteReprocessorState.energyCapacity = this.energyStorage.getMaxEnergyStored();
        this.cyaniteReprocessorState.waterStored = this.fluidTank.getFluidAmount();
        this.cyaniteReprocessorState.waterCapacity = this.fluidTank.getCapacity();
    }

    public int func_70302_i_() {
        return this.itemHandler.getSlots();
    }

    public boolean func_191420_l() {
        for (int index = 0; index < this.itemHandler.getSlots(); ++index) {
            if (this.itemHandler.getStackInSlot(index).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return this.itemHandler.getStackInSlot(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return this.itemHandler.getStackInSlot(index).func_77979_a(count);
    }

    public ItemStack func_70304_b(int index) {
        ItemStack itemStack = this.itemHandler.getStackInSlot(index).func_77946_l();
        this.itemHandler.setStackInSlot(index, ItemStack.field_190927_a);
        return itemStack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack oldStack = this.itemHandler.getStackInSlot(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(oldStack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)oldStack);
        this.itemHandler.setStackInSlot(index, stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !flag) {
            this.workHandler.clear();
            this.func_70296_d();
        }
    }

    public void func_174888_l() {
        this.workHandler = new WorkHandler(Config.CyaniteReprocessor.TotalWorkTime);
        this.itemHandler = new CyaniteReprocessorItemHandler();
        this.itemHandler.setSize(2);
        this.energyStorage = new EnergyStorage(Config.CyaniteReprocessor.EnergyTankCapacity);
        this.fluidTank = new FluidTank(Config.CyaniteReprocessor.WaterTankCapacity, fluid -> fluid.getFluid() == Fluids.field_204546_a);
    }

    public boolean func_70300_a(PlayerEntity player) {
        assert (this.field_145850_b != null);
        if (this.field_145850_b.func_175625_s(this.func_174877_v()) != this) {
            return false;
        }
        return player.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public void func_230337_a_(BlockState state, @Nonnull CompoundNBT parentCompound) {
        super.func_230337_a_(state, parentCompound);
        CompoundNBT childCompound = parentCompound.func_74775_l("cyaniteReprocessorState");
        this.workHandler = new WorkHandler(childCompound.func_74762_e("workTimeTotal"), childCompound.func_74762_e("workTime"));
        this.itemHandler.deserializeNBT(childCompound.func_74775_l("inventory"));
        this.energyStorage = new EnergyStorage(childCompound.func_74762_e("energyCapacity"), Config.CyaniteReprocessor.TransferRate, Config.CyaniteReprocessor.TransferRate, childCompound.func_74762_e("energyStored"));
        this.fluidTank = this.fluidTank.readFromNBT(childCompound.func_74775_l("fluidStorage"));
    }

    public final CompoundNBT func_189515_b(@Nonnull CompoundNBT parentCompound) {
        super.func_189515_b(parentCompound);
        CompoundNBT childCompound = new CompoundNBT();
        childCompound.func_74768_a("workTime", this.workHandler.getProgress());
        childCompound.func_74768_a("workTimeTotal", this.workHandler.getGoal());
        childCompound.func_218657_a("inventory", (INBT)this.itemHandler.serializeNBT());
        childCompound.func_74768_a("energyStored", this.energyStorage.getEnergyStored());
        childCompound.func_74768_a("energyCapacity", this.energyStorage.getMaxEnergyStored());
        childCompound.func_218657_a("fluidTank", (INBT)this.fluidTank.writeToNBT(new CompoundNBT()));
        parentCompound.func_218657_a("cyaniteReprocessorState", (INBT)childCompound);
        return parentCompound;
    }

    private boolean canWork() {
        if (this.func_70301_a(1).func_190916_E() >= 64) {
            return false;
        }
        return this.energyStorage.getEnergyStored() >= Config.CyaniteReprocessor.EnergyConsumptionPerTick && this.fluidTank.getFluidAmount() >= Config.CyaniteReprocessor.WaterConsumptionPerTick;
    }

    public void func_73660_a() {
        BlockState currentBlockState;
        BlockState newBlockState;
        assert (this.field_145850_b != null);
        if (this.field_145850_b.func_201670_d()) {
            return;
        }
        boolean doUpdate = false;
        boolean isActive = false;
        ItemStack inputStack = this.itemHandler.getStackInSlot(0);
        if (!ItemStack.func_179545_c((ItemStack)this.itemPresentLastTick, (ItemStack)inputStack)) {
            this.workHandler.clear();
        }
        this.itemPresentLastTick = inputStack.func_77946_l();
        if (inputStack.func_190916_E() >= 2) {
            if (this.canWork()) {
                isActive = true;
                doUpdate = true;
                this.workHandler.increment(1);
                this.energyStorage.extractEnergy(Config.CyaniteReprocessor.EnergyConsumptionPerTick, false);
                this.fluidTank.drain(Config.CyaniteReprocessor.WaterConsumptionPerTick, IFluidHandler.FluidAction.EXECUTE);
            } else if (this.workHandler.getProgress() > 0) {
                this.workHandler.decrement(2);
            }
            if (this.workHandler.isFinished()) {
                this.itemHandler.extractItem(0, 2, false);
                this.itemHandler.insertItem(1, new ItemStack((IItemProvider)BlutoniumIngot.INSTANCE, 1), false);
                this.workHandler.clear();
            }
        }
        if (!(newBlockState = (BlockState)(currentBlockState = this.field_145850_b.func_180495_p(this.func_174877_v())).func_206870_a((Property)CyaniteReprocessor.ENABLED, (Comparable)Boolean.valueOf(isActive))).equals(currentBlockState)) {
            this.field_145850_b.func_175656_a(this.func_174877_v(), newBlockState);
            doUpdate = true;
        }
        if (doUpdate) {
            this.func_70296_d();
        }
        this.updateState();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (capability.equals((Object)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
            return this.ITEM_HANDLER_CAPABILITY.cast();
        }
        if (capability.equals((Object)CapabilityEnergy.ENERGY)) {
            return this.ENERGY_STORAGE_CAPABILITY.cast();
        }
        if (capability.equals((Object)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)) {
            return this.FLUID_TANK_CAPABILITY.cast();
        }
        return Objects.requireNonNull(super.getCapability(capability, side));
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.itemHandler.isItemValid(index, stack);
    }

    public CyaniteReprocessorItemHandler getItemHandler() {
        return this.itemHandler;
    }

    static {
        SUPPLIER = CyaniteReprocessorTile::new;
    }
}

