/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.client.deps.jei.classic.turbine;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.roguelogix.biggerreactors.multiblocks.turbine.blocks.TurbineTerminal;
import net.roguelogix.biggerreactors.registries.TurbineCoilRegistry;

public class CoilCategory
implements IRecipeCategory<Recipe> {
    private final IDrawable background;
    private final IDrawable icon;
    public static final ResourceLocation UID = new ResourceLocation("biggerreactors", "classic/turbine_coil");

    public CoilCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)TurbineTerminal.INSTANCE));
        this.background = guiHelper.createDrawable(new ResourceLocation("biggerreactors", "textures/jei/common.png"), 0, 6, 144, 34);
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class getRecipeClass() {
        return Recipe.class;
    }

    public String getTitle() {
        return I18n.func_135052_a((String)"jei.biggerreactors.classic.turbine_coil_block", (Object[])new Object[0]);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(Recipe recipe, IIngredients iIngredients) {
        iIngredients.setInput(VanillaTypes.ITEM, (Object)recipe.getInput());
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, Recipe recipe, IIngredients iIngredients) {
        IGuiItemStackGroup guiItemStacks = iRecipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 0, 8);
        guiItemStacks.set(iIngredients);
    }

    public void draw(Recipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.func_71410_x();
        String[] info = new String[]{I18n.func_135052_a((String)"jei.biggerreactors.classic.turbine_coil_bonus", (Object[])new Object[]{recipe.getCoilData().bonus}), I18n.func_135052_a((String)"jei.biggerreactors.classic.turbine_coil_efficiency", (Object[])new Object[]{recipe.getCoilData().efficiency}), I18n.func_135052_a((String)"jei.biggerreactors.classic.turbine_coil_extraction", (Object[])new Object[]{recipe.getCoilData().extractionRate})};
        mc.field_71466_p.func_238421_b_(matrixStack, info[0], 80.0f - (float)mc.field_71466_p.func_78256_a(info[0]) / 2.0f, 0.0f, Color.BLACK.getRGB());
        mc.field_71466_p.func_238421_b_(matrixStack, info[1], 80.0f - (float)mc.field_71466_p.func_78256_a(info[1]) / 2.0f, 12.0f, Color.BLACK.getRGB());
        mc.field_71466_p.func_238421_b_(matrixStack, info[2], 80.0f - (float)mc.field_71466_p.func_78256_a(info[2]) / 2.0f, 24.0f, Color.BLACK.getRGB());
    }

    public static class Recipe {
        private final ItemStack input;
        private final TurbineCoilRegistry.CoilData coilData;

        public Recipe(ItemStack input, TurbineCoilRegistry.CoilData coilData) {
            this.input = input;
            this.coilData = coilData;
        }

        public ItemStack getInput() {
            return this.input;
        }

        public TurbineCoilRegistry.CoilData getCoilData() {
            return this.coilData;
        }
    }
}

