/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.client.deps.jei.classic.reactor;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.roguelogix.biggerreactors.multiblocks.reactor.blocks.ReactorTerminal;
import net.roguelogix.biggerreactors.registries.ReactorModeratorRegistry;

public class BlockModeratorCategory
implements IRecipeCategory<Recipe> {
    private final IDrawable background;
    private final IDrawable icon;
    public static final ResourceLocation UID = new ResourceLocation("biggerreactors", "classic/reactor_moderator_block");

    public BlockModeratorCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ReactorTerminal.INSTANCE));
        this.background = guiHelper.createDrawable(new ResourceLocation("biggerreactors", "textures/jei/common.png"), 0, 0, 144, 46);
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class getRecipeClass() {
        return Recipe.class;
    }

    public String getTitle() {
        return I18n.func_135052_a((String)"jei.biggerreactors.classic.reactor_moderator_block", (Object[])new Object[0]);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(Recipe recipe, IIngredients iIngredients) {
        iIngredients.setInput(VanillaTypes.ITEM, (Object)recipe.getInput());
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, Recipe recipe, IIngredients iIngredients) {
        IGuiItemStackGroup guiItemStacks = iRecipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 0, 14);
        guiItemStacks.set(iIngredients);
    }

    public void draw(Recipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.func_71410_x();
        String[] info = new String[]{I18n.func_135052_a((String)"jei.biggerreactors.classic.reactor_moderator_moderation", (Object[])new Object[]{recipe.getModeratorProperties().moderation}), I18n.func_135052_a((String)"jei.biggerreactors.classic.reactor_moderator_absorption", (Object[])new Object[]{recipe.getModeratorProperties().absorption}), I18n.func_135052_a((String)"jei.biggerreactors.classic.reactor_moderator_conductivity", (Object[])new Object[]{recipe.getModeratorProperties().heatConductivity}), I18n.func_135052_a((String)"jei.biggerreactors.classic.reactor_moderator_efficiency", (Object[])new Object[]{recipe.getModeratorProperties().heatEfficiency})};
        mc.field_71466_p.func_238421_b_(matrixStack, info[0], 80.0f - (float)mc.field_71466_p.func_78256_a(info[0]) / 2.0f, 0.0f, Color.BLACK.getRGB());
        mc.field_71466_p.func_238421_b_(matrixStack, info[1], 80.0f - (float)mc.field_71466_p.func_78256_a(info[1]) / 2.0f, 12.0f, Color.BLACK.getRGB());
        mc.field_71466_p.func_238421_b_(matrixStack, info[2], 80.0f - (float)mc.field_71466_p.func_78256_a(info[2]) / 2.0f, 24.0f, Color.BLACK.getRGB());
        mc.field_71466_p.func_238421_b_(matrixStack, info[3], 80.0f - (float)mc.field_71466_p.func_78256_a(info[3]) / 2.0f, 36.0f, Color.BLACK.getRGB());
    }

    public static class Recipe {
        private final ItemStack input;
        private final ReactorModeratorRegistry.ModeratorProperties moderatorProperties;

        public Recipe(ItemStack input, ReactorModeratorRegistry.ModeratorProperties moderatorProperties) {
            this.input = input;
            this.moderatorProperties = moderatorProperties;
        }

        public ItemStack getInput() {
            return this.input;
        }

        public ReactorModeratorRegistry.ModeratorProperties getModeratorProperties() {
            return this.moderatorProperties;
        }
    }
}

