/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor.tiles;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.chemical.gas.IGasHandler;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.fml.network.NetworkHooks;
import net.roguelogix.biggerreactors.multiblocks.reactor.ReactorMultiblockController;
import net.roguelogix.biggerreactors.multiblocks.reactor.blocks.ReactorAccessPort;
import net.roguelogix.biggerreactors.multiblocks.reactor.blocks.ReactorCoolantPort;
import net.roguelogix.biggerreactors.multiblocks.reactor.containers.ReactorCoolantPortContainer;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.IReactorCoolantTank;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorCoolantPortState;
import net.roguelogix.biggerreactors.multiblocks.reactor.tiles.ReactorBaseTile;
import net.roguelogix.phosphophyllite.fluids.FluidHandlerWrapper;
import net.roguelogix.phosphophyllite.fluids.IPhosphophylliteFluidHandler;
import net.roguelogix.phosphophyllite.fluids.MekanismGasWrappers;
import net.roguelogix.phosphophyllite.gui.client.api.IHasUpdatableState;
import net.roguelogix.phosphophyllite.multiblock.generic.IAssemblyAttemptedTile;
import net.roguelogix.phosphophyllite.multiblock.generic.IOnAssemblyTile;
import net.roguelogix.phosphophyllite.multiblock.generic.IOnDisassemblyTile;
import net.roguelogix.phosphophyllite.multiblock.generic.MultiblockBlock;
import net.roguelogix.phosphophyllite.registry.RegisterTileEntity;
import net.roguelogix.phosphophyllite.registry.TileSupplier;
import net.roguelogix.phosphophyllite.util.BlockStates;

@RegisterTileEntity(name="reactor_coolant_port")
public class ReactorCoolantPortTile
extends ReactorBaseTile
implements IPhosphophylliteFluidHandler,
INamedContainerProvider,
IHasUpdatableState<ReactorCoolantPortState>,
IAssemblyAttemptedTile,
IOnAssemblyTile,
IOnDisassemblyTile {
    @RegisterTileEntity.Type
    public static TileEntityType<?> TYPE;
    @RegisterTileEntity.Supplier
    public static final TileSupplier SUPPLIER;
    @CapabilityInject(value=IGasHandler.class)
    public static Capability<IGasHandler> GAS_HANDLER_CAPABILITY;
    private IReactorCoolantTank transitionTank;
    private boolean connected = false;
    Direction steamOutputDirection = null;
    @Nonnull
    LazyOptional<?> handlerOptional = LazyOptional.empty();
    IPhosphophylliteFluidHandler handler = null;
    FluidTank EMPTY_TANK = new FluidTank(0);
    private ReactorAccessPort.PortDirection direction = ReactorAccessPort.PortDirection.INLET;
    public final ReactorCoolantPortState reactorCoolantPortState = new ReactorCoolantPortState(this);

    public ReactorCoolantPortTile() {
        super(TYPE);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this).cast();
        }
        if (cap == GAS_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> MekanismGasWrappers.wrap((IPhosphophylliteFluidHandler)this)).cast();
        }
        return super.getCapability(cap, side);
    }

    public int tankCount() {
        if (this.transitionTank == null) {
            return 0;
        }
        return this.transitionTank.tankCount();
    }

    public long tankCapacity(int tank) {
        if (this.transitionTank == null) {
            return 0L;
        }
        return this.transitionTank.tankCapacity(tank);
    }

    @Nonnull
    public Fluid fluidTypeInTank(int tank) {
        if (this.transitionTank == null) {
            return Fluids.field_204541_a;
        }
        return this.transitionTank.fluidTypeInTank(tank);
    }

    @Nullable
    public CompoundNBT fluidTagInTank(int tank) {
        if (this.transitionTank == null) {
            return null;
        }
        return this.transitionTank.fluidTagInTank(tank);
    }

    public long fluidAmountInTank(int tank) {
        if (this.transitionTank == null) {
            return 0L;
        }
        return this.transitionTank.fluidAmountInTank(tank);
    }

    public boolean fluidValidForTank(int tank, @Nonnull Fluid fluid) {
        if (this.transitionTank == null) {
            return false;
        }
        return this.transitionTank.fluidValidForTank(tank, fluid);
    }

    public long fill(@Nonnull Fluid fluid, @Nullable CompoundNBT tag, long amount, boolean simulate) {
        if (this.transitionTank == null || this.direction != ReactorAccessPort.PortDirection.INLET) {
            return 0L;
        }
        return this.transitionTank.fill(fluid, tag, amount, simulate);
    }

    public long drain(@Nonnull Fluid fluid, @Nullable CompoundNBT tag, long amount, boolean simulate) {
        if (this.transitionTank == null || this.direction == ReactorAccessPort.PortDirection.INLET) {
            return 0L;
        }
        return this.transitionTank.drain(fluid, tag, amount, simulate);
    }

    public long pushFluid() {
        if (!this.connected || this.direction == ReactorAccessPort.PortDirection.INLET) {
            return 0L;
        }
        if (this.handlerOptional.isPresent()) {
            Fluid fluid = this.transitionTank.vaporType();
            long amount = this.transitionTank.vaporAmount();
            amount = this.transitionTank.drain(fluid, null, amount, true);
            amount = this.handler.fill(fluid, null, amount, false);
            amount = this.transitionTank.drain(fluid, null, amount, false);
            return amount;
        }
        this.handlerOptional = LazyOptional.empty();
        this.handler = null;
        this.connected = false;
        return 0L;
    }

    public void neighborChanged() {
        LazyOptional gasOptional;
        this.handlerOptional = LazyOptional.empty();
        this.handler = null;
        if (this.steamOutputDirection == null) {
            this.connected = false;
            return;
        }
        assert (this.field_145850_b != null);
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.steamOutputDirection));
        if (te == null) {
            this.connected = false;
            return;
        }
        this.connected = false;
        LazyOptional fluidOptional = te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.steamOutputDirection.func_176734_d());
        if (fluidOptional.isPresent()) {
            this.connected = true;
            this.handlerOptional = fluidOptional;
            this.handler = FluidHandlerWrapper.wrap((IFluidHandler)((IFluidHandler)fluidOptional.orElse((Object)this.EMPTY_TANK)));
        } else if (GAS_HANDLER_CAPABILITY != null && (gasOptional = te.getCapability(GAS_HANDLER_CAPABILITY, this.steamOutputDirection.func_176734_d())).isPresent()) {
            IGasHandler gasHandler = (IGasHandler)gasOptional.orElse((Object)MekanismGasWrappers.EMPTY_TANK);
            this.connected = true;
            this.handlerOptional = gasOptional;
            this.handler = MekanismGasWrappers.wrap((IGasHandler)gasHandler);
        }
    }

    public void setDirection(ReactorAccessPort.PortDirection direction) {
        this.direction = direction;
        this.func_70296_d();
    }

    protected void readNBT(@Nonnull CompoundNBT compound) {
        if (compound.func_74764_b("direction")) {
            this.direction = ReactorAccessPort.PortDirection.valueOf(compound.func_74779_i("direction"));
        }
    }

    @Nonnull
    protected CompoundNBT writeNBT() {
        CompoundNBT NBT = new CompoundNBT();
        NBT.func_74778_a("direction", String.valueOf((Object)this.direction));
        return NBT;
    }

    public void onAssemblyAttempted() {
        assert (this.field_145850_b != null);
        this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a(ReactorAccessPort.PortDirection.PORT_DIRECTION_ENUM_PROPERTY, (Comparable)((Object)this.direction)));
    }

    @Nonnull
    public ActionResultType onBlockActivated(@Nonnull PlayerEntity player, @Nonnull Hand handIn) {
        assert (this.field_145850_b != null);
        if (((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((Property)MultiblockBlock.ASSEMBLED)).booleanValue()) {
            if (!this.field_145850_b.field_72995_K) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this, (BlockPos)this.func_174877_v());
            }
            return ActionResultType.SUCCESS;
        }
        return super.onBlockActivated(player, handIn);
    }

    @Override
    public void runRequest(String requestName, Object requestData) {
        if (requestName.equals("setDirection")) {
            this.setDirection((Integer)requestData != 0 ? ReactorAccessPort.PortDirection.OUTLET : ReactorAccessPort.PortDirection.INLET);
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a(ReactorAccessPort.PortDirection.PORT_DIRECTION_ENUM_PROPERTY, (Comparable)((Object)this.direction)));
        }
        super.runRequest(requestName, requestData);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(ReactorCoolantPort.INSTANCE.func_149739_a());
    }

    @Nullable
    public Container createMenu(int windowId, @Nonnull PlayerInventory playerInventory, @Nonnull PlayerEntity player) {
        return new ReactorCoolantPortContainer(windowId, this.field_174879_c, player);
    }

    @Nonnull
    public ReactorCoolantPortState getState() {
        this.updateState();
        return this.reactorCoolantPortState;
    }

    public void updateState() {
        this.reactorCoolantPortState.direction = this.direction == ReactorAccessPort.PortDirection.INLET;
    }

    public void onAssembly() {
        this.transitionTank = ((ReactorMultiblockController)this.controller).simulation().coolantTank();
        this.steamOutputDirection = (Direction)this.func_195044_w().func_177229_b((Property)BlockStates.FACING);
        this.neighborChanged();
    }

    public void onDisassembly() {
        this.steamOutputDirection = null;
        this.transitionTank = null;
        this.neighborChanged();
    }

    static {
        SUPPLIER = ReactorCoolantPortTile::new;
        GAS_HANDLER_CAPABILITY = null;
    }
}

