/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.roguelogix.biggerreactors.client.Biselector;
import net.roguelogix.biggerreactors.client.CommonButton;
import net.roguelogix.biggerreactors.client.SelectorColors;
import net.roguelogix.biggerreactors.client.TextBox;
import net.roguelogix.biggerreactors.client.Triselector;
import net.roguelogix.biggerreactors.multiblocks.reactor.containers.ReactorRedstonePortContainer;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorRedstonePortSelection;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorRedstonePortState;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorRedstonePortTriggers;
import net.roguelogix.phosphophyllite.gui.client.ScreenBase;
import net.roguelogix.phosphophyllite.gui.client.elements.AbstractElement;
import net.roguelogix.phosphophyllite.gui.client.elements.Button;
import net.roguelogix.phosphophyllite.gui.client.elements.Symbol;

@OnlyIn(value=Dist.CLIENT)
public class ReactorRedstonePortScreen
extends ScreenBase<ReactorRedstonePortContainer> {
    private static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("biggerreactors", "textures/screen/reactor_redstone_port.png");
    private static final String[] INPUT_TRANSLATIONS = new String[]{"screen.biggerreactors.reactor_redstone_port.input_reactor_activity", "screen.biggerreactors.reactor_redstone_port.input_control_rod_insertion", "screen.biggerreactors.reactor_redstone_port.input_eject_waste"};
    private static final String[] OUTPUT_TRANSLATIONS = new String[]{"screen.biggerreactors.reactor_redstone_port.output_fuel_temp", "screen.biggerreactors.reactor_redstone_port.output_casing_temp", "screen.biggerreactors.reactor_redstone_port.output_fuel_enrichment", "screen.biggerreactors.reactor_redstone_port.output_fuel_amount", "screen.biggerreactors.reactor_redstone_port.output_waste_amount", "screen.biggerreactors.reactor_redstone_port.output_output_stored"};
    private ReactorRedstonePortState reactorRedstonePortState = (ReactorRedstonePortState)((ReactorRedstonePortContainer)this.func_212873_a_()).getGuiPacket();
    Button<ReactorRedstonePortContainer> applyChangesButton;
    Button<ReactorRedstonePortContainer> revertChangesButton;
    Biselector<ReactorRedstonePortContainer> triggerTypeToggle;
    Triselector<ReactorRedstonePortContainer> triggerModeToggle;
    TextBox<ReactorRedstonePortContainer> textBufferA;
    CommonButton<ReactorRedstonePortContainer> textEnterButtonA;
    TextBox<ReactorRedstonePortContainer> textBufferB;
    CommonButton<ReactorRedstonePortContainer> textEnterButtonB;
    Symbol<ReactorRedstonePortContainer> selectedTabSymbol;

    public ReactorRedstonePortScreen(ReactorRedstonePortContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, title, DEFAULT_TEXTURE, 200, 178);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.field_238742_p_ = this.getWidth() / 2 - this.getFont().func_238414_a_((ITextProperties)this.func_231171_q_()) / 2;
        this.initControls();
        this.initSymbols();
    }

    public void initControls() {
        int cI;
        int i = 0;
        while (i < 3) {
            cI = i++;
            Button inputTab = new Button((ScreenBase)this, 0, cI * 25, 25, 24, 206, cI * 24, (ITextComponent)new TranslationTextComponent(INPUT_TRANSLATIONS[cI] + ".tooltip"));
            inputTab.onMouseReleased = (mX, mY, btn) -> {
                if (inputTab.func_231047_b_(mX, mY)) {
                    ((ReactorRedstonePortContainer)this.func_212873_a_()).executeRequest("setSelectedTab", cI);
                    this.reactorRedstonePortState.selectedTab = ReactorRedstonePortSelection.fromInt(cI);
                    inputTab.playSound(SoundEvents.field_187909_gi);
                    return true;
                }
                return false;
            };
            inputTab.onRender = (mS, mX, mY) -> {
                if (inputTab.stateEnable) {
                    inputTab.blit(mS, 231, cI * 24);
                } else {
                    inputTab.blit(mS, 206, cI * 24);
                }
            };
            inputTab.onTick = () -> {
                inputTab.stateEnable = this.reactorRedstonePortState.selectedTab == ReactorRedstonePortSelection.fromInt(cI);
            };
            this.addElement((AbstractElement)inputTab);
        }
        i = 0;
        while (i < 6) {
            cI = i++;
            Button outputTab = new Button((ScreenBase)this, 175, cI * 25, 25, 24, 206, cI * 24 + 72, (ITextComponent)new TranslationTextComponent(OUTPUT_TRANSLATIONS[cI] + ".tooltip"));
            outputTab.onMouseReleased = (mX, mY, btn) -> {
                if (outputTab.func_231047_b_(mX, mY)) {
                    ((ReactorRedstonePortContainer)this.func_212873_a_()).executeRequest("setSelectedTab", cI + 3);
                    this.reactorRedstonePortState.selectedTab = ReactorRedstonePortSelection.fromInt(cI + 3);
                    outputTab.playSound(SoundEvents.field_187909_gi);
                    return true;
                }
                return false;
            };
            outputTab.onRender = (mS, mX, mY) -> {
                if (outputTab.stateEnable) {
                    outputTab.blit(mS, 231, cI * 24 + 72);
                } else {
                    outputTab.blit(mS, 206, cI * 24 + 72);
                }
            };
            outputTab.onTick = () -> {
                outputTab.stateEnable = this.reactorRedstonePortState.selectedTab == ReactorRedstonePortSelection.fromInt(cI + 3);
            };
            this.addElement((AbstractElement)outputTab);
        }
        this.applyChangesButton = new Button((ScreenBase)this, 156, 156, 15, 15, 226, 216, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.reactor_redstone_port.apply_changes.tooltip"));
        this.applyChangesButton.onMouseReleased = (mX, mY, btn) -> {
            if (this.applyChangesButton.func_231047_b_(mX, mY)) {
                if (this.reactorRedstonePortState.isInput()) {
                    ((ReactorRedstonePortContainer)this.func_212873_a_()).executeRequest("setTriggerPS", this.triggerTypeToggle.getState() != 0);
                } else {
                    ((ReactorRedstonePortContainer)this.func_212873_a_()).executeRequest("setTriggerAB", this.triggerTypeToggle.getState() != 0);
                }
                ((ReactorRedstonePortContainer)this.func_212873_a_()).executeRequest("setTriggerMode", this.triggerModeToggle.getState());
                ((ReactorRedstonePortContainer)this.func_212873_a_()).executeRequest("setTextBufferA", this.textBufferA.getContents().replaceAll("[^\\d.]", ""));
                ((ReactorRedstonePortContainer)this.func_212873_a_()).executeRequest("setTextBufferB", this.textBufferB.getContents().replaceAll("[^\\d.]", ""));
                ((ReactorRedstonePortContainer)this.func_212873_a_()).executeRequest("applyChanges", 0);
                this.applyChangesButton.playSound(SoundEvents.field_187909_gi);
                return true;
            }
            return false;
        };
        this.applyChangesButton.onRender = (mS, mX, mY) -> {
            if (this.applyChangesButton.func_231047_b_((double)mX, (double)mY)) {
                this.applyChangesButton.blit(mS, 241, 216);
            } else {
                this.applyChangesButton.blit(mS, 226, 216);
            }
        };
        this.addElement((AbstractElement)this.applyChangesButton);
        this.revertChangesButton = new Button((ScreenBase)this, 138, 156, 15, 15, 226, 231, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.reactor_redstone_port.revert_changes.tooltip"));
        this.revertChangesButton.onMouseReleased = (mX, mY, btn) -> {
            if (this.revertChangesButton.func_231047_b_(mX, mY)) {
                ((ReactorRedstonePortContainer)this.func_212873_a_()).executeRequest("revertChanges", 0);
                this.revertChangesButton.playSound(SoundEvents.field_187909_gi);
                return true;
            }
            return false;
        };
        this.revertChangesButton.onRender = (mS, mX, mY) -> {
            if (this.revertChangesButton.func_231047_b_((double)mX, (double)mY)) {
                this.revertChangesButton.blit(mS, 241, 231);
            } else {
                this.revertChangesButton.blit(mS, 226, 231);
            }
        };
        this.triggerTypeToggle = new Biselector<ReactorRedstonePortContainer>(this, 29, 42, StringTextComponent.field_240750_d_, () -> this.reactorRedstonePortState.triggerPS.toBool() || this.reactorRedstonePortState.triggerAB.toBool() ? 1 : 0, SelectorColors.YELLOW, SelectorColors.RED);
        this.triggerTypeToggle.onMouseReleased = (mX, mY, btn) -> {
            if (this.reactorRedstonePortState.isInput()) {
                ((ReactorRedstonePortContainer)this.func_212873_a_()).executeRequest("setTriggerPS", this.triggerTypeToggle.getState() == 0);
            } else {
                ((ReactorRedstonePortContainer)this.func_212873_a_()).executeRequest("setTriggerAB", this.triggerTypeToggle.getState() == 0);
            }
            return true;
        };
        this.triggerTypeToggle.onTick = () -> {
            this.triggerTypeToggle.tooltip = this.reactorRedstonePortState.isInput() ? new TranslationTextComponent("screen.biggerreactors.reactor_redstone_port.trigger_type_toggle.ps.tooltip") : new TranslationTextComponent("screen.biggerreactors.reactor_redstone_port.trigger_type_toggle.ab.tooltip");
        };
        this.addElement((AbstractElement)this.triggerTypeToggle);
        this.triggerModeToggle = new Triselector<ReactorRedstonePortContainer>(this, 29, 58, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.reactor_terminal.auto_eject_toggle.tooltip"), () -> this.reactorRedstonePortState.triggerMode, SelectorColors.GREEN, SelectorColors.RED, SelectorColors.YELLOW);
        this.triggerModeToggle.onMouseReleased = (mX, mY, btn) -> {
            ((ReactorRedstonePortContainer)this.func_212873_a_()).executeRequest("setTriggerMode", this.triggerModeToggle.getState());
            return true;
        };
        this.addElement((AbstractElement)this.triggerModeToggle);
        this.textBufferA = new TextBox<ReactorRedstonePortContainer>(this, this.field_230712_o_, 27, 91, 96, 16, this.reactorRedstonePortState.textBufferA);
        this.addElement((AbstractElement)this.textBufferA);
        this.textEnterButtonA = new CommonButton<ReactorRedstonePortContainer>(this, 135, 92, 17, 14, 61, 130, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.reactor_redstone_port.apply.tooltip"));
        this.textEnterButtonA.onMouseReleased = (mX, mY, btn) -> {
            ((ReactorRedstonePortContainer)this.func_212873_a_()).executeRequest("setTextBufferA", this.textBufferA.getContents().replaceAll("[^\\d.]", ""));
            return true;
        };
        this.addElement((AbstractElement)this.textEnterButtonA);
        this.textBufferB = new TextBox<ReactorRedstonePortContainer>(this, this.field_230712_o_, 27, 122, 96, 16, this.reactorRedstonePortState.textBufferB);
        this.addElement((AbstractElement)this.textBufferB);
        this.textEnterButtonB = new CommonButton<ReactorRedstonePortContainer>(this, 135, 123, 17, 14, 61, 130, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.reactor_redstone_port.apply.tooltip"));
        this.textEnterButtonB.onMouseReleased = (mX, mY, btn) -> {
            ((ReactorRedstonePortContainer)this.func_212873_a_()).executeRequest("setTextBufferB", this.textBufferB.getContents().replaceAll("[^\\d.]", ""));
            return true;
        };
        this.addElement((AbstractElement)this.textEnterButtonB);
    }

    public void initSymbols() {
        this.selectedTabSymbol = new Symbol((ScreenBase)this, 92, 20, 16, 16, 25, 4, StringTextComponent.field_240750_d_);
        this.selectedTabSymbol.onTick = () -> {
            this.selectedTabSymbol.tooltip = new TranslationTextComponent(this.reactorRedstonePortState.isInput() ? INPUT_TRANSLATIONS[this.reactorRedstonePortState.selectedTab.toInt()] : OUTPUT_TRANSLATIONS[this.reactorRedstonePortState.selectedTab.toInt() - 3]);
            this.selectedTabSymbol.u = this.reactorRedstonePortState.isInput() ? 235 : 236;
            this.selectedTabSymbol.v = this.reactorRedstonePortState.selectedTab.toInt() * 24 + 4;
        };
        this.addElement((AbstractElement)this.selectedTabSymbol);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        switch (this.reactorRedstonePortState.selectedTab) {
            case INPUT_CONTROL_ROD_INSERTION: {
                this.textBufferA.actionEnable = true;
                this.textEnterButtonA.actionEnable = true;
                if (this.reactorRedstonePortState.triggerPS == ReactorRedstonePortTriggers.PULSE_OR_ABOVE) {
                    this.triggerModeToggle.actionEnable = true;
                    this.textBufferB.actionEnable = false;
                    this.textBufferB.clear();
                    this.textEnterButtonB.actionEnable = false;
                    break;
                }
                this.triggerModeToggle.actionEnable = false;
                this.textBufferB.actionEnable = true;
                this.textEnterButtonB.actionEnable = true;
                break;
            }
            case OUTPUT_FUEL_TEMP: 
            case OUTPUT_CASING_TEMP: 
            case OUTPUT_FUEL_ENRICHMENT: 
            case OUTPUT_FUEL_AMOUNT: 
            case OUTPUT_WASTE_AMOUNT: 
            case OUTPUT_ENERGY_AMOUNT: {
                this.triggerModeToggle.actionEnable = false;
                this.textBufferA.actionEnable = true;
                this.textEnterButtonA.actionEnable = true;
                this.textBufferB.actionEnable = false;
                this.textBufferB.clear();
                this.textEnterButtonB.actionEnable = false;
                break;
            }
            default: {
                this.triggerModeToggle.actionEnable = false;
                if (this.textBufferA.actionEnable || this.textEnterButtonA.actionEnable) {
                    this.textBufferA.clear();
                    this.textBufferA.actionEnable = false;
                    this.textEnterButtonA.actionEnable = false;
                }
                if (!this.textBufferB.actionEnable && !this.textEnterButtonB.actionEnable) break;
                this.textBufferB.clear();
                this.textBufferB.actionEnable = false;
                this.textEnterButtonB.actionEnable = false;
            }
        }
    }

    public void func_230430_a_(@Nonnull MatrixStack mStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(mStack, mouseX, mouseY, partialTicks);
        if (this.reactorRedstonePortState.isInput()) {
            if (this.reactorRedstonePortState.triggerPS == ReactorRedstonePortTriggers.PULSE_OR_ABOVE) {
                this.getFont().func_238421_b_(mStack, new TranslationTextComponent("screen.biggerreactors.reactor_redstone_port.trigger_type_toggle.ps.on_pulse").getString(), (float)(this.getGuiLeft() + 63), (float)(this.getGuiTop() + 45), 0x404040);
            } else {
                this.getFont().func_238421_b_(mStack, new TranslationTextComponent("screen.biggerreactors.reactor_redstone_port.trigger_type_toggle.ps.on_signal").getString(), (float)(this.getGuiLeft() + 63), (float)(this.getGuiTop() + 45), 0x404040);
            }
        } else if (this.reactorRedstonePortState.triggerAB == ReactorRedstonePortTriggers.PULSE_OR_ABOVE) {
            this.getFont().func_238421_b_(mStack, new TranslationTextComponent("screen.biggerreactors.reactor_redstone_port.trigger_type_toggle.ab.while_above").getString(), (float)(this.getGuiLeft() + 63), (float)(this.getGuiTop() + 45), 0x404040);
        } else {
            this.getFont().func_238421_b_(mStack, new TranslationTextComponent("screen.biggerreactors.reactor_redstone_port.trigger_type_toggle.ab.while_below").getString(), (float)(this.getGuiLeft() + 63), (float)(this.getGuiTop() + 45), 0x404040);
        }
        switch (this.reactorRedstonePortState.selectedTab) {
            case INPUT_CONTROL_ROD_INSERTION: {
                if (this.reactorRedstonePortState.triggerPS == ReactorRedstonePortTriggers.PULSE_OR_ABOVE) {
                    if (this.reactorRedstonePortState.triggerMode == 0) {
                        this.getFont().func_238421_b_(mStack, new TranslationTextComponent("screen.biggerreactors.reactor_redstone_port.trigger_mode_toggle.mode_a").getString(), (float)(this.getGuiLeft() + 80), (float)(this.getGuiTop() + 62), 0x404040);
                        this.getFont().func_238421_b_(mStack, new TranslationTextComponent("screen.biggerreactors.reactor_redstone_port.text_buffer_a.mode_a").getString(), (float)(this.getGuiLeft() + 29), (float)(this.getGuiTop() + 82), 0x404040);
                        break;
                    }
                    if (this.reactorRedstonePortState.triggerMode == 1) {
                        this.getFont().func_238421_b_(mStack, new TranslationTextComponent("screen.biggerreactors.reactor_redstone_port.trigger_mode_toggle.mode_b").getString(), (float)(this.getGuiLeft() + 80), (float)(this.getGuiTop() + 62), 0x404040);
                        this.getFont().func_238421_b_(mStack, new TranslationTextComponent("screen.biggerreactors.reactor_redstone_port.text_buffer_a.mode_b").getString(), (float)(this.getGuiLeft() + 29), (float)(this.getGuiTop() + 82), 0x404040);
                        break;
                    }
                    this.getFont().func_238421_b_(mStack, new TranslationTextComponent("screen.biggerreactors.reactor_redstone_port.trigger_mode_toggle.mode_c").getString(), (float)(this.getGuiLeft() + 80), (float)(this.getGuiTop() + 62), 0x404040);
                    this.getFont().func_238421_b_(mStack, new TranslationTextComponent("screen.biggerreactors.reactor_redstone_port.text_buffer_a.mode_c").getString(), (float)(this.getGuiLeft() + 29), (float)(this.getGuiTop() + 82), 0x404040);
                    break;
                }
                this.getFont().func_238421_b_(mStack, new TranslationTextComponent("screen.biggerreactors.reactor_redstone_port.input_control_rod_insertion.while_on").getString(), (float)(this.getGuiLeft() + 29), (float)(this.getGuiTop() + 82), 0x404040);
                this.getFont().func_238421_b_(mStack, new TranslationTextComponent("screen.biggerreactors.reactor_redstone_port.input_control_rod_insertion.while_off").getString(), (float)(this.getGuiLeft() + 29), (float)(this.getGuiTop() + 113), 0x404040);
                break;
            }
            case OUTPUT_FUEL_TEMP: 
            case OUTPUT_CASING_TEMP: {
                this.getFont().func_238421_b_(mStack, new TranslationTextComponent("screen.biggerreactors.reactor_redstone_port.text_buffer_a.trigger_at").getString(), (float)(this.getGuiLeft() + 29), (float)(this.getGuiTop() + 82), 0x404040);
                this.getFont().func_238421_b_(mStack, "\u00b0C", (float)(this.getGuiLeft() + 155), (float)(this.getGuiTop() + 96), 0x404040);
                break;
            }
            case OUTPUT_FUEL_ENRICHMENT: 
            case OUTPUT_ENERGY_AMOUNT: {
                this.getFont().func_238421_b_(mStack, new TranslationTextComponent("screen.biggerreactors.reactor_redstone_port.text_buffer_a.trigger_at").getString(), (float)(this.getGuiLeft() + 29), (float)(this.getGuiTop() + 82), 0x404040);
                this.getFont().func_238421_b_(mStack, "%", (float)(this.getGuiLeft() + 155), (float)(this.getGuiTop() + 96), 0x404040);
                break;
            }
            case OUTPUT_FUEL_AMOUNT: 
            case OUTPUT_WASTE_AMOUNT: {
                this.getFont().func_238421_b_(mStack, new TranslationTextComponent("screen.biggerreactors.reactor_redstone_port.text_buffer_a.trigger_at").getString(), (float)(this.getGuiLeft() + 29), (float)(this.getGuiTop() + 82), 0x404040);
                this.getFont().func_238421_b_(mStack, "mB", (float)(this.getGuiLeft() + 155), (float)(this.getGuiTop() + 96), 0x404040);
            }
        }
    }
}

