/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.machine.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.roguelogix.biggerreactors.client.CommonRender;
import net.roguelogix.biggerreactors.machine.containers.CyaniteReprocessorContainer;
import net.roguelogix.biggerreactors.machine.state.CyaniteReprocessorState;
import net.roguelogix.phosphophyllite.gui.client.RenderHelper;
import net.roguelogix.phosphophyllite.gui.client.ScreenBase;
import net.roguelogix.phosphophyllite.gui.client.elements.AbstractElement;
import net.roguelogix.phosphophyllite.gui.client.elements.Symbol;
import net.roguelogix.phosphophyllite.gui.client.elements.Tooltip;

public class CyaniteReprocessorScreen
extends ScreenBase<CyaniteReprocessorContainer> {
    private static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("biggerreactors", "textures/screen/cyanite_reprocessor.png");
    private CyaniteReprocessorState cyaniteReprocessorState = (CyaniteReprocessorState)((CyaniteReprocessorContainer)this.func_212873_a_()).getGuiPacket();

    public CyaniteReprocessorScreen(CyaniteReprocessorContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, title, DEFAULT_TEXTURE, 176, 175);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.field_238742_p_ = this.getWidth() / 2 - this.getFont().func_238414_a_((ITextProperties)this.func_231171_q_()) / 2;
        this.initTooltips();
        this.initGauges();
        this.initSymbols();
    }

    public void initTooltips() {
        this.addElement((AbstractElement)new Tooltip((ScreenBase)this, 8, 6, 16, 16, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.cyanite_reprocessor.internal_battery.tooltip")));
    }

    public void initGauges() {
        Symbol internalBattery = new Symbol((ScreenBase)this, 7, 25, 18, 64, 0, 152, StringTextComponent.field_240750_d_);
        internalBattery.onRender = (mS, mX, mY) -> CommonRender.renderEnergyGauge(mS, internalBattery, this.cyaniteReprocessorState.energyStored, this.cyaniteReprocessorState.energyCapacity);
        this.addElement((AbstractElement)internalBattery);
        Symbol waterTank = new Symbol((ScreenBase)this, 151, 25, 18, 64, 0, 152, StringTextComponent.field_240750_d_);
        waterTank.onRender = (mS, mX, mY) -> CommonRender.renderFluidGauge(mS, waterTank, this.cyaniteReprocessorState.waterStored, this.cyaniteReprocessorState.waterCapacity, Fluids.field_204546_a.func_210198_f());
        this.addElement((AbstractElement)waterTank);
        Symbol progressBar = new Symbol((ScreenBase)this, 75, 40, 24, 18, 0, 175, null);
        progressBar.onRender = (mS, mX, mY) -> CyaniteReprocessorScreen.renderProgressBar(mS, (Symbol<CyaniteReprocessorContainer>)progressBar, this.cyaniteReprocessorState.workTime, this.cyaniteReprocessorState.workTimeTotal);
        this.addElement((AbstractElement)progressBar);
    }

    public void initSymbols() {
        Symbol waterTankSymbol = new Symbol((ScreenBase)this, 152, 6, 16, 16, 48, 175, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.cyanite_reprocessor.water_tank.tooltip"));
        waterTankSymbol.onRender = (mS, mX, mY) -> RenderHelper.drawMaskedFluid((MatrixStack)mS, (int)waterTankSymbol.x, (int)waterTankSymbol.y, (int)this.func_230927_p_(), (int)waterTankSymbol.width, (int)waterTankSymbol.height, (int)waterTankSymbol.u, (int)waterTankSymbol.v, (Fluid)Fluids.field_204546_a.func_210198_f());
        this.addElement((AbstractElement)waterTankSymbol);
    }

    private static void renderProgressBar(@Nonnull MatrixStack mStack, @Nonnull Symbol<CyaniteReprocessorContainer> symbol, int workTime, int workTimeTotal) {
        if (workTime > 0 && workTimeTotal > 0) {
            int renderSize = symbol.width * workTime / workTimeTotal;
            symbol.blit(mStack, renderSize, symbol.height, symbol.u + 24, symbol.v);
        }
    }
}

