/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftGenerator;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftStructurePieceType;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.MineshaftVariantSettings;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.MineshaftPiece;
import com.yungnickyoung.minecraft.yungsapi.world.BoundingBoxHelper;
import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.PoweredRailBlock;
import net.minecraft.block.RailBlock;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.RailShape;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class SmallTunnelStairs
extends MineshaftPiece {
    private static final int SECONDARY_AXIS_LEN = 5;
    private static final int Y_AXIS_LEN = 9;
    private static final int MAIN_AXIS_LEN = 5;
    private static final int LOCAL_X_END = 4;
    private static final int LOCAL_Y_END = 8;
    private static final int LOCAL_Z_END = 4;

    public SmallTunnelStairs(TemplateManager structureManager, CompoundNBT compoundTag) {
        super(BetterMineshaftStructurePieceType.SMALL_TUNNEL_STAIRS, compoundTag);
    }

    public SmallTunnelStairs(int chainLength, Random random, MutableBoundingBox blockBox, Direction direction, MineshaftVariantSettings settings) {
        super(BetterMineshaftStructurePieceType.SMALL_TUNNEL_STAIRS, chainLength, settings);
        this.func_186164_a(direction);
        this.field_74887_e = blockBox;
    }

    @ParametersAreNonnullByDefault
    protected void func_143011_b(CompoundNBT tag) {
        super.toNbt(tag);
    }

    public static MutableBoundingBox determineBoxPosition(List<StructurePiece> list, Random random, int x, int y, int z, Direction direction) {
        MutableBoundingBox blockBox = BoundingBoxHelper.boxFromCoordsWithRotation((int)x, (int)y, (int)z, (int)5, (int)9, (int)5, (Direction)direction);
        StructurePiece intersectingPiece = StructurePiece.func_74883_a(list, (MutableBoundingBox)blockBox);
        return intersectingPiece != null ? null : blockBox;
    }

    @Override
    public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
        Direction direction = this.func_186165_e();
        if (direction == null) {
            return;
        }
        switch (direction) {
            default: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b + 4, this.field_74887_e.field_78896_c - 1, direction, this.chainLength);
                break;
            }
            case SOUTH: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b + 4, this.field_74887_e.field_78892_f + 1, direction, this.chainLength);
                break;
            }
            case WEST: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + 4, this.field_74887_e.field_78892_f, direction, this.chainLength);
                break;
            }
            case EAST: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + 4, this.field_74887_e.field_78896_c, direction, this.chainLength);
            }
        }
    }

    @ParametersAreNonnullByDefault
    public boolean func_230383_a_(ISeedReader world, StructureManager structureManager, ChunkGenerator generator, Random random, MutableBoundingBox box, ChunkPos pos, BlockPos blockPos) {
        if (this.func_74860_a((IBlockReader)world, box)) {
            return false;
        }
        if (this.isInOcean(world, 0, 0) || this.isInOcean(world, 4, 4)) {
            return false;
        }
        this.chanceReplaceNonAir(world, box, random, this.settings.replacementRate, 0, 1, 0, 4, 8, 4, this.getMainSelector());
        this.chanceReplaceNonAir(world, box, random, this.settings.replacementRate, 0, 0, 0, 4, 0, 4, this.getFloorSelector());
        for (int i = 0; i < 5; ++i) {
            this.fill(world, box, 1, i + 1, i, 3, i + 1 + 2, i, field_202556_l);
            this.chanceReplaceNonAir(world, box, random, 0.5f, 1, i, i, 3, i, i, this.getMainSelector());
            this.replaceAir(world, box, 1, i, i, 3, i, i, this.getMainBlock());
            if (i == 0) {
                this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_196552_aC.func_176223_P().func_206870_a((Property)PoweredRailBlock.field_176569_M, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)PoweredRailBlock.field_176568_b, (Comparable)RailShape.ASCENDING_NORTH), 2, i + 1, i, box);
            } else if (i == 4) {
                this.func_175811_a(world, (BlockState)Blocks.field_150448_aq.func_176223_P().func_206870_a((Property)RailBlock.field_176565_b, (Comparable)RailShape.NORTH_SOUTH), 2, i + 1, i, box);
            } else {
                this.func_175811_a(world, (BlockState)Blocks.field_150448_aq.func_176223_P().func_206870_a((Property)RailBlock.field_176565_b, (Comparable)RailShape.ASCENDING_NORTH), 2, i + 1, i, box);
            }
            this.func_175811_a(world, this.getMainBlock(), 2, i, i, box);
        }
        this.addBiomeDecorations(world, box, random, 0, 0, 0, 4, 7, 4);
        this.addVines(world, box, random, this.settings.vineChance, 1, 0, 1, 3, 8, 3);
        return true;
    }
}

