/*
 * Decompiled with CFR 0.152.
 */
package commoble.bagofyurting.storage;

import commoble.bagofyurting.BagOfYurtingData;
import commoble.bagofyurting.CompressedBagOfYurtingData;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.FolderName;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StorageManager {
    private static final Logger LOGGER = LogManager.getLogger(StorageManager.class);
    private static final Queue<Pair<String, BagOfYurtingData>> dataToSave = new LinkedBlockingQueue<Pair<String, BagOfYurtingData>>();
    private static final Map<String, BagOfYurtingData> dirtyMap = new HashMap<String, BagOfYurtingData>();
    private static final Queue<String> dataToRemove = new LinkedBlockingQueue<String>();

    public static void save(String id, BagOfYurtingData data) {
        dataToSave.add((Pair<String, BagOfYurtingData>)Pair.of((Object)id, (Object)data));
        dirtyMap.put(id, data);
        dataToRemove.remove(id);
    }

    public static void remove(String id) {
        dirtyMap.remove(id);
        if (!dataToSave.removeIf(pair -> ((String)pair.getLeft()).equals(id))) {
            dataToRemove.add(id);
        }
    }

    @Nullable
    public static BagOfYurtingData load(MinecraftServer server, String id) {
        CompoundNBT nbt;
        if (dirtyMap.containsKey(id)) {
            return dirtyMap.get(id);
        }
        Path directory = StorageManager.getSaveDirectory(server);
        if (directory == null) {
            return null;
        }
        Path file = directory.resolve(id + ".dat");
        if (!Files.exists(file, new LinkOption[0])) {
            return null;
        }
        try {
            nbt = CompressedStreamTools.func_244263_a((File)file.toFile());
        }
        catch (IOException e) {
            LOGGER.error("Unable to load save data for Bag of Yurting:", (Throwable)e);
            return null;
        }
        return CompressedBagOfYurtingData.fromNBT(nbt).uncompress();
    }

    public static boolean has(MinecraftServer server, String id) {
        if (dirtyMap.containsKey(id)) {
            return true;
        }
        Path directory = StorageManager.getSaveDirectory(server);
        if (directory == null) {
            return false;
        }
        return Files.exists(directory.resolve(id + ".dat"), new LinkOption[0]);
    }

    public static void onSave(ServerWorld world) {
        StorageManager.profile(world, "onSave", () -> {
            Path saveDirectory = StorageManager.getSaveDirectory(world.func_73046_m());
            if (saveDirectory == null) {
                return;
            }
            StorageManager.profile(world, "saveQueued", () -> StorageManager.saveQueued(saveDirectory));
            StorageManager.profile(world, "removeQueued", () -> StorageManager.removeQueued(saveDirectory));
        });
    }

    private static void saveQueued(Path saveDirectory) {
        ArrayList<Pair<String, BagOfYurtingData>> toReSave = new ArrayList<Pair<String, BagOfYurtingData>>(dataToSave.size());
        while (!dataToSave.isEmpty()) {
            Pair<String, BagOfYurtingData> pair = dataToSave.poll();
            Path file = saveDirectory.resolve((String)pair.getLeft() + ".dat");
            CompressedBagOfYurtingData data = ((BagOfYurtingData)pair.getRight()).compress();
            CompoundNBT nbt = data.toNBT();
            try {
                CompressedStreamTools.func_244264_a((CompoundNBT)nbt, (File)file.toFile());
                dirtyMap.remove(pair.getLeft());
            }
            catch (IOException e) {
                LOGGER.error("Could not save Bag of Yurting data with id: " + (String)pair.getLeft());
                toReSave.add(pair);
            }
        }
        dataToSave.addAll(toReSave);
    }

    private static void removeQueued(Path saveDirectory) {
        ArrayList<String> failedRemove = new ArrayList<String>(dataToRemove.size());
        while (!dataToRemove.isEmpty()) {
            String id = dataToRemove.poll();
            Path file = saveDirectory.resolve(id + ".dat").toAbsolutePath();
            try {
                Files.delete(file);
            }
            catch (IOException e) {
                LOGGER.error("Could not delete Bag of Yurting data with id: " + id, (Throwable)e);
                failedRemove.add(id);
            }
        }
        dataToRemove.addAll(failedRemove);
    }

    @Nullable
    private static Path getSaveDirectory(MinecraftServer server) {
        Path dir = server.func_240776_a_(new FolderName("bagofyurting"));
        if (!Files.exists(dir, new LinkOption[0])) {
            try {
                Files.createDirectory(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.error("Failed to create Bag of Yurting mod folder: " + dir, (Throwable)e);
                return null;
            }
        }
        return dir;
    }

    private static void profile(ServerWorld world, String name, Runnable runnable) {
        world.func_217381_Z().func_76320_a("bagofyurting#" + name);
        runnable.run();
        world.func_217381_Z().func_76319_b();
    }
}

