/*
 * Decompiled with CFR 0.152.
 */
package com.thenatekirby.babel.util;

import com.thenatekirby.babel.Babel;
import com.thenatekirby.babel.api.IBlockReplacement;
import com.thenatekirby.babel.mixin.StateContainerMixin;
import com.thenatekirby.babel.mixin.StateHolderMixin;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.StateContainer;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegistrationUtil {
    public static boolean overrideExistingBlock(@Nonnull Block block, final String modId) {
        Block existing = (Block)ForgeRegistries.BLOCKS.getValue(block.getRegistryName());
        if (existing == null) {
            Babel.getLogger().error("Unable to find block {}", (Object)block.getRegistryName());
            return false;
        }
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        ForgeRegistries.ITEMS.register(new BlockItem(block, new Item.Properties().func_200916_a(Objects.requireNonNull(existing.func_199767_j().func_77640_w()))){

            public String getCreatorModId(ItemStack itemStack) {
                return modId;
            }
        }.setRegistryName(Objects.requireNonNull(block.getRegistryName())));
        return true;
    }

    public static <B extends Block> void overrideBlockstates(@Nonnull Block oldBlock, @Nonnull B newBlock) {
        ((IBlockReplacement)newBlock).overrideStateContainer((StateContainer<Block, BlockState>)oldBlock.func_176194_O());
        ((IBlockReplacement)newBlock).overrideDefaultState(oldBlock.func_176223_P());
        ((StateContainerMixin)newBlock.func_176194_O()).setOwner(newBlock);
        newBlock.func_176194_O().func_177619_a().forEach(blockState -> ((StateHolderMixin)blockState).setInstance(newBlock));
    }
}

