/*
 * Decompiled with CFR 0.152.
 */
package com.thenatekirby.babel.recipe.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.thenatekirby.babel.condition.IRecipeCondition;
import com.thenatekirby.babel.core.RecipeIngredient;
import com.thenatekirby.babel.mod.BabelSerializers;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.ResourceLocation;

public class TaggedShapelessRecipeBuilder {
    private final ResourceLocation recipeId;
    private RecipeIngredient result;
    private List<RecipeIngredient> ingredients = new ArrayList<RecipeIngredient>();
    private List<JsonObject> conditions = new ArrayList<JsonObject>();

    private TaggedShapelessRecipeBuilder(@Nonnull ResourceLocation recipeId) {
        this.recipeId = recipeId;
    }

    public static TaggedShapelessRecipeBuilder builder(@Nonnull ResourceLocation recipeId) {
        return new TaggedShapelessRecipeBuilder(recipeId);
    }

    public TaggedShapelessRecipeBuilder withInput(RecipeIngredient ingredient) {
        this.ingredients.add(ingredient);
        return this;
    }

    public TaggedShapelessRecipeBuilder withInput(RecipeIngredient ingredient, int count) {
        for (int idx = 0; idx < count; ++idx) {
            this.ingredients.add(ingredient);
        }
        return this;
    }

    public TaggedShapelessRecipeBuilder withOutput(RecipeIngredient result) {
        this.result = result;
        return this;
    }

    public TaggedShapelessRecipeBuilder withCondition(IRecipeCondition condition) {
        this.conditions.add(condition.serializeJson());
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumer) {
        consumer.accept(new Result(this.recipeId, this.ingredients, this.result, this.conditions));
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation recipeId;
        private final List<RecipeIngredient> ingredients;
        private final RecipeIngredient result;
        private final List<JsonObject> conditions;

        Result(@Nonnull ResourceLocation recipeId, @Nonnull List<RecipeIngredient> ingredients, RecipeIngredient result, @Nonnull List<JsonObject> conditions) {
            this.recipeId = recipeId;
            this.ingredients = ingredients;
            this.result = result;
            this.conditions = conditions;
        }

        public void func_218610_a(@Nonnull JsonObject json) {
            if (!this.conditions.isEmpty()) {
                JsonArray conditions = new JsonArray();
                for (JsonObject condition : this.conditions) {
                    conditions.add((JsonElement)condition);
                }
                json.add("conditions", (JsonElement)conditions);
            }
            JsonArray jsonarray = new JsonArray();
            for (RecipeIngredient ingredient : this.ingredients) {
                jsonarray.add((JsonElement)ingredient.serializeJson());
            }
            json.add("ingredients", (JsonElement)jsonarray);
            json.add("result", (JsonElement)this.result.serializeJson());
        }

        @Nonnull
        public IRecipeSerializer<?> func_218609_c() {
            return BabelSerializers.TAGGED_SHAPELESS.getAsRecipeSerializer();
        }

        @Nonnull
        public ResourceLocation func_200442_b() {
            return this.recipeId;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

