/*
 * Decompiled with CFR 0.152.
 */
package com.thenatekirby.babel.recipe.builder;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.thenatekirby.babel.condition.IRecipeCondition;
import com.thenatekirby.babel.core.RecipeIngredient;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class ShapedRecipeBuilder {
    private final ResourceLocation recipeId;
    private String result;
    private int count;
    private final List<String> pattern = Lists.newArrayList();
    private final Map<Character, RecipeIngredient> key = Maps.newLinkedHashMap();
    private final List<IRecipeCondition> conditions = Lists.newArrayList();

    private ShapedRecipeBuilder(@Nonnull ResourceLocation recipeId) {
        this.recipeId = recipeId;
    }

    public static ShapedRecipeBuilder builder(@Nonnull ResourceLocation recipeId) {
        return new ShapedRecipeBuilder(recipeId);
    }

    public ShapedRecipeBuilder withPatternLine(String patternLine) {
        this.pattern.add(patternLine);
        return this;
    }

    public ShapedRecipeBuilder withKey(Character key, RecipeIngredient ingredient) {
        this.key.put(key, ingredient);
        return this;
    }

    public ShapedRecipeBuilder withResult(String result, int count) {
        this.result = result;
        this.count = count;
        return this;
    }

    public ShapedRecipeBuilder withResult(String result) {
        return this.withResult(result, 1);
    }

    public ShapedRecipeBuilder withResult(IItemProvider itemProvider) {
        return this.withResult(itemProvider, 1);
    }

    public ShapedRecipeBuilder withResult(IItemProvider itemProvider, int count) {
        return this.withResult(Objects.requireNonNull(itemProvider.func_199767_j().getRegistryName()).toString(), count);
    }

    public ShapedRecipeBuilder withCondition(IRecipeCondition condition) {
        this.conditions.add(condition);
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumerIn) {
        consumerIn.accept(new Result(this.recipeId, this.pattern, this.key, this.result, this.conditions, this.count));
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation recipeId;
        private final List<String> pattern;
        private final Map<Character, RecipeIngredient> key;
        private final String result;
        private final List<IRecipeCondition> conditions;
        private final int count;

        public Result(ResourceLocation recipeId, List<String> pattern, Map<Character, RecipeIngredient> key, String result, List<IRecipeCondition> conditions, int count) {
            this.recipeId = recipeId;
            this.pattern = pattern;
            this.key = key;
            this.result = result;
            this.conditions = conditions;
            this.count = count;
        }

        public void func_218610_a(@Nonnull JsonObject json) {
            JsonArray patternJson = new JsonArray();
            for (String string : this.pattern) {
                patternJson.add(string);
            }
            json.add("pattern", (JsonElement)patternJson);
            JsonObject keyJson = new JsonObject();
            for (Map.Entry<Character, RecipeIngredient> entry : this.key.entrySet()) {
                keyJson.add(String.valueOf(entry.getKey()), (JsonElement)entry.getValue().serializeJson());
            }
            json.add("key", (JsonElement)keyJson);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", this.result);
            if (this.count > 1) {
                jsonObject.addProperty("count", (Number)this.count);
            }
            if (!this.conditions.isEmpty()) {
                JsonArray jsonArray = new JsonArray();
                for (IRecipeCondition condition : this.conditions) {
                    jsonArray.add((JsonElement)condition.serializeJson());
                }
                json.add("conditions", (JsonElement)jsonArray);
            }
            json.add("result", (JsonElement)jsonObject);
        }

        @Nonnull
        public IRecipeSerializer<?> func_218609_c() {
            return IRecipeSerializer.field_222157_a;
        }

        @Nonnull
        public ResourceLocation func_200442_b() {
            return this.recipeId;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

